/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.ImagesToStack;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.util.ArrayList;

public class StackEditor
implements PlugIn {
    ImagePlus imp;
    int nSlices;
    int width;
    int height;

    public void run(String arg) {
        this.imp = IJ.getImage();
        this.nSlices = this.imp.getStackSize();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (arg.equals("add")) {
            this.addSlice();
        } else if (arg.equals("delete")) {
            this.deleteSlice();
        } else if (arg.equals("toimages")) {
            this.convertStackToImages(this.imp);
        }
    }

    void addSlice() {
        if (this.imp.isHyperStack() || this.imp.isComposite() && this.nSlices == this.imp.getNChannels()) {
            this.addHyperstackChannelSliceOrFrame();
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        int id = 0;
        ImageStack stack = this.imp.getStack();
        if (stack.getSize() == 1) {
            Object obj;
            String label = stack.getSliceLabel(1);
            if (label != null && label.indexOf("\n") != -1) {
                stack.setSliceLabel(null, 1);
            }
            if ((obj = this.imp.getProperty("Label")) != null && obj instanceof String) {
                stack.setSliceLabel((String)obj, 1);
            }
            id = this.imp.getID();
        }
        ImageProcessor ip = this.imp.getProcessor();
        int n = this.imp.getCurrentSlice();
        if (IJ.altKeyDown()) {
            --n;
        }
        stack.addSlice(null, ip.createProcessor(this.width, this.height), n);
        this.imp.setStack(null, stack);
        this.imp.setSlice(n + 1);
        this.imp.unlock();
        this.imp.changes = true;
        if (id != 0) {
            IJ.selectWindow(id);
        }
    }

    void deleteSlice() {
        String label;
        if (this.nSlices < 2) {
            IJ.error("\"Delete Slice\" requires a stack");
            return;
        }
        if (this.imp.isHyperStack() || this.imp.isComposite() && this.nSlices == this.imp.getNChannels()) {
            this.deleteHyperstackChannelSliceOrFrame();
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        stack.deleteSlice(n);
        if (stack.getSize() == 1 && (label = stack.getSliceLabel(1)) != null) {
            this.imp.setProperty("Label", label);
        }
        this.imp.setStack(null, stack);
        if (n-- < 1) {
            n = 1;
        }
        this.imp.setSlice(n);
        this.imp.unlock();
        this.imp.changes = true;
    }

    void addHyperstackChannelSliceOrFrame() {
        int index;
        int channels = this.imp.getNChannels();
        int slices = this.imp.getNSlices();
        int frames = this.imp.getNFrames();
        int c1 = this.imp.getChannel();
        int z1 = this.imp.getSlice();
        int t1 = this.imp.getFrame();
        ArrayList<String> list = new ArrayList<String>();
        if (channels > 1) {
            list.add("channel");
        }
        if (slices > 1) {
            list.add("slice");
        }
        if (frames > 1) {
            list.add("frame");
        }
        String[] choices = new String[list.size()];
        list.toArray(choices);
        String choice = choices[0];
        if (frames > 1 && slices == 1) {
            choice = "frame";
        } else if (slices > 1) {
            choice = "slice";
        }
        GenericDialog gd = new GenericDialog("Add");
        gd.addChoice("Add", choices, choice);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        choice = gd.getNextChoice();
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        LUT[] luts = null;
        if (choice.equals("frame")) {
            index = this.imp.getStackIndex(channels, slices, t1);
            int i = 0;
            while (i < channels * slices) {
                ImageProcessor ip = stack.getProcessor(1).duplicate();
                ip.setColor(0);
                ip.fill();
                stack.addSlice(null, ip, index);
                ++i;
            }
            ++frames;
        } else if (choice.equals("slice")) {
            int t = frames;
            while (t >= 1) {
                int index2 = this.imp.getStackIndex(channels, z1, t);
                int i = 0;
                while (i < channels) {
                    ImageProcessor ip = stack.getProcessor(1).duplicate();
                    ip.setColor(0);
                    ip.fill();
                    stack.addSlice(null, ip, index2);
                    ++i;
                }
                --t;
            }
            ++slices;
        } else if (choice.equals("channel")) {
            if (this.imp.isComposite()) {
                luts = ((CompositeImage)this.imp).getLuts();
            }
            index = this.imp.getStackIndex(c1, slices, frames);
            while (index > 0) {
                ImageProcessor ip = stack.getProcessor(1).duplicate();
                ip.setColor(0);
                ip.fill();
                stack.addSlice(null, ip, index);
                index -= channels;
            }
            ++channels;
        }
        this.imp.setStack(stack, channels, slices, frames);
        if (luts != null) {
            LUT[] luts2 = new LUT[luts.length + 1];
            int index3 = 0;
            int i = 0;
            while (i < luts2.length) {
                luts2[i] = i == c1 ? LUT.createLutFromColor(Color.white) : luts[index3++];
                ++i;
            }
            CompositeImage cimp = (CompositeImage)this.imp;
            int c = 1;
            while (c <= channels) {
                cimp.setChannelLut(luts2[c - 1], c);
                ++c;
            }
            this.imp.updateAndDraw();
        }
        this.imp.unlock();
        this.imp.repaintWindow();
        this.imp.changes = true;
    }

    void deleteHyperstackChannelSliceOrFrame() {
        int i;
        int index;
        int channels = this.imp.getNChannels();
        int slices = this.imp.getNSlices();
        int frames = this.imp.getNFrames();
        int c1 = this.imp.getChannel();
        int z1 = this.imp.getSlice();
        int t1 = this.imp.getFrame();
        ArrayList<String> list = new ArrayList<String>();
        if (channels > 1) {
            list.add("channel");
        }
        if (slices > 1) {
            list.add("slice");
        }
        if (frames > 1) {
            list.add("frame");
        }
        String[] choices = new String[list.size()];
        list.toArray(choices);
        String choice = choices[0];
        if (frames > 1 && slices == 1) {
            choice = "frame";
        } else if (slices > 1) {
            choice = "slice";
        }
        String options = Macro.getOptions();
        if (IJ.isMacro() && options != null && options.indexOf("delete=") == -1) {
            if (options.indexOf("delete") != -1) {
                Macro.setOptions("delete=frame");
            } else {
                Macro.setOptions("delete=slice");
            }
        }
        if (IJ.isMacro() && options == null && this.imp.isComposite() && this.imp.getStackSize() == this.imp.getNChannels()) {
            Macro.setOptions("delete=channel");
        }
        GenericDialog gd = new GenericDialog("Delete");
        gd.addChoice("Delete current", choices, choice);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        choice = gd.getNextChoice();
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        LUT[] luts = null;
        if (choice.equals("frame")) {
            int z = slices;
            while (z >= 1) {
                index = this.imp.getStackIndex(channels, z, t1);
                i = 0;
                while (i < channels) {
                    stack.deleteSlice(index - i);
                    ++i;
                }
                --z;
            }
            --frames;
        } else if (choice.equals("slice")) {
            int t = frames;
            while (t >= 1) {
                index = this.imp.getStackIndex(channels, z1, t);
                i = 0;
                while (i < channels) {
                    stack.deleteSlice(index - i);
                    ++i;
                }
                --t;
            }
            --slices;
        } else if (choice.equals("channel")) {
            if (this.imp.isComposite()) {
                luts = ((CompositeImage)this.imp).getLuts();
            }
            int index2 = this.imp.getStackIndex(c1, slices, frames);
            while (index2 > 0) {
                stack.deleteSlice(index2);
                index2 -= channels;
            }
            --channels;
        }
        this.imp.setStack(stack, channels, slices, frames);
        if (luts != null) {
            int i2 = c1 - 1;
            while (i2 < luts.length - 1) {
                luts[i2] = luts[i2 + 1];
                ++i2;
            }
            CompositeImage cimp = (CompositeImage)this.imp;
            int c = 1;
            while (c <= channels) {
                cimp.setChannelLut(luts[c - 1], c);
                ++c;
            }
            this.imp.updateAndDraw();
        }
        this.imp.unlock();
        this.imp.repaintWindow();
        this.imp.changes = true;
    }

    public void convertImagesToStack() {
        new ImagesToStack().run("");
    }

    public void convertStackToImages(ImagePlus imp) {
        CompositeImage cimg;
        boolean ok;
        if (this.nSlices < 2) {
            IJ.error("\"Convert Stack to Images\" requires a stack");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (size > 30 && !IJ.isMacro() && !(ok = IJ.showMessageWithCancel("Convert to Images?", "Are you sure you want to convert this\nstack to " + size + " separate windows?"))) {
            imp.unlock();
            return;
        }
        Calibration cal = imp.getCalibration();
        CompositeImage compositeImage = cimg = imp.isComposite() ? (CompositeImage)imp : null;
        if (imp.getNChannels() != imp.getStackSize()) {
            cimg = null;
        }
        int i = 1;
        while (i <= size) {
            LUT lut;
            String label = stack.getShortSliceLabel(i);
            String title = label != null && !label.equals("") ? label : this.getTitle(imp, i);
            ImageProcessor ip = stack.getProcessor(i);
            if (cimg != null && (lut = cimg.getChannelLut(i)) != null) {
                ip.setColorModel(lut);
                ip.setMinAndMax(lut.min, lut.max);
            }
            ImagePlus imp2 = new ImagePlus(title, ip);
            imp2.setCalibration(cal);
            String info = stack.getSliceLabel(i);
            if (info != null && !info.equals(label)) {
                imp2.setProperty("Info", info);
            }
            imp2.show();
            ++i;
        }
        imp.changes = false;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            win.close();
        } else if (Interpreter.isBatchMode()) {
            Interpreter.removeBatchModeImage(imp);
        }
        imp.unlock();
    }

    String getTitle(ImagePlus imp, int n) {
        String digits = "00000000" + n;
        return String.valueOf(imp.getShortTitle()) + "-" + digits.substring(digits.length() - 4, digits.length());
    }
}

