/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.util.Vector;

public class SpecifyROI
implements PlugIn,
DialogListener {
    static double xRoi;
    static double yRoi;
    static double width;
    static double height;
    static boolean oval;
    static boolean centered;
    static boolean scaledUnits;
    static Rectangle prevRoi;
    static double prevPixelWidth;
    int iSlice;
    boolean bAbort;
    ImagePlus imp;
    Vector fields;
    Vector checkboxes;
    int stackSize;

    static {
        prevPixelWidth = 1.0;
    }

    public void run(String arg) {
        this.imp = IJ.getImage();
        this.stackSize = this.imp != null ? this.imp.getStackSize() : 0;
        Roi roi = this.imp.getRoi();
        Calibration cal = this.imp.getCalibration();
        if (roi != null && roi.getBounds().equals(prevRoi) && cal.pixelWidth == prevPixelWidth) {
            roi = null;
        }
        if (roi != null) {
            boolean rectOrOval = roi != null && (roi.getType() == 0 || roi.getType() == 1);
            oval = rectOrOval && roi.getType() == 1;
            Rectangle r = roi.getBounds();
            width = r.width;
            height = r.height;
            xRoi = r.x;
            yRoi = r.y;
            if (scaledUnits && cal.scaled()) {
                xRoi *= cal.pixelWidth;
                yRoi *= cal.pixelHeight;
                width *= cal.pixelWidth;
                height *= cal.pixelHeight;
            }
        } else if (!this.validDialogValues()) {
            width = this.imp.getWidth() / 2;
            height = this.imp.getHeight() / 2;
            xRoi = width / 2.0;
            yRoi = height / 2.0;
        }
        if (centered) {
            xRoi += width / 2.0;
            yRoi += height / 2.0;
        }
        this.iSlice = this.imp.getCurrentSlice();
        this.showDialog();
    }

    boolean validDialogValues() {
        Calibration cal = this.imp.getCalibration();
        double pw = cal.pixelWidth;
        double ph = cal.pixelHeight;
        if (width / pw < 1.5 || height / ph < 1.5) {
            return false;
        }
        return !(xRoi / pw >= (double)this.imp.getWidth()) && !(yRoi / ph >= (double)this.imp.getHeight());
    }

    void showDialog() {
        Roi roi;
        Calibration cal = this.imp.getCalibration();
        int digits = 0;
        if (scaledUnits && cal.scaled()) {
            digits = 2;
        }
        if ((roi = this.imp.getRoi()) == null) {
            this.drawRoi();
        }
        GenericDialog gd = new GenericDialog("Specify");
        gd.addNumericField("Width:", width, digits);
        gd.addNumericField("Height:", height, digits);
        gd.addNumericField("X Coordinate:", xRoi, digits);
        gd.addNumericField("Y Coordinate:", yRoi, digits);
        if (this.stackSize > 1) {
            gd.addNumericField("Slice:", this.iSlice, 0);
        }
        gd.addCheckbox("Oval", oval);
        gd.addCheckbox("Centered", centered);
        if (cal.scaled()) {
            gd.addCheckbox("Scaled Units (" + cal.getUnits() + ")", scaledUnits);
        }
        this.fields = gd.getNumericFields();
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (roi == null) {
                this.imp.deleteRoi();
            } else {
                this.imp.setRoi(roi);
            }
        }
    }

    void drawRoi() {
        int iX = (int)xRoi;
        int iY = (int)yRoi;
        if (centered) {
            iX = (int)(xRoi - width / 2.0);
            iY = (int)(yRoi - height / 2.0);
        }
        int iWidth = (int)width;
        int iHeight = (int)height;
        Calibration cal = this.imp.getCalibration();
        if (scaledUnits && cal.scaled()) {
            iX = (int)Math.round((double)iX / cal.pixelWidth);
            iY = (int)Math.round((double)iY / cal.pixelHeight);
            iWidth = (int)Math.round(width / cal.pixelWidth);
            iHeight = (int)Math.round(height / cal.pixelHeight);
            prevPixelWidth = cal.pixelWidth;
        }
        Roi roi = oval ? new OvalRoi(iX, iY, iWidth, iHeight, this.imp) : new Roi(iX, iY, iWidth, iHeight);
        this.imp.setRoi(roi);
        prevRoi = roi.getBounds();
        prevPixelWidth = cal.pixelWidth;
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (IJ.isMacOSX()) {
            IJ.wait(100);
        }
        width = gd.getNextNumber();
        height = gd.getNextNumber();
        xRoi = gd.getNextNumber();
        yRoi = gd.getNextNumber();
        if (this.stackSize > 1) {
            this.iSlice = (int)gd.getNextNumber();
        }
        oval = gd.getNextBoolean();
        centered = gd.getNextBoolean();
        if (this.imp.getCalibration().scaled()) {
            scaledUnits = gd.getNextBoolean();
        }
        if (gd.invalidNumber()) {
            return false;
        }
        if (this.stackSize > 1 && this.iSlice > 0 && this.iSlice <= this.stackSize) {
            this.imp.setSlice(this.iSlice);
        }
        this.drawRoi();
        return true;
    }
}

