/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.ImageRoi;
import ij.gui.Line;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.PlugIn;
import ij.process.FloatPolygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class RoiRotator
implements PlugIn {
    private static double defaultAngle = 15.0;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.error("Rotate", "This command requires a selection");
            return;
        }
        double angle = this.showDialog(defaultAngle);
        if (Double.isNaN(angle)) {
            return;
        }
        if (!IJ.macroRunning()) {
            defaultAngle = angle;
        }
        if (roi instanceof ImageRoi) {
            ((ImageRoi)roi).rotate(angle);
            imp.draw();
            return;
        }
        Roi roi2 = RoiRotator.rotate(roi, angle);
        if (roi2 == null) {
            return;
        }
        Undo.setup(8, imp);
        roi = (Roi)roi.clone();
        imp.setRoi(roi2);
        Roi.previousRoi = roi;
    }

    public double showDialog(double angle) {
        GenericDialog gd = new GenericDialog("Rotate Selection");
        int decimalPlaces = 0;
        if ((double)((int)angle) != angle) {
            decimalPlaces = 2;
        }
        gd.addNumericField("Angle:", angle, decimalPlaces, 3, "degrees");
        gd.setInsets(10, 0, 0);
        gd.addMessage("Enter negative angle to \nrotate counter-clockwise");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return Double.NaN;
        }
        return gd.getNextNumber();
    }

    public static Roi rotate(Roi roi, double angle) {
        double theta = -angle * Math.PI / 180.0;
        Rectangle r = roi.getBounds();
        double xcenter = (double)r.x + (double)r.width / 2.0;
        double ycenter = (double)r.y + (double)r.height / 2.0;
        if (roi instanceof ShapeRoi) {
            return RoiRotator.rotateShape((ShapeRoi)roi, -theta, xcenter, ycenter);
        }
        FloatPolygon poly = roi.getFloatPolygon();
        int type = roi.getType();
        if (type == 5) {
            Line line = (Line)roi;
            double x1 = line.x1d;
            double y1 = line.y1d;
            double x2 = line.x2d;
            double y2 = line.y2d;
            poly = new FloatPolygon();
            poly.addPoint(x1, y1);
            poly.addPoint(x2, y2);
            xcenter = x1 + (x2 - x1) / 2.0;
            ycenter = y1 + (y2 - y1) / 2.0;
        }
        int i = 0;
        while (i < poly.npoints) {
            double dx = (double)poly.xpoints[i] - xcenter;
            double dy = ycenter - (double)poly.ypoints[i];
            double radius = Math.sqrt(dx * dx + dy * dy);
            double a = Math.atan2(dy, dx);
            poly.xpoints[i] = (float)(xcenter + radius * Math.cos(a + theta));
            poly.ypoints[i] = (float)(ycenter - radius * Math.sin(a + theta));
            ++i;
        }
        Roi roi2 = null;
        if (type == 5) {
            roi2 = new Line(poly.xpoints[0], poly.ypoints[0], poly.xpoints[1], poly.ypoints[1]);
        } else if (type == 10) {
            roi2 = new PointRoi(poly.xpoints, poly.ypoints, poly.npoints);
        } else {
            if (type == 0) {
                type = 2;
            }
            if (type == 0 && poly.npoints > 4) {
                type = 3;
            }
            if (type == 1 || type == 4) {
                type = 3;
            }
            roi2 = new PolygonRoi(poly.xpoints, poly.ypoints, poly.npoints, type);
        }
        roi2.setStrokeColor(roi.getStrokeColor());
        if (roi.getStroke() != null) {
            roi2.setStroke(roi.getStroke());
        }
        return roi2;
    }

    private static Roi rotateShape(ShapeRoi roi, double angle, double xcenter, double ycenter) {
        Shape shape = roi.getShape();
        AffineTransform at = new AffineTransform();
        at.rotate(angle, xcenter, ycenter);
        Rectangle r = roi.getBounds();
        at.translate(r.x, r.y);
        Shape shape2 = at.createTransformedShape(shape);
        return new ShapeRoi(shape2);
    }
}

