/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Color;

public class RectToolOptions
implements PlugIn,
DialogListener {
    private String strokeColorName;
    private String fillColorName;
    private static GenericDialog gd;
    private static double defaultStrokeWidth;
    private static Color defaultStrokeColor;

    static {
        defaultStrokeWidth = 0.0;
    }

    public void run(String arg) {
        if (gd != null && gd.isVisible()) {
            gd.toFront();
        } else {
            this.rectToolOptions();
        }
    }

    void rectToolOptions() {
        Roi roi;
        if (defaultStrokeColor == null) {
            defaultStrokeColor = Roi.getColor();
        }
        Color strokeColor = defaultStrokeColor;
        Color fillColor = null;
        if (defaultStrokeWidth == 0.0) {
            defaultStrokeWidth = 1.0;
        }
        double strokeWidth = defaultStrokeWidth;
        int cornerDiameter = (int)Prefs.get("toolbar.arc.size", 20.0);
        ImagePlus imp = WindowManager.getCurrentImage();
        Roi roi2 = roi = imp != null ? imp.getRoi() : null;
        if (roi != null && roi.getType() == 0) {
            strokeColor = roi.getStrokeColor();
            if (strokeColor == null) {
                strokeColor = Roi.getColor();
            }
            fillColor = roi.getFillColor();
            strokeWidth = roi.getStrokeWidth();
            cornerDiameter = roi.getCornerDiameter();
        }
        String strokec = Colors.colorToString(strokeColor);
        String fillc = Colors.colorToString(fillColor);
        gd = new NonBlockingGenericDialog("Rounded Rectangle Tool");
        gd.addSlider("Stroke width:", 1.0, 25.0, (int)strokeWidth);
        gd.addSlider("Corner diameter:", 0.0, 200.0, cornerDiameter);
        gd.addStringField("Color: ", strokec);
        gd.addStringField("Fill color: ", fillc);
        gd.addDialogListener(this);
        gd.showDialog();
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        double strokeWidth2 = gd.getNextNumber();
        int cornerDiameter2 = (int)gd.getNextNumber();
        String strokec2 = gd.getNextString();
        String fillc2 = gd.getNextString();
        ImagePlus imp = WindowManager.getCurrentImage();
        Roi roi = imp != null ? imp.getRoi() : null;
        Color strokeColor2 = Colors.decode(strokec2, defaultStrokeColor);
        if (roi != null && roi.getType() == 0) {
            roi.setStrokeWidth((int)strokeWidth2);
            roi.setCornerDiameter(cornerDiameter2);
            strokeColor2 = Colors.decode(strokec2, roi.getStrokeColor());
            Color fillColor = Colors.decode(fillc2, roi.getFillColor());
            roi.setStrokeColor(strokeColor2);
            roi.setFillColor(fillColor);
        }
        defaultStrokeWidth = strokeWidth2;
        defaultStrokeColor = strokeColor2;
        Toolbar.setRoundRectArcSize(cornerDiameter2);
        if (cornerDiameter2 > 0 && !Toolbar.getToolName().equals("roundrect")) {
            IJ.setTool("roundrect");
        }
        return true;
    }

    public static Color getDefaultStrokeColor() {
        return defaultStrokeColor;
    }

    public static float getDefaultStrokeWidth() {
        return (float)defaultStrokeWidth;
    }
}

