/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;

public class PluginInstaller
implements PlugIn {
    public static final String[] validExtensions = new String[]{".txt", ".ijm", ".js", ".bsh", ".class", ".jar", ".java", ".py"};

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Install Plugin, Macro or Script...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        if (!this.validExtension(name)) {
            IJ.error("Plugin Installer", this.errorMessage());
            return;
        }
        String path = String.valueOf(directory) + name;
        this.install(path);
    }

    public boolean install(String path) {
        boolean ok;
        File f;
        boolean isLibrary;
        boolean isURL = path.startsWith("http://");
        byte[] data = null;
        String name = path;
        if (isURL) {
            URL url = null;
            try {
                url = new URL(path);
            }
            catch (Exception e) {
                IJ.error("" + e);
                return false;
            }
            int index = path.lastIndexOf("/");
            if (index != -1 && index <= path.length() - 1) {
                name = path.substring(index + 1);
            }
            data = this.download(url, name);
        } else {
            File f2 = new File(path);
            name = f2.getName();
            data = this.download(f2);
        }
        if (data == null) {
            return false;
        }
        if (name.endsWith(".txt") && name.indexOf("_") == -1) {
            name = String.valueOf(name.substring(0, name.length() - 4)) + ".ijm";
        }
        String dir = null;
        boolean bl = isLibrary = name.endsWith(".jar") && name.indexOf("_") == -1;
        if (isLibrary && !(f = new File(dir = String.valueOf(Menus.getPlugInsPath()) + "jars")).exists() && !(ok = f.mkdir())) {
            dir = Menus.getPlugInsPath();
        }
        if (dir == null) {
            SaveDialog sd = new SaveDialog("Save Plugin, Macro or Script...", Menus.getPlugInsPath(), name, null);
            String name2 = sd.getFileName();
            if (name2 == null) {
                return false;
            }
            dir = sd.getDirectory();
        }
        if (!this.savePlugin(new File(dir, name), data)) {
            return false;
        }
        if (name.endsWith(".java")) {
            IJ.runPlugIn("ij.plugin.Compiler", String.valueOf(dir) + name);
        }
        Menus.updateImageJMenus();
        return true;
    }

    boolean savePlugin(File f, byte[] data) {
        try {
            FileOutputStream out = new FileOutputStream(f);
            out.write(data, 0, data.length);
            out.close();
        }
        catch (IOException e) {
            IJ.error("Plugin Installer", "" + e);
            return false;
        }
        return true;
    }

    byte[] download(URL url, String name) {
        byte[] data;
        try {
            URLConnection uc = url.openConnection();
            int len = uc.getContentLength();
            IJ.showStatus("Downloading " + url.getFile());
            InputStream in = uc.getInputStream();
            data = new byte[len];
            int n = 0;
            int lenk = len / 1024;
            while (n < len) {
                int count = in.read(data, n, len - n);
                if (count < 0) {
                    throw new EOFException();
                }
                IJ.showStatus("Downloading " + name + " (" + (n += count) / 1024 + "/" + lenk + "k)");
                IJ.showProgress(n, len);
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        IJ.showStatus("");
        return data;
    }

    byte[] download(File f) {
        if (!f.exists()) {
            IJ.error("Plugin Installer", "File not found: " + f);
            return null;
        }
        byte[] data = null;
        try {
            int len = (int)f.length();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            DataInputStream dis = new DataInputStream(in);
            data = new byte[len];
            dis.readFully(data);
            dis.close();
        }
        catch (Exception e) {
            IJ.error("Plugin Installer", "" + e);
            data = null;
        }
        return data;
    }

    private boolean validExtension(String name) {
        name = name.toLowerCase(Locale.US);
        boolean valid = false;
        int i = 0;
        while (i < validExtensions.length) {
            if (name.endsWith(validExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String errorMessage() {
        String s = "File name must end in ";
        int len = validExtensions.length;
        int i = 0;
        while (i < len) {
            s = i == len - 2 ? String.valueOf(s) + "\"" + validExtensions[i] + "\" or " : (i == len - 1 ? String.valueOf(s) + "\"" + validExtensions[i] + "\"." : String.valueOf(s) + "\"" + validExtensions[i] + "\", ");
            ++i;
        }
        return s;
    }
}

