/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.io.File;
import java.util.Vector;

public class ClassChecker
implements PlugIn {
    String[] paths;
    String[] names;

    public void run(String arg) {
        this.deleteDuplicates();
    }

    void deleteDuplicates() {
        this.getPathsAndNames();
        if (this.paths == null || this.paths.length < 2) {
            return;
        }
        String[] sortedNames = new String[this.names.length];
        int i = 0;
        while (i < this.names.length) {
            sortedNames[i] = this.names[i];
            ++i;
        }
        StringSorter.sort(sortedNames);
        i = 0;
        while (i < sortedNames.length - 1) {
            if (sortedNames[i].equals(sortedNames[i + 1])) {
                this.delete(sortedNames[i]);
            }
            ++i;
        }
    }

    void delete(String name) {
        String path1 = null;
        String path2 = null;
        int i = 0;
        while (i < this.names.length) {
            if (path1 == null && this.names[i].equals(name)) {
                path1 = String.valueOf(this.paths[i]) + this.names[i];
            } else if (path2 == null && this.names[i].equals(name)) {
                path2 = String.valueOf(this.paths[i]) + this.names[i];
            }
            if (path1 != null && path2 != null) {
                long date2;
                File file1 = new File(path1);
                File file2 = new File(path2);
                if (file1 == null || file2 == null) {
                    return;
                }
                long date1 = file1.lastModified();
                if (date1 < (date2 = file2.lastModified())) {
                    this.write(path1);
                    file1.delete();
                    break;
                }
                this.write(path2);
                file2.delete();
                break;
            }
            ++i;
        }
    }

    void write(String path) {
        IJ.log("Deleting duplicate plugin: " + path);
    }

    void getPathsAndNames() {
        String path = Menus.getPlugInsPath();
        if (path == null) {
            return;
        }
        File f = new File(path);
        String[] list = f.list();
        if (list == null) {
            return;
        }
        Vector<String> v1 = new Vector<String>(1000);
        Vector<String> v2 = new Vector<String>(1000);
        int i = 0;
        while (i < list.length) {
            String name = list[i];
            if (name.endsWith(".class") || name.endsWith(".jar")) {
                v1.addElement(path);
                v2.addElement(name);
            } else {
                this.getSubdirectoryFiles(path, name, v1, v2);
            }
            ++i;
        }
        this.paths = new String[v1.size()];
        v1.copyInto(this.paths);
        this.names = new String[v2.size()];
        v2.copyInto(this.names);
    }

    void getSubdirectoryFiles(String path, String dir, Vector v1, Vector v2) {
        if (dir.endsWith(".java")) {
            return;
        }
        File f = new File(path, dir);
        if (!f.isDirectory()) {
            return;
        }
        String[] list = f.list();
        if (list == null) {
            return;
        }
        dir = String.valueOf(dir) + Prefs.separator;
        int i = 0;
        while (i < list.length) {
            String name = list[i];
            if (name.endsWith(".class") || name.endsWith(".jar")) {
                v1.addElement(String.valueOf(path) + dir);
                v2.addElement(name);
            }
            ++i;
        }
    }
}

