/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.imageio.ImageIO;

public class AVI_Reader
extends VirtualStack
implements PlugIn {
    private static final int FOURCC_RIFF = 1179011410;
    private static final int FOURCC_AVI = 541677121;
    private static final int FOURCC_AVIX = 1481201217;
    private static final int FOURCC_ix00 = 808482921;
    private static final int FOURCC_indx = 2019847785;
    private static final int FOURCC_idx1 = 829973609;
    private static final int FOURCC_LIST = 1414744396;
    private static final int FOURCC_hdrl = 1819436136;
    private static final int FOURCC_avih = 1751742049;
    private static final int FOURCC_strl = 1819440243;
    private static final int FOURCC_strh = 1752331379;
    private static final int FOURCC_strf = 1718776947;
    private static final int FOURCC_movi = 1769369453;
    private static final int FOURCC_rec = 543384946;
    private static final int FOURCC_JUNK = 1263424842;
    private static final int FOURCC_vids = 1935960438;
    private static final int FOURCC_00db = 1650733104;
    private static final int FOURCC_00dc = 1667510320;
    private static final int NO_COMPRESSION = 0;
    private static final int NO_COMPRESSION_RGB = 541214546;
    private static final int NO_COMPRESSION_RAW = 542589266;
    private static final int NO_COMPRESSION_Y800 = 808466521;
    private static final int NO_COMPRESSION_Y8 = 538982489;
    private static final int NO_COMPRESSION_GREY = 1497715271;
    private static final int NO_COMPRESSION_Y16 = 540422489;
    private static final int NO_COMPRESSION_MIL = 541870413;
    private static final int AYUV_COMPRESSION = 1448433985;
    private static final int UYVY_COMPRESSION = 0x59565955;
    private static final int Y422_COMPRESSION = 1447975253;
    private static final int UYNV_COMPRESSION = 842151001;
    private static final int CYUV_COMPRESSION = 1987410275;
    private static final int V422_COMPRESSION = 842150998;
    private static final int YUY2_COMPRESSION = 844715353;
    private static final int YUNV_COMPRESSION = 1447974233;
    private static final int YUYV_COMPRESSION = 0x56595559;
    private static final int YVYU_COMPRESSION = 0x55595659;
    private static final int I420_COMPRESSION = 808596553;
    private static final int IYUV_COMPRESSION = 1448433993;
    private static final int YV12_COMPRESSION = 842094169;
    private static final int NV12_COMPRESSION = 842094158;
    private static final int NV21_COMPRESSION = 825382478;
    private static final int JPEG_COMPRESSION = 1734701162;
    private static final int JPEG_COMPRESSION2 = 1195724874;
    private static final int JPEG_COMPRESSION3 = 4;
    private static final int MJPG_COMPRESSION = 1196444237;
    private static final int PNG_COMPRESSION = 543649392;
    private static final int PNG_COMPRESSION2 = 541544016;
    private static final int PNG_COMPRESSION3 = 5;
    private static final int BITMASK24 = 65536;
    private static final long SIZE_MASK = 0xFFFFFFFFL;
    private static final int AVIF_HASINDEX = 16;
    private static final int AVIF_MUSTUSEINDEX = 32;
    private static final int AVIF_ISINTERLEAVED = 256;
    private static final byte AVI_INDEX_OF_CHUNKS = 1;
    private static final byte AVI_INDEX_OF_INDEXES = 0;
    private static boolean staticConvertToGray;
    private static boolean staticFlipVertical;
    private static boolean staticIsVirtual;
    private int firstFrame = 1;
    private int lastFrame = 0;
    private boolean convertToGray;
    private boolean flipVertical;
    private boolean isVirtual;
    private RandomAccessFile raFile;
    private String raFilePath;
    private boolean headerOK = false;
    private int streamNumber;
    private int type0xdb;
    private int type0xdc;
    private long fileSize;
    private long aviSize;
    private long headerPositionEnd;
    private long indexPosition;
    private long indexPositionEnd;
    private long moviPosition;
    private int paddingGranularity = 2;
    private int frameNumber = 1;
    private int lastFrameToRead = Integer.MAX_VALUE;
    private int totalFramesFromIndex;
    private boolean indexForCountingOnly;
    private int dataCompression;
    private boolean isPlanarFormat;
    private int scanLineSize;
    private boolean dataTopDown;
    private ColorModel cm;
    private boolean variableLength;
    private Vector frameInfos;
    private ImageStack stack;
    private ImagePlus imp;
    private boolean verbose = IJ.debugMode;
    private long startTime;
    private boolean aborting;
    private int dwMicroSecPerFrame;
    private int dwMaxBytesPerSec;
    private int dwReserved1;
    private int dwFlags;
    private int dwTotalFrames;
    private int dwInitialFrames;
    private int dwStreams;
    private int dwSuggestedBufferSize;
    private int dwWidth;
    private int dwHeight;
    private int fccStreamHandler;
    private int dwStreamFlags;
    private int dwPriorityLanguage;
    private int dwStreamInitialFrames;
    private int dwStreamScale;
    private int dwStreamRate;
    private int dwStreamStart;
    private int dwStreamLength;
    private int dwStreamSuggestedBufferSize;
    private int dwStreamQuality;
    private int dwStreamSampleSize;
    private int biSize;
    private int biWidth;
    private int biHeight;
    private short biPlanes;
    private short biBitCount;
    private int biCompression;
    private int biSizeImage;
    private int biXPelsPerMeter;
    private int biYPelsPerMeter;
    private int biClrUsed;
    private int biClrImportant;
    private static final int BUFFERSIZE = 4096;
    private static final byte[] HUFFMAN_TABLES;
    private static final int HUFFMAN_LENGTH = 420;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[420];
        byArray[0] = -1;
        byArray[1] = -60;
        byArray[2] = 1;
        byArray[3] = -94;
        byArray[6] = 1;
        byArray[7] = 5;
        byArray[8] = 1;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 1;
        byArray[12] = 1;
        byArray[13] = 1;
        byArray[22] = 1;
        byArray[23] = 2;
        byArray[24] = 3;
        byArray[25] = 4;
        byArray[26] = 5;
        byArray[27] = 6;
        byArray[28] = 7;
        byArray[29] = 8;
        byArray[30] = 9;
        byArray[31] = 10;
        byArray[32] = 11;
        byArray[33] = 1;
        byArray[35] = 3;
        byArray[36] = 1;
        byArray[37] = 1;
        byArray[38] = 1;
        byArray[39] = 1;
        byArray[40] = 1;
        byArray[41] = 1;
        byArray[42] = 1;
        byArray[43] = 1;
        byArray[44] = 1;
        byArray[51] = 1;
        byArray[52] = 2;
        byArray[53] = 3;
        byArray[54] = 4;
        byArray[55] = 5;
        byArray[56] = 6;
        byArray[57] = 7;
        byArray[58] = 8;
        byArray[59] = 9;
        byArray[60] = 10;
        byArray[61] = 11;
        byArray[62] = 16;
        byArray[64] = 2;
        byArray[65] = 1;
        byArray[66] = 3;
        byArray[67] = 3;
        byArray[68] = 2;
        byArray[69] = 4;
        byArray[70] = 3;
        byArray[71] = 5;
        byArray[72] = 5;
        byArray[73] = 4;
        byArray[74] = 4;
        byArray[77] = 1;
        byArray[78] = 125;
        byArray[79] = 1;
        byArray[80] = 2;
        byArray[81] = 3;
        byArray[83] = 4;
        byArray[84] = 17;
        byArray[85] = 5;
        byArray[86] = 18;
        byArray[87] = 33;
        byArray[88] = 49;
        byArray[89] = 65;
        byArray[90] = 6;
        byArray[91] = 19;
        byArray[92] = 81;
        byArray[93] = 97;
        byArray[94] = 7;
        byArray[95] = 34;
        byArray[96] = 113;
        byArray[97] = 20;
        byArray[98] = 50;
        byArray[99] = -127;
        byArray[100] = -111;
        byArray[101] = -95;
        byArray[102] = 8;
        byArray[103] = 35;
        byArray[104] = 66;
        byArray[105] = -79;
        byArray[106] = -63;
        byArray[107] = 21;
        byArray[108] = 82;
        byArray[109] = -47;
        byArray[110] = -16;
        byArray[111] = 36;
        byArray[112] = 51;
        byArray[113] = 98;
        byArray[114] = 114;
        byArray[115] = -126;
        byArray[116] = 9;
        byArray[117] = 10;
        byArray[118] = 22;
        byArray[119] = 23;
        byArray[120] = 24;
        byArray[121] = 25;
        byArray[122] = 26;
        byArray[123] = 37;
        byArray[124] = 38;
        byArray[125] = 39;
        byArray[126] = 40;
        byArray[127] = 41;
        byArray[128] = 42;
        byArray[129] = 52;
        byArray[130] = 53;
        byArray[131] = 54;
        byArray[132] = 55;
        byArray[133] = 56;
        byArray[134] = 57;
        byArray[135] = 58;
        byArray[136] = 67;
        byArray[137] = 68;
        byArray[138] = 69;
        byArray[139] = 70;
        byArray[140] = 71;
        byArray[141] = 72;
        byArray[142] = 73;
        byArray[143] = 74;
        byArray[144] = 83;
        byArray[145] = 84;
        byArray[146] = 85;
        byArray[147] = 86;
        byArray[148] = 87;
        byArray[149] = 88;
        byArray[150] = 89;
        byArray[151] = 90;
        byArray[152] = 99;
        byArray[153] = 100;
        byArray[154] = 101;
        byArray[155] = 102;
        byArray[156] = 103;
        byArray[157] = 104;
        byArray[158] = 105;
        byArray[159] = 106;
        byArray[160] = 115;
        byArray[161] = 116;
        byArray[162] = 117;
        byArray[163] = 118;
        byArray[164] = 119;
        byArray[165] = 120;
        byArray[166] = 121;
        byArray[167] = 122;
        byArray[168] = -125;
        byArray[169] = -124;
        byArray[170] = -123;
        byArray[171] = -122;
        byArray[172] = -121;
        byArray[173] = -120;
        byArray[174] = -119;
        byArray[175] = -118;
        byArray[176] = -110;
        byArray[177] = -109;
        byArray[178] = -108;
        byArray[179] = -107;
        byArray[180] = -106;
        byArray[181] = -105;
        byArray[182] = -104;
        byArray[183] = -103;
        byArray[184] = -102;
        byArray[185] = -94;
        byArray[186] = -93;
        byArray[187] = -92;
        byArray[188] = -91;
        byArray[189] = -90;
        byArray[190] = -89;
        byArray[191] = -88;
        byArray[192] = -87;
        byArray[193] = -86;
        byArray[194] = -78;
        byArray[195] = -77;
        byArray[196] = -76;
        byArray[197] = -75;
        byArray[198] = -74;
        byArray[199] = -73;
        byArray[200] = -72;
        byArray[201] = -71;
        byArray[202] = -70;
        byArray[203] = -62;
        byArray[204] = -61;
        byArray[205] = -60;
        byArray[206] = -59;
        byArray[207] = -58;
        byArray[208] = -57;
        byArray[209] = -56;
        byArray[210] = -55;
        byArray[211] = -54;
        byArray[212] = -46;
        byArray[213] = -45;
        byArray[214] = -44;
        byArray[215] = -43;
        byArray[216] = -42;
        byArray[217] = -41;
        byArray[218] = -40;
        byArray[219] = -39;
        byArray[220] = -38;
        byArray[221] = -31;
        byArray[222] = -30;
        byArray[223] = -29;
        byArray[224] = -28;
        byArray[225] = -27;
        byArray[226] = -26;
        byArray[227] = -25;
        byArray[228] = -24;
        byArray[229] = -23;
        byArray[230] = -22;
        byArray[231] = -15;
        byArray[232] = -14;
        byArray[233] = -13;
        byArray[234] = -12;
        byArray[235] = -11;
        byArray[236] = -10;
        byArray[237] = -9;
        byArray[238] = -8;
        byArray[239] = -7;
        byArray[240] = -6;
        byArray[241] = 17;
        byArray[243] = 2;
        byArray[244] = 1;
        byArray[245] = 2;
        byArray[246] = 4;
        byArray[247] = 4;
        byArray[248] = 3;
        byArray[249] = 4;
        byArray[250] = 7;
        byArray[251] = 5;
        byArray[252] = 4;
        byArray[253] = 4;
        byArray[255] = 1;
        byArray[256] = 2;
        byArray[257] = 119;
        byArray[259] = 1;
        byArray[260] = 2;
        byArray[261] = 3;
        byArray[262] = 17;
        byArray[263] = 4;
        byArray[264] = 5;
        byArray[265] = 33;
        byArray[266] = 49;
        byArray[267] = 6;
        byArray[268] = 18;
        byArray[269] = 65;
        byArray[270] = 81;
        byArray[271] = 7;
        byArray[272] = 97;
        byArray[273] = 113;
        byArray[274] = 19;
        byArray[275] = 34;
        byArray[276] = 50;
        byArray[277] = -127;
        byArray[278] = 8;
        byArray[279] = 20;
        byArray[280] = 66;
        byArray[281] = -111;
        byArray[282] = -95;
        byArray[283] = -79;
        byArray[284] = -63;
        byArray[285] = 9;
        byArray[286] = 35;
        byArray[287] = 51;
        byArray[288] = 82;
        byArray[289] = -16;
        byArray[290] = 21;
        byArray[291] = 98;
        byArray[292] = 114;
        byArray[293] = -47;
        byArray[294] = 10;
        byArray[295] = 22;
        byArray[296] = 36;
        byArray[297] = 52;
        byArray[298] = -31;
        byArray[299] = 37;
        byArray[300] = -15;
        byArray[301] = 23;
        byArray[302] = 24;
        byArray[303] = 25;
        byArray[304] = 26;
        byArray[305] = 38;
        byArray[306] = 39;
        byArray[307] = 40;
        byArray[308] = 41;
        byArray[309] = 42;
        byArray[310] = 53;
        byArray[311] = 54;
        byArray[312] = 55;
        byArray[313] = 56;
        byArray[314] = 57;
        byArray[315] = 58;
        byArray[316] = 67;
        byArray[317] = 68;
        byArray[318] = 69;
        byArray[319] = 70;
        byArray[320] = 71;
        byArray[321] = 72;
        byArray[322] = 73;
        byArray[323] = 74;
        byArray[324] = 83;
        byArray[325] = 84;
        byArray[326] = 85;
        byArray[327] = 86;
        byArray[328] = 87;
        byArray[329] = 88;
        byArray[330] = 89;
        byArray[331] = 90;
        byArray[332] = 99;
        byArray[333] = 100;
        byArray[334] = 101;
        byArray[335] = 102;
        byArray[336] = 103;
        byArray[337] = 104;
        byArray[338] = 105;
        byArray[339] = 106;
        byArray[340] = 115;
        byArray[341] = 116;
        byArray[342] = 117;
        byArray[343] = 118;
        byArray[344] = 119;
        byArray[345] = 120;
        byArray[346] = 121;
        byArray[347] = 122;
        byArray[348] = -126;
        byArray[349] = -125;
        byArray[350] = -124;
        byArray[351] = -123;
        byArray[352] = -122;
        byArray[353] = -121;
        byArray[354] = -120;
        byArray[355] = -119;
        byArray[356] = -118;
        byArray[357] = -110;
        byArray[358] = -109;
        byArray[359] = -108;
        byArray[360] = -107;
        byArray[361] = -106;
        byArray[362] = -105;
        byArray[363] = -104;
        byArray[364] = -103;
        byArray[365] = -102;
        byArray[366] = -94;
        byArray[367] = -93;
        byArray[368] = -92;
        byArray[369] = -91;
        byArray[370] = -90;
        byArray[371] = -89;
        byArray[372] = -88;
        byArray[373] = -87;
        byArray[374] = -86;
        byArray[375] = -78;
        byArray[376] = -77;
        byArray[377] = -76;
        byArray[378] = -75;
        byArray[379] = -74;
        byArray[380] = -73;
        byArray[381] = -72;
        byArray[382] = -71;
        byArray[383] = -70;
        byArray[384] = -62;
        byArray[385] = -61;
        byArray[386] = -60;
        byArray[387] = -59;
        byArray[388] = -58;
        byArray[389] = -57;
        byArray[390] = -56;
        byArray[391] = -55;
        byArray[392] = -54;
        byArray[393] = -46;
        byArray[394] = -45;
        byArray[395] = -44;
        byArray[396] = -43;
        byArray[397] = -42;
        byArray[398] = -41;
        byArray[399] = -40;
        byArray[400] = -39;
        byArray[401] = -38;
        byArray[402] = -30;
        byArray[403] = -29;
        byArray[404] = -28;
        byArray[405] = -27;
        byArray[406] = -26;
        byArray[407] = -25;
        byArray[408] = -24;
        byArray[409] = -23;
        byArray[410] = -22;
        byArray[411] = -14;
        byArray[412] = -13;
        byArray[413] = -12;
        byArray[414] = -11;
        byArray[415] = -10;
        byArray[416] = -9;
        byArray[417] = -8;
        byArray[418] = -7;
        byArray[419] = -6;
        HUFFMAN_TABLES = byArray;
    }

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Select AVI File", arg);
        String fileName = od.getFileName();
        if (fileName == null) {
            return;
        }
        String fileDir = od.getDirectory();
        String path = String.valueOf(fileDir) + fileName;
        try {
            this.openAndReadHeader(path);
        }
        catch (Exception e) {
            this.error(this.exceptionMessage(e));
            return;
        }
        if (!this.showDialog(fileName)) {
            return;
        }
        try {
            ImageStack stack = this.makeStack(path, this.firstFrame, this.lastFrame, this.isVirtual, this.convertToGray, this.flipVertical);
        }
        catch (Exception e) {
            this.error(this.exceptionMessage(e));
            return;
        }
        if (this.stack == null || this.aborting || this.stack.isVirtual() && this.stack.getProcessor(1) == null) {
            return;
        }
        if (this.stack.getSize() == 0) {
            String rangeText = "";
            if (this.firstFrame > 1 || this.lastFrame != 0) {
                rangeText = "\nin Range " + this.firstFrame + (this.lastFrame > 0 ? " - " + this.lastFrame : " - end");
            }
            this.error("Error: No Frames Found" + rangeText);
            return;
        }
        this.imp = new ImagePlus(WindowManager.makeUniqueName(fileName), this.stack);
        if (this.imp.getBitDepth() == 16) {
            this.imp.getProcessor().resetMinAndMax();
        }
        this.setFramesPerSecond(this.imp);
        FileInfo fi = new FileInfo();
        fi.fileName = fileName;
        fi.directory = fileDir;
        this.imp.setFileInfo(fi);
        if (arg.equals("")) {
            this.imp.show();
        }
        IJ.showTime(this.imp, this.startTime, "Read AVI in ", this.stack.getSize());
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    public static ImagePlus openVirtual(String path) {
        return AVI_Reader.open(path, true);
    }

    public static ImagePlus open(String path, boolean virtual) {
        AVI_Reader reader = new AVI_Reader();
        ImageStack stack = reader.makeStack(path, 1, 0, virtual, false, false);
        if (stack != null) {
            return new ImagePlus(new File(path).getName(), stack);
        }
        return null;
    }

    public ImageStack makeStack(String path, int firstFrame, int lastFrame, boolean isVirtual, boolean convertToGray, boolean flipVertical) {
        String exceptionMessage;
        block21: {
            this.firstFrame = firstFrame;
            this.lastFrame = lastFrame;
            this.isVirtual = isVirtual;
            this.convertToGray = convertToGray;
            this.flipVertical = flipVertical;
            exceptionMessage = null;
            IJ.showProgress(0.001);
            try {
                this.readAVI(path);
            }
            catch (OutOfMemoryError e) {
                this.stack.trim();
                IJ.showMessage("AVI Reader", "Out of memory.  " + this.stack.getSize() + " of " + this.dwTotalFrames + " frames will be opened.");
                try {
                    this.raFile.close();
                    if (this.verbose) {
                        IJ.log("File closed.");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IJ.showProgress(1.0);
                break block21;
            }
            catch (Exception e) {
                try {
                    exceptionMessage = this.exceptionMessage(e);
                    break block21;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        this.raFile.close();
                        if (this.verbose) {
                            IJ.log("File closed.");
                        }
                    }
                    catch (Exception exception) {}
                    IJ.showProgress(1.0);
                }
            }
            try {
                this.raFile.close();
                if (this.verbose) {
                    IJ.log("File closed.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            IJ.showProgress(1.0);
        }
        if (exceptionMessage != null) {
            this.error(exceptionMessage);
            return null;
        }
        if (isVirtual && this.frameInfos != null) {
            this.stack = this;
        }
        if (this.stack != null && this.cm != null) {
            this.stack.setColorModel(this.cm);
        }
        return this.stack;
    }

    public synchronized ImageProcessor getProcessor(int n) {
        String exceptionMessage;
        Object pixels;
        block17: {
            if (this.frameInfos == null || this.frameInfos.size() == 0 || this.raFilePath == null) {
                return null;
            }
            if (n < 1 || n > this.frameInfos.size()) {
                throw new IllegalArgumentException("Argument out of range: " + n);
            }
            pixels = null;
            RandomAccessFile rFile = null;
            exceptionMessage = null;
            try {
                try {
                    rFile = new RandomAccessFile(new File(this.raFilePath), "r");
                    long[] frameInfo = (long[])this.frameInfos.get(n - 1);
                    pixels = this.readFrame(rFile, frameInfo[0], (int)frameInfo[1]);
                }
                catch (Exception e) {
                    exceptionMessage = this.exceptionMessage(e);
                    try {
                        rFile.close();
                    }
                    catch (Exception exception) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    rFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                rFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (exceptionMessage != null) {
            this.error(exceptionMessage);
            return null;
        }
        if (pixels == null) {
            return null;
        }
        if (pixels instanceof byte[]) {
            return new ByteProcessor(this.dwWidth, this.biHeight, (byte[])pixels, this.cm);
        }
        if (pixels instanceof short[]) {
            return new ShortProcessor(this.dwWidth, this.biHeight, (short[])pixels, this.cm);
        }
        return new ColorProcessor(this.dwWidth, this.biHeight, (int[])pixels);
    }

    public int getWidth() {
        return this.dwWidth;
    }

    public int getHeight() {
        return this.biHeight;
    }

    public int getSize() {
        if (this.frameInfos == null) {
            return 0;
        }
        return this.frameInfos.size();
    }

    public String getSliceLabel(int n) {
        if (this.frameInfos == null || n < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("No Virtual Stack or argument out of range: " + n);
        }
        return this.frameLabel(((long[])this.frameInfos.get(n - 1))[2]);
    }

    public void deleteSlice(int n) {
        if (this.frameInfos == null || this.frameInfos.size() == 0) {
            return;
        }
        if (n < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        this.frameInfos.removeElementAt(n - 1);
    }

    private boolean showDialog(String fileName) {
        if (this.lastFrame != -1) {
            this.lastFrame = this.dwTotalFrames;
        }
        if (!IJ.isMacro()) {
            this.convertToGray = staticConvertToGray;
            this.flipVertical = staticFlipVertical;
            this.isVirtual = staticIsVirtual;
        }
        GenericDialog gd = new GenericDialog("AVI Reader");
        gd.addNumericField("First Frame: ", this.firstFrame, 0);
        gd.addNumericField("Last Frame: ", this.lastFrame, 0, 6, "");
        gd.addCheckbox("Use Virtual Stack", this.isVirtual);
        gd.addCheckbox("Convert to Grayscale", this.convertToGray);
        gd.addCheckbox("Flip Vertical", this.flipVertical);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.firstFrame = (int)gd.getNextNumber();
        this.lastFrame = (int)gd.getNextNumber();
        this.isVirtual = gd.getNextBoolean();
        this.convertToGray = gd.getNextBoolean();
        this.flipVertical = gd.getNextBoolean();
        if (!IJ.isMacro()) {
            staticConvertToGray = this.convertToGray;
            staticFlipVertical = this.flipVertical;
            staticIsVirtual = this.isVirtual;
        }
        IJ.register(this.getClass());
        return true;
    }

    private void readAVI(String path) throws Exception, IOException {
        boolean hasIndex;
        if (!this.headerOK) {
            this.openAndReadHeader(path);
        }
        this.startTime += System.currentTimeMillis();
        if (this.lastFrame > 0) {
            this.lastFrameToRead = this.lastFrame;
        }
        if (this.lastFrame < 0 && this.dwTotalFrames > 0) {
            this.lastFrameToRead = this.dwTotalFrames + this.lastFrame;
        }
        if (this.lastFrameToRead < this.firstFrame) {
            return;
        }
        boolean bl = hasIndex = (this.dwFlags & 0x10) != 0;
        if (this.isVirtual || this.firstFrame > 1) {
            this.frameInfos = new Vector(100);
            long nextPosition = -1L;
            if (this.indexPosition > 0L) {
                this.raFile.seek(this.indexPosition);
                nextPosition = this.findFourccAndRead(2019847785, false, this.indexPositionEnd, false);
            }
            if (hasIndex && this.frameInfos.size() == 0) {
                this.raFile.seek(this.headerPositionEnd);
                this.moviPosition = this.findFourccAndSkip(1769369453, true, this.fileSize);
                if (this.moviPosition > 0L) {
                    nextPosition = this.findFourccAndRead(829973609, false, this.fileSize, false);
                }
            }
            if (this.verbose) {
                IJ.log("'frameInfos' has " + this.frameInfos.size() + " entries");
            }
        }
        if (this.isVirtual && this.frameInfos.size() > 0) {
            return;
        }
        this.raFile.seek(this.headerPositionEnd);
        if (this.firstFrame > 1 && this.frameInfos.size() > 0) {
            long[] frameInfo = (long[])this.frameInfos.get(0);
            this.raFile.seek(frameInfo[0] - 8L);
            this.frameNumber = this.firstFrame;
            if (this.verbose) {
                IJ.log("directly go to frame " + this.firstFrame + " @ 0x" + Long.toHexString(frameInfo[0] - 8L));
            }
            this.readMovieData(this.fileSize);
        } else {
            this.frameNumber = 1;
            this.findFourccAndRead(1769369453, true, this.fileSize, true);
        }
        long pos = this.raFile.getFilePointer();
        while (pos > 0L && pos < this.fileSize && this.frameNumber < this.lastFrameToRead + 1) {
            pos = this.findFourccAndRead(1179011410, false, this.fileSize, false);
        }
    }

    private void openAndReadHeader(String path) throws Exception, IOException {
        this.startTime = System.currentTimeMillis();
        if (this.verbose) {
            IJ.log("OPEN AND READ AVI FILE HEADER " + this.timeString());
        }
        File file = new File(path);
        this.raFile = new RandomAccessFile(file, "r");
        this.raFilePath = path;
        this.fileSize = this.raFile.length();
        int fileType = this.readInt();
        if (this.verbose) {
            IJ.log("File header: File type='" + this.fourccString(fileType) + "' (should be 'RIFF')" + this.timeString());
        }
        if (fileType != 1179011410) {
            throw new Exception("Not an AVI file.");
        }
        this.aviSize = (long)this.readInt() & 0xFFFFFFFFL;
        int riffType = this.readInt();
        if (this.verbose) {
            IJ.log("File header: RIFF type='" + this.fourccString(riffType) + "' (should be 'AVI ')");
        }
        if (riffType != 541677121) {
            throw new Exception("Not an AVI file.");
        }
        this.findFourccAndRead(1819436136, true, this.fileSize, true);
        this.startTime -= System.currentTimeMillis();
        this.headerOK = true;
    }

    private void readAVIX(long endPosition) throws Exception, IOException {
        if (this.verbose) {
            IJ.log("Trying to read AVIX" + this.timeString());
        }
        int riffType = this.readInt();
        if (this.verbose) {
            IJ.log("File header: RIFF type='" + this.fourccString(riffType) + "' (should be 'AVIX')");
        }
        if (riffType != 1481201217) {
            throw new Exception("Not an AVI file.");
        }
        this.findFourccAndRead(1769369453, true, this.fileSize, true);
    }

    private long findFourccAndRead(int fourcc, boolean isList, long endPosition, boolean throwNotFoundException) throws Exception, IOException {
        long nextPos;
        boolean contentOk = false;
        do {
            int type;
            if ((type = this.readType(endPosition)) == 0) {
                if (throwNotFoundException) {
                    throw new Exception("Required item '" + this.fourccString(fourcc) + "' not found");
                }
                return -1L;
            }
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            nextPos = this.raFile.getFilePointer() + size;
            if (isList && type == 1414744396) {
                type = this.readInt();
            }
            if (this.verbose) {
                IJ.log("Searching for '" + this.fourccString(fourcc) + "', found " + this.fourccString(type) + "' " + this.posSizeString(nextPos - size, size));
            }
            if (type == fourcc) {
                contentOk = this.readContents(fourcc, nextPos);
            } else if (this.verbose) {
                IJ.log("Discarded '" + this.fourccString(type) + "': Contents does not fit");
            }
            this.raFile.seek(nextPos);
            if (!contentOk) continue;
            return nextPos;
        } while (!contentOk);
        return nextPos;
    }

    private long findFourccAndSkip(int fourcc, boolean isList, long endPosition) throws IOException {
        long chunkPos;
        int type;
        do {
            if ((type = this.readType(endPosition)) == 0) {
                return -1L;
            }
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            chunkPos = this.raFile.getFilePointer();
            long nextPos = chunkPos + size;
            if (isList && type == 1414744396) {
                type = this.readInt();
            }
            if (this.verbose) {
                IJ.log("Searching for (to skip) '" + this.fourccString(fourcc) + "', found " + this.fourccString(type) + "' " + this.posSizeString(chunkPos, size));
            }
            this.raFile.seek(nextPos);
        } while (type != fourcc);
        return chunkPos;
    }

    private boolean readContents(int fourcc, long endPosition) throws Exception, IOException {
        switch (fourcc) {
            case 1819436136: {
                this.headerPositionEnd = endPosition;
                this.findFourccAndRead(1751742049, false, endPosition, true);
                this.findFourccAndRead(1819440243, true, endPosition, true);
                return true;
            }
            case 1751742049: {
                this.readAviHeader();
                return true;
            }
            case 1819440243: {
                long nextPosition = this.findFourccAndRead(1752331379, false, endPosition, false);
                if (nextPosition < 0L) {
                    return false;
                }
                this.indexPosition = this.findFourccAndRead(1718776947, false, endPosition, true);
                this.indexPositionEnd = endPosition;
                this.indexForCountingOnly = true;
                this.totalFramesFromIndex = 0;
                nextPosition = this.findFourccAndRead(2019847785, false, endPosition, false);
                if (nextPosition > 0L && this.totalFramesFromIndex > this.dwTotalFrames) {
                    this.dwTotalFrames = this.totalFramesFromIndex;
                }
                this.indexForCountingOnly = false;
                return true;
            }
            case 1752331379: {
                int streamType = this.readInt();
                if (streamType != 1935960438) {
                    if (this.verbose) {
                        IJ.log("Non-video Stream '" + this.fourccString(streamType) + " skipped");
                    }
                    ++this.streamNumber;
                    return false;
                }
                this.readStreamHeader();
                return true;
            }
            case 1718776947: {
                this.readBitMapInfo(endPosition);
                return true;
            }
            case 808482921: 
            case 2019847785: {
                this.readAvi2Index(endPosition);
                return true;
            }
            case 829973609: {
                this.readOldFrameIndex(endPosition);
                return true;
            }
            case 1179011410: {
                this.readAVIX(endPosition);
                return true;
            }
            case 1769369453: {
                this.readMovieData(endPosition);
                return true;
            }
        }
        throw new Exception("Program error, type " + this.fourccString(fourcc));
    }

    void readAviHeader() throws Exception, IOException {
        this.dwMicroSecPerFrame = this.readInt();
        this.dwMaxBytesPerSec = this.readInt();
        this.dwReserved1 = this.readInt();
        this.dwFlags = this.readInt();
        this.dwTotalFrames = this.readInt();
        this.dwInitialFrames = this.readInt();
        this.dwStreams = this.readInt();
        this.dwSuggestedBufferSize = this.readInt();
        this.dwWidth = this.readInt();
        this.dwHeight = this.readInt();
        if (this.verbose) {
            IJ.log("AVI HEADER (avih):" + this.timeString());
            IJ.log("   dwMicroSecPerFrame=" + this.dwMicroSecPerFrame);
            IJ.log("   dwMaxBytesPerSec=" + this.dwMaxBytesPerSec);
            IJ.log("   dwReserved1=" + this.dwReserved1);
            IJ.log("   dwFlags=" + this.dwFlags);
            IJ.log("   dwTotalFrames=" + this.dwTotalFrames);
            IJ.log("   dwInitialFrames=" + this.dwInitialFrames);
            IJ.log("   dwStreams=" + this.dwStreams);
            IJ.log("   dwSuggestedBufferSize=" + this.dwSuggestedBufferSize);
            IJ.log("   dwWidth=" + this.dwWidth);
            IJ.log("   dwHeight=" + this.dwHeight);
        }
    }

    void readStreamHeader() throws Exception, IOException {
        this.fccStreamHandler = this.readInt();
        this.dwStreamFlags = this.readInt();
        this.dwPriorityLanguage = this.readInt();
        this.dwStreamInitialFrames = this.readInt();
        this.dwStreamScale = this.readInt();
        this.dwStreamRate = this.readInt();
        this.dwStreamStart = this.readInt();
        this.dwStreamLength = this.readInt();
        this.dwStreamSuggestedBufferSize = this.readInt();
        this.dwStreamQuality = this.readInt();
        this.dwStreamSampleSize = this.readInt();
        if (this.verbose) {
            IJ.log("VIDEO STREAM HEADER (strh):");
            IJ.log("   fccStreamHandler='" + this.fourccString(this.fccStreamHandler) + "'");
            IJ.log("   dwStreamFlags=" + this.dwStreamFlags);
            IJ.log("   wPriority,wLanguage=" + this.dwPriorityLanguage);
            IJ.log("   dwStreamInitialFrames=" + this.dwStreamInitialFrames);
            IJ.log("   dwStreamScale=" + this.dwStreamScale);
            IJ.log("   dwStreamRate=" + this.dwStreamRate);
            IJ.log("   dwStreamStart=" + this.dwStreamStart);
            IJ.log("   dwStreamLength=" + this.dwStreamLength);
            IJ.log("   dwStreamSuggestedBufferSize=" + this.dwStreamSuggestedBufferSize);
            IJ.log("   dwStreamQuality=" + this.dwStreamQuality);
            IJ.log("   dwStreamSampleSize=" + this.dwStreamSampleSize);
        }
        if (this.dwStreamSampleSize > 1) {
            throw new Exception("Video stream with " + this.dwStreamSampleSize + " (more than 1) frames/chunk not supported");
        }
        this.type0xdb = 1650733104 + (this.streamNumber << 8);
        this.type0xdc = 1667510320 + (this.streamNumber << 8);
    }

    private void readAvi2Index(long endPosition) throws Exception, IOException {
        short wLongsPerEntry = this.readShort();
        byte bIndexSubType = this.raFile.readByte();
        byte bIndexType = this.raFile.readByte();
        int nEntriesInUse = this.readInt();
        int dwChunkId = this.readInt();
        long qwBaseOffset = this.readLong();
        this.readInt();
        if (this.verbose) {
            String bIndexString = bIndexType == 1 ? ": AVI_INDEX_OF_CHUNKS" : (bIndexType == 0 ? ": AVI_INDEX_OF_INDEXES" : ": UNSUPPORTED");
            IJ.log("AVI 2 INDEX:");
            if (this.indexForCountingOnly) {
                IJ.log("<just counting frames, not interpreting index now>");
            }
            IJ.log("   wLongsPerEntry=" + wLongsPerEntry);
            IJ.log("   bIndexSubType=" + bIndexSubType);
            IJ.log("   bIndexType=" + bIndexType + bIndexString);
            IJ.log("   nEntriesInUse=" + nEntriesInUse);
            IJ.log("   dwChunkId='" + this.fourccString(dwChunkId) + "'");
            if (bIndexType == 1) {
                IJ.log("   qwBaseOffset=0x" + Long.toHexString(qwBaseOffset));
            }
        }
        if (bIndexType == 0) {
            if (wLongsPerEntry != 4) {
                return;
            }
            int i = 0;
            while (i < nEntriesInUse) {
                long qwOffset = this.readLong();
                int dwSize = this.readInt();
                int dwDuration = this.readInt();
                if (this.verbose) {
                    IJ.log("   index data '" + this.fourccString(dwChunkId) + "' " + this.posSizeString(qwOffset, dwSize) + this.timeString());
                }
                long temp = this.raFile.getFilePointer();
                this.raFile.seek(qwOffset);
                this.findFourccAndRead(808482921, false, qwOffset + (long)dwSize, true);
                this.raFile.seek(temp);
                if (this.frameNumber <= this.lastFrameToRead) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (bIndexType == 1) {
            if (wLongsPerEntry != 2) {
                return;
            }
            if (dwChunkId != this.type0xdb && dwChunkId != this.type0xdc) {
                if (this.verbose) {
                    IJ.log("INDEX ERROR: SKIPPED ix00, wrong stream number or type, should be " + this.fourccString(this.type0xdb) + " or " + this.fourccString(this.type0xdc));
                }
                return;
            }
            if (this.indexForCountingOnly) {
                this.totalFramesFromIndex += nEntriesInUse;
                return;
            }
            int i = 0;
            while (i < nEntriesInUse) {
                long dwOffset = (long)this.readInt() & 0xFFFFFFFFL;
                long pos = qwBaseOffset + dwOffset;
                int dwSize = this.readInt();
                if (this.isVirtual) {
                    IJ.showProgress((double)this.frameNumber / (double)this.lastFrameToRead);
                }
                if (this.frameNumber >= this.firstFrame && dwSize > 0) {
                    this.frameInfos.add(new long[]{pos, dwSize, (long)this.frameNumber * (long)this.dwMicroSecPerFrame});
                }
                ++this.frameNumber;
                if (this.frameNumber > this.lastFrameToRead) break;
                ++i;
            }
            if (this.verbose) {
                IJ.log("Index read up to frame " + (this.frameNumber - 1));
            }
        }
    }

    private void readOldFrameIndex(long endPosition) throws Exception, IOException {
        int offset = -1;
        int[] nArray = new int[2];
        nArray[1] = (int)this.moviPosition;
        int[] offsetsToTry = nArray;
        while (this.raFile.getFilePointer() + 16L <= endPosition) {
            int dwChunkId = this.readInt();
            int dwFlags = this.readInt();
            int dwOffset = this.readInt();
            int dwSize = this.readInt();
            if (dwChunkId != this.type0xdb && dwChunkId != this.type0xdc || dwSize <= 0) continue;
            if (offset < 0) {
                long temp = this.raFile.getFilePointer();
                int i = 0;
                while (i < offsetsToTry.length) {
                    long pos = (long)(dwOffset + offsetsToTry[i]) & 0xFFFFFFFFL;
                    if (pos >= this.moviPosition) {
                        this.raFile.seek(pos);
                        int chunkIdAtPos = this.readInt();
                        if (chunkIdAtPos == dwChunkId) {
                            offset = offsetsToTry[i];
                            break;
                        }
                    }
                    ++i;
                }
                if (this.verbose) {
                    IJ.log("idx1: dwOffsets are w.r.t. 0x" + (offset < 0 ? " UNKONWN??" : Long.toHexString(offset)));
                }
                this.raFile.seek(temp);
                if (offset < 0) {
                    return;
                }
            }
            if (this.frameNumber >= this.firstFrame) {
                long framepos = ((long)dwOffset & 0xFFFFFFFFL) + (long)offset;
                this.frameInfos.add(new long[]{framepos + 8L, dwSize, (long)this.frameNumber * (long)this.dwMicroSecPerFrame});
            }
            ++this.frameNumber;
            if (this.frameNumber <= this.lastFrameToRead) continue;
        }
        if (this.verbose) {
            IJ.log("Index read up to frame " + (this.frameNumber - 1));
        }
    }

    void readBitMapInfo(long endPosition) throws Exception, IOException {
        int bitCountTest;
        this.biSize = this.readInt();
        this.biWidth = this.readInt();
        this.biHeight = this.readInt();
        this.biPlanes = this.readShort();
        this.biBitCount = this.readShort();
        this.biCompression = this.readInt();
        this.biSizeImage = this.readInt();
        this.biXPelsPerMeter = this.readInt();
        this.biYPelsPerMeter = this.readInt();
        this.biClrUsed = this.readInt();
        this.biClrImportant = this.readInt();
        if (this.verbose) {
            IJ.log("   biSize=" + this.biSize);
            IJ.log("   biWidth=" + this.biWidth);
            IJ.log("   biHeight=" + this.biHeight);
            IJ.log("   biPlanes=" + this.biPlanes);
            IJ.log("   biBitCount=" + this.biBitCount);
            IJ.log("   biCompression=0x" + Integer.toHexString(this.biCompression) + " '" + this.fourccString(this.biCompression) + "'");
            IJ.log("   biSizeImage=" + this.biSizeImage);
            IJ.log("   biXPelsPerMeter=" + this.biXPelsPerMeter);
            IJ.log("   biYPelsPerMeter=" + this.biYPelsPerMeter);
            IJ.log("   biClrUsed=" + this.biClrUsed);
            IJ.log("   biClrImportant=" + this.biClrImportant);
        }
        int allowedBitCount = 0;
        boolean readPalette = false;
        switch (this.biCompression) {
            case 0: 
            case 541214546: 
            case 542589266: {
                this.dataCompression = 0;
                this.dataTopDown = this.biHeight < 0;
                allowedBitCount = 65576;
                readPalette = this.biBitCount <= 8;
                break;
            }
            case 538982489: 
            case 808466521: 
            case 1497715271: {
                this.dataTopDown = true;
                this.dataCompression = 0;
                allowedBitCount = 8;
                break;
            }
            case 540422489: 
            case 541870413: {
                this.dataCompression = 0;
                allowedBitCount = 16;
                break;
            }
            case 1448433985: {
                this.dataCompression = 1448433985;
                allowedBitCount = 32;
                break;
            }
            case 842151001: 
            case 0x59565955: {
                this.dataTopDown = true;
            }
            case 842150998: 
            case 1987410275: {
                this.dataCompression = 0x59565955;
                allowedBitCount = 16;
                break;
            }
            case 844715353: 
            case 1447974233: 
            case 0x56595559: {
                this.dataTopDown = true;
                this.dataCompression = 844715353;
                allowedBitCount = 16;
                break;
            }
            case 0x55595659: {
                this.dataTopDown = true;
                this.dataCompression = 0x55595659;
                allowedBitCount = 16;
                break;
            }
            case 808596553: 
            case 825382478: 
            case 842094158: 
            case 842094169: 
            case 1448433993: {
                this.dataCompression = this.dataCompression == 1448433993 ? 808596553 : this.biCompression;
                this.dataTopDown = this.biHeight > 0;
                this.isPlanarFormat = true;
                allowedBitCount = 12;
                break;
            }
            case 4: 
            case 1195724874: 
            case 1196444237: 
            case 1734701162: {
                this.dataCompression = 1734701162;
                this.variableLength = true;
                break;
            }
            case 5: 
            case 541544016: 
            case 543649392: {
                this.variableLength = true;
                this.dataCompression = 543649392;
                break;
            }
            default: {
                throw new Exception("Unsupported compression: " + Integer.toHexString(this.biCompression) + (this.biCompression >= 0x20202020 ? " '" + this.fourccString(this.biCompression) + "'" : ""));
            }
        }
        int n = bitCountTest = this.biBitCount == 24 ? 65536 : (int)this.biBitCount;
        if (allowedBitCount != 0 && (bitCountTest & allowedBitCount) == 0) {
            throw new Exception("Unsupported: " + this.biBitCount + " bits/pixel for compression '" + this.fourccString(this.biCompression) + "'");
        }
        if (this.biHeight < 0) {
            this.biHeight = -this.biHeight;
        }
        if (this.isPlanarFormat && ((this.biWidth & 1) != 0 || (this.biHeight & 1) != 0)) {
            throw new Exception("Odd size (" + this.biWidth + "x" + this.biHeight + ") unsupported with " + this.fourccString(this.biCompression) + " compression");
        }
        int n2 = this.scanLineSize = this.isPlanarFormat ? this.biWidth * this.biBitCount / 8 : (this.biWidth * this.biBitCount + 31) / 32 * 4;
        if (readPalette && this.biClrUsed == 0) {
            this.biClrUsed = 1 << this.biBitCount;
        }
        if (this.verbose) {
            IJ.log("   > data compression=0x" + Integer.toHexString(this.dataCompression) + " '" + this.fourccString(this.dataCompression) + "'");
            IJ.log("   > palette colors=" + this.biClrUsed);
            IJ.log("   > scan line size=" + this.scanLineSize);
            IJ.log("   > data top down=" + this.dataTopDown);
        }
        if (readPalette) {
            long spaceForPalette = endPosition - this.raFile.getFilePointer();
            if (this.verbose) {
                IJ.log("   Reading " + this.biClrUsed + " Palette colors: " + this.posSizeString(spaceForPalette));
            }
            if (spaceForPalette < (long)(this.biClrUsed * 4)) {
                throw new Exception("Not enough data (" + spaceForPalette + ") for palette of size " + this.biClrUsed * 4);
            }
            byte[] pr = new byte[this.biClrUsed];
            byte[] pg = new byte[this.biClrUsed];
            byte[] pb = new byte[this.biClrUsed];
            int i = 0;
            while (i < this.biClrUsed) {
                pb[i] = this.raFile.readByte();
                pg[i] = this.raFile.readByte();
                pr[i] = this.raFile.readByte();
                this.raFile.readByte();
                ++i;
            }
            this.cm = new IndexColorModel((int)this.biBitCount, this.biClrUsed, pr, pg, pb);
        }
    }

    void readMovieData(long endPosition) throws Exception, IOException {
        int type;
        if (this.verbose) {
            IJ.log("MOVIE DATA " + this.posSizeString(endPosition - this.raFile.getFilePointer()) + this.timeString());
        }
        if (this.verbose) {
            IJ.log("Searching for stream " + this.streamNumber + ": '" + this.fourccString(this.type0xdb) + "' or '" + this.fourccString(this.type0xdc) + "' chunks");
        }
        if (this.isVirtual) {
            if (this.frameInfos == null) {
                this.frameInfos = new Vector(100);
            }
        } else if (this.stack == null) {
            this.stack = new ImageStack(this.dwWidth, this.biHeight);
        }
        while ((type = this.readType(endPosition)) != 0) {
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            long pos = this.raFile.getFilePointer();
            long nextPos = pos + size;
            if ((type == this.type0xdb || type == this.type0xdc) && size > 0L) {
                IJ.showProgress((double)this.frameNumber / (double)this.lastFrameToRead);
                if (this.verbose) {
                    IJ.log(String.valueOf(this.frameNumber) + " movie data '" + this.fourccString(type) + "' " + this.posSizeString(size) + this.timeString());
                }
                if (this.frameNumber >= this.firstFrame) {
                    if (this.isVirtual) {
                        this.frameInfos.add(new long[]{pos, size, this.frameNumber * this.dwMicroSecPerFrame});
                    } else {
                        Object pixels = this.readFrame(this.raFile, pos, (int)size);
                        String label = this.frameLabel(this.frameNumber * this.dwMicroSecPerFrame);
                        this.stack.addSlice(label, pixels);
                    }
                }
                ++this.frameNumber;
                if (this.frameNumber > this.lastFrameToRead) {
                    break;
                }
            } else if (this.verbose) {
                IJ.log("skipped '" + this.fourccString(type) + "' " + this.posSizeString(size));
            }
            if (nextPos > endPosition) break;
            this.raFile.seek(nextPos);
        }
    }

    private Object readFrame(RandomAccessFile rFile, long filePos, int size) throws Exception, IOException {
        rFile.seek(filePos);
        if (this.variableLength) {
            return this.readCompressedFrame(rFile, size);
        }
        return this.readFixedLengthFrame(rFile, size);
    }

    private Object readCompressedFrame(RandomAccessFile rFile, int size) throws Exception, IOException {
        raInputStream inputStream = new raInputStream(rFile, size, this.biCompression == 1196444237);
        BufferedImage bi = ImageIO.read(inputStream);
        if (bi == null) {
            throw new Exception("can't read frame, ImageIO returns null");
        }
        int type = bi.getType();
        ImageProcessor ip = null;
        if (type == 10) {
            ip = new ByteProcessor(bi);
        } else if (type == 13) {
            this.cm = bi.getColorModel();
            ip = new ByteProcessor((Image)bi);
        } else {
            ip = new ColorProcessor(bi);
        }
        if (this.convertToGray) {
            ip = ip.convertToByte(false);
        }
        if (this.flipVertical) {
            ip.flipVertical();
        }
        return ip.getPixels();
    }

    private Object readFixedLengthFrame(RandomAccessFile rFile, int size) throws Exception, IOException {
        if (size < this.scanLineSize * this.biHeight) {
            throw new Exception("Data chunk size " + size + " too short (" + this.scanLineSize * this.biHeight + " required)");
        }
        byte[] rawData = new byte[size];
        int n = rFile.read(rawData, 0, size);
        if (n < rawData.length) {
            throw new Exception("Frame ended prematurely after " + n + " bytes");
        }
        boolean topDown = this.flipVertical ? !this.dataTopDown : this.dataTopDown;
        Object[] pixels = null;
        byte[] bPixels = null;
        int[] cPixels = null;
        short[] sPixels = null;
        if (this.biBitCount <= 8 || this.convertToGray) {
            pixels = bPixels = new byte[this.dwWidth * this.biHeight];
        } else if (this.biBitCount == 16 && this.dataCompression == 0) {
            sPixels = new short[this.dwWidth * this.biHeight];
            pixels = sPixels;
        } else {
            cPixels = new int[this.dwWidth * this.biHeight];
            pixels = cPixels;
        }
        if (this.isPlanarFormat && !this.convertToGray) {
            this.unpackPlanarImage(rawData, cPixels, topDown);
        } else {
            int offset = topDown ? 0 : (this.biHeight - 1) * this.dwWidth;
            int rawOffset = 0;
            int i = this.biHeight - 1;
            while (i >= 0) {
                if (this.biBitCount <= 8 || this.isPlanarFormat) {
                    this.unpack8bit(rawData, rawOffset, bPixels, offset, this.dwWidth);
                } else if (this.convertToGray) {
                    this.unpackGray(rawData, rawOffset, bPixels, offset, this.dwWidth);
                } else if (this.biBitCount == 16 && this.dataCompression == 0) {
                    this.unpackShort(rawData, rawOffset, sPixels, offset, this.dwWidth);
                } else {
                    this.unpack(rawData, rawOffset, cPixels, offset, this.dwWidth);
                }
                rawOffset += this.isPlanarFormat ? this.dwWidth : this.scanLineSize;
                offset += topDown ? this.dwWidth : -this.dwWidth;
                --i;
            }
        }
        return pixels;
    }

    void unpack8bit(byte[] rawData, int rawOffset, byte[] pixels, int byteOffset, int w) {
        int i = 0;
        while (i < w) {
            pixels[byteOffset + i] = rawData[rawOffset + i];
            ++i;
        }
    }

    void unpackGray(byte[] rawData, int rawOffset, byte[] pixels, int byteOffset, int w) {
        int j = byteOffset;
        int k = rawOffset;
        if (this.dataCompression == 0) {
            int i = 0;
            while (i < w) {
                int b0 = rawData[k++] & 0xFF;
                int b1 = rawData[k++] & 0xFF;
                int b2 = rawData[k++] & 0xFF;
                if (this.biBitCount == 32) {
                    ++k;
                }
                pixels[j++] = (byte)(b0 * 934 + b1 * 4809 + b2 * 2449 + 4096 >> 13);
                ++i;
            }
        } else {
            if (this.dataCompression == 0x59565955 || this.dataCompression == 1448433985) {
                ++k;
            }
            int step = this.dataCompression == 1448433985 ? 4 : 2;
            int i = 0;
            while (i < w) {
                pixels[j++] = rawData[k];
                k += step;
                ++i;
            }
        }
    }

    void unpackShort(byte[] rawData, int rawOffset, short[] pixels, int shortOffset, int w) {
        int j = shortOffset;
        int k = rawOffset;
        int i = 0;
        while (i < w) {
            pixels[j++] = (short)(rawData[k++] & 0xFF | (rawData[k++] & 0xFF) << 8);
            ++i;
        }
    }

    void unpack(byte[] rawData, int rawOffset, int[] pixels, int intOffset, int w) {
        int j = intOffset;
        int k = rawOffset;
        switch (this.dataCompression) {
            case 0: {
                int i = 0;
                while (i < w) {
                    int b0 = rawData[k++] & 0xFF;
                    int b1 = (rawData[k++] & 0xFF) << 8;
                    int b2 = (rawData[k++] & 0xFF) << 16;
                    if (this.biBitCount == 32) {
                        ++k;
                    }
                    pixels[j++] = 0xFF000000 | b0 | b1 | b2;
                    ++i;
                }
                break;
            }
            case 844715353: {
                int i = 0;
                while (i < w / 2) {
                    int y0 = rawData[k++] & 0xFF;
                    int u = rawData[k++] ^ 0xFFFFFF80;
                    int y1 = rawData[k++] & 0xFF;
                    int v = rawData[k++] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(y0, u, v, pixels, j++);
                    this.writeRGBfromYUV(y1, u, v, pixels, j++);
                    ++i;
                }
                break;
            }
            case 0x59565955: {
                int i = 0;
                while (i < w / 2) {
                    int u = rawData[k++] ^ 0xFFFFFF80;
                    int y0 = rawData[k++] & 0xFF;
                    int v = rawData[k++] ^ 0xFFFFFF80;
                    int y1 = rawData[k++] & 0xFF;
                    this.writeRGBfromYUV(y0, u, v, pixels, j++);
                    this.writeRGBfromYUV(y1, u, v, pixels, j++);
                    ++i;
                }
                break;
            }
            case 0x55595659: {
                int i = 0;
                while (i < w / 2) {
                    int y0 = rawData[k++] & 0xFF;
                    int v = rawData[k++] ^ 0xFFFFFF80;
                    int y1 = rawData[k++] & 0xFF;
                    int u = rawData[k++] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(y0, u, v, pixels, j++);
                    this.writeRGBfromYUV(y1, u, v, pixels, j++);
                    ++i;
                }
                break;
            }
            case 1448433985: {
                int i = 0;
                while (i < w) {
                    int n = ++k;
                    int y = rawData[n] & 0xFF;
                    int n2 = ++k;
                    int v = rawData[n2] ^ 0xFFFFFF80;
                    int n3 = ++k;
                    ++k;
                    int u = rawData[n3] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(y, u, v, pixels, j++);
                    ++i;
                }
                break;
            }
        }
    }

    void unpackPlanarImage(byte[] rawData, int[] cPixels, boolean topDown) {
        int uvInc;
        int w = this.dwWidth;
        int h = this.dwHeight;
        int uP = w * h;
        int vP = w * h;
        int n = uvInc = this.dataCompression == 842094158 || this.dataCompression == 825382478 ? 2 : 1;
        if (this.dataCompression == 842094169) {
            uP += w * h / 4;
        } else if (this.dataCompression == 808596553) {
            vP += w * h / 4;
        } else if (this.dataCompression == 842094158) {
            ++vP;
        } else {
            ++uP;
        }
        int lineOutInc = topDown ? w : -w;
        int line = 0;
        while (line < h) {
            int pRaw0 = line * w;
            int pRawEnd = pRaw0 + w;
            int pOut = topDown ? line * w : (h - line - 1) * w;
            int pRaw = pRaw0;
            while (pRaw < pRawEnd) {
                int u = rawData[uP] ^ 0xFFFFFF80;
                int v = rawData[vP] ^ 0xFFFFFF80;
                this.writeRGBfromYUV(rawData[pRaw] & 0xFF, u, v, cPixels, pOut);
                this.writeRGBfromYUV(rawData[pRaw + w] & 0xFF, u, v, cPixels, pOut + lineOutInc);
                this.writeRGBfromYUV(rawData[++pRaw] & 0xFF, u, v, cPixels, ++pOut);
                this.writeRGBfromYUV(rawData[pRaw + w] & 0xFF, u, v, cPixels, pOut + lineOutInc);
                ++pRaw;
                ++pOut;
                uP += uvInc;
                vP += uvInc;
            }
            line += 2;
        }
    }

    final void writeRGBfromYUV(int y, int u, int v, int[] pixels, int intArrayIndex) {
        int r = 9535 * y + 13074 * v - 148464 >> 13;
        int g = 9535 * y - 6660 * v - 3203 * u - 148464 >> 13;
        int b = 9535 * y + 16531 * u - 148464 >> 13;
        if (r > 255) {
            r = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (b > 255) {
            b = 255;
        }
        if (b < 0) {
            b = 0;
        }
        pixels[intArrayIndex] = 0xFF000000 | r << 16 | g << 8 | b;
    }

    final long readLong() throws IOException {
        long low = (long)this.readInt() & 0xFFFFFFFFL;
        long high = (long)this.readInt() & 0xFFFFFFFFL;
        long result = high << 32 | low;
        return result;
    }

    final int readInt() throws IOException {
        int result = 0;
        int shiftBy = 0;
        while (shiftBy < 32) {
            result |= (this.raFile.readByte() & 0xFF) << shiftBy;
            shiftBy += 8;
        }
        return result;
    }

    final short readShort() throws IOException {
        int low = this.raFile.readByte() & 0xFF;
        int high = this.raFile.readByte() & 0xFF;
        return (short)(high << 8 | low);
    }

    private int readType(long endPosition) throws IOException {
        while (true) {
            long pos;
            if ((pos = this.raFile.getFilePointer()) % (long)this.paddingGranularity != 0L) {
                pos = (pos / (long)this.paddingGranularity + 1L) * (long)this.paddingGranularity;
                this.raFile.seek(pos);
            }
            if (pos >= endPosition) {
                return 0;
            }
            int type = this.readInt();
            if (type != 1263424842) {
                return type;
            }
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            if (this.verbose) {
                IJ.log("Skip JUNK: " + this.posSizeString(size));
            }
            this.raFile.seek(this.raFile.getFilePointer() + size);
        }
    }

    private void setFramesPerSecond(ImagePlus imp) {
        if (this.dwMicroSecPerFrame < 1000 && this.dwStreamRate > 0) {
            this.dwMicroSecPerFrame = (int)((double)this.dwStreamScale * 1000000.0 / (double)this.dwStreamRate);
        }
        if (this.dwMicroSecPerFrame >= 1000) {
            imp.getCalibration().fps = 1000000.0 / (double)this.dwMicroSecPerFrame;
        }
    }

    private String frameLabel(long timeMicroSec) {
        return String.valueOf(IJ.d2s((double)timeMicroSec / 1000000.0)) + " s";
    }

    private String posSizeString(long size) throws IOException {
        return this.posSizeString(this.raFile.getFilePointer(), size);
    }

    private String posSizeString(long pos, long size) throws IOException {
        return "0x" + Long.toHexString(pos) + "-0x" + Long.toHexString(pos + size - 1L) + " (" + size + " Bytes)";
    }

    private String timeString() {
        return " (t=" + (System.currentTimeMillis() - this.startTime) + " ms)";
    }

    private String fourccString(int fourcc) {
        String s = "";
        int i = 0;
        while (i < 4) {
            int c = fourcc & 0xFF;
            s = String.valueOf(s) + Character.toString((char)c);
            fourcc >>= 8;
            ++i;
        }
        return s;
    }

    private void error(String msg) {
        this.aborting = true;
        IJ.error("AVI Reader", msg);
    }

    private String exceptionMessage(Exception e) {
        Class<?> clazz = e.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Exception");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String msg = clazz == clazz2 ? e.getMessage() : e + "\n" + e.getStackTrace()[0] + "\n" + e.getStackTrace()[1];
        return "An error occurred reading the AVI file.\n \n" + msg;
    }

    class raInputStream
    extends InputStream {
        RandomAccessFile rFile;
        int readableSize;
        boolean fixMJPG;
        byte[] buffer;
        int bufferPointer;
        int bufferLength;

        raInputStream(RandomAccessFile rFile, int readableSize, boolean fixMJPG) throws IOException {
            this.rFile = rFile;
            this.readableSize = readableSize;
            this.fixMJPG = fixMJPG;
            if (fixMJPG) {
                this.buffer = new byte[4096];
                this.bufferLength = Math.min(3676, readableSize);
                this.bufferLength = rFile.read(this.buffer, 0, this.bufferLength);
                this.addHuffmanTables();
            }
        }

        public int available() {
            return this.readableSize;
        }

        public int read() throws IOException {
            --this.readableSize;
            if (this.fixMJPG) {
                int result = this.buffer[this.bufferPointer] & 0xFF;
                ++this.bufferPointer;
                if (this.bufferPointer >= this.bufferLength) {
                    this.fixMJPG = false;
                }
                return result;
            }
            return this.rFile.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int nBytes;
            if (this.fixMJPG) {
                nBytes = Math.min(len, this.bufferLength - this.bufferPointer);
                System.arraycopy(this.buffer, this.bufferPointer, b, off, nBytes);
                this.bufferPointer += nBytes;
                if (this.bufferPointer >= this.bufferLength) {
                    this.fixMJPG = false;
                    if (len - nBytes > 0) {
                        nBytes += this.rFile.read(b, off + nBytes, len - nBytes);
                    }
                }
            } else {
                nBytes = this.rFile.read(b, off, len);
            }
            this.readableSize -= nBytes;
            return nBytes;
        }

        private void addHuffmanTables() {
            if (this.readShort(0) != 65496 || this.bufferLength < 6) {
                return;
            }
            int offset = 2;
            int segmentLength = 0;
            do {
                int code;
                if ((code = this.readShort(offset)) == 65476) {
                    return;
                }
                if (code == 65498 || code == 65497) {
                    this.insertHuffmanTables(offset);
                    return;
                }
                offset += 2;
            } while ((offset += (segmentLength = this.readShort(offset))) < this.bufferLength - 4 && segmentLength >= 0);
        }

        private int readShort(int offset) {
            return (this.buffer[offset] & 0xFF) << 8 | this.buffer[offset + 1] & 0xFF;
        }

        private void insertHuffmanTables(int position) {
            System.arraycopy(this.buffer, position, this.buffer, position + 420, this.bufferLength - position);
            System.arraycopy(HUFFMAN_TABLES, 0, this.buffer, position, 420);
            this.bufferLength += 420;
            this.readableSize += 420;
        }
    }
}

