/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.macro.Tokenizer;
import ij.measure.Minimizer;
import ij.measure.UserFunction;
import java.util.Hashtable;

public class CurveFitter
implements UserFunction {
    public static final int STRAIGHT_LINE = 0;
    public static final int POLY2 = 1;
    public static final int POLY3 = 2;
    public static final int POLY4 = 3;
    public static final int EXPONENTIAL = 4;
    public static final int POWER = 5;
    public static final int LOG = 6;
    public static final int RODBARD = 7;
    public static final int GAMMA_VARIATE = 8;
    public static final int LOG2 = 9;
    public static final int RODBARD2 = 10;
    public static final int EXP_WITH_OFFSET = 11;
    public static final int GAUSSIAN = 12;
    public static final int EXP_RECOVERY = 13;
    public static final int INV_RODBARD = 14;
    public static final int EXP_REGRESSION = 15;
    public static final int POWER_REGRESSION = 16;
    public static final int POLY5 = 17;
    public static final int POLY6 = 18;
    public static final int POLY7 = 19;
    public static final int POLY8 = 20;
    public static final int GAUSSIAN_NOOFFSET = 21;
    public static final int[] sortedTypes;
    public static final String[] fitList;
    public static final String[] fList;
    public static final int IterFactor = 500;
    private static final int CUSTOM = 100;
    private static final int GAUSSIAN_INTERNAL = 101;
    private static final int RODBARD_INTERNAL = 102;
    private int fitType = -1;
    private double[] xData;
    private double[] yData;
    private double[] xDataSave;
    private double[] yDataSave;
    private int numPoints;
    private double ySign = 0.0;
    private double sumY = Double.NaN;
    private double sumY2 = Double.NaN;
    private int numParams;
    private double[] initialParams;
    private double[] initialParamVariations;
    private double[] minimizerInitialParams;
    private double[] minimizerInitialParamVariations;
    private double maxRelError = 1.0E-10;
    private long time;
    private int customParamCount;
    private String customFormula;
    private UserFunction userFunction;
    private Interpreter macro;
    private int macroStartProgramCounter;
    private int numRegressionParams;
    private int offsetParam = -1;
    private int factorParam = -1;
    private boolean hasSlopeParam;
    private double[] finalParams;
    private boolean linearRegressionUsed;
    private boolean restrictPower;
    private Minimizer minimizer = new Minimizer();
    private int minimizerStatus = 1;
    private String errorString;
    private static String[] sortedFitList;
    private static Hashtable namesTable;

    static {
        int[] nArray = new int[22];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 17;
        nArray[5] = 18;
        nArray[6] = 19;
        nArray[7] = 20;
        nArray[8] = 5;
        nArray[9] = 16;
        nArray[10] = 4;
        nArray[11] = 15;
        nArray[12] = 11;
        nArray[13] = 13;
        nArray[14] = 6;
        nArray[15] = 9;
        nArray[16] = 7;
        nArray[17] = 10;
        nArray[18] = 14;
        nArray[19] = 12;
        nArray[20] = 21;
        nArray[21] = 8;
        sortedTypes = nArray;
        fitList = new String[]{"Straight Line", "2nd Degree Polynomial", "3rd Degree Polynomial", "4th Degree Polynomial", "Exponential", "Power", "Log", "Rodbard", "Gamma Variate", "y = a+b*ln(x-c)", "Rodbard (NIH Image)", "Exponential with Offset", "Gaussian", "Exponential Recovery", "Inverse Rodbard", "Exponential (linear regression)", "Power (linear regression)", "5th Degree Polynomial", "6th Degree Polynomial", "7th Degree Polynomial", "8th Degree Polynomial", "Gaussian (no offset)"};
        fList = new String[]{"y = a+bx", "y = a+bx+cx^2", "y = a+bx+cx^2+dx^3", "y = a+bx+cx^2+dx^3+ex^4", "y = a*exp(bx)", "y = a*x^b", "y = a*ln(bx)", "y = d+(a-d)/(1+(x/c)^b)", "y = b*(x-a)^c*exp(-(x-a)/d)", "y = a+b*ln(x-c)", "x = d+(a-d)/(1+(y/c)^b)", "y = a*exp(-bx) + c", "y = a + (b-a)*exp(-(x-c)*(x-c)/(2*d*d))", "y = a*(1-exp(-b*x)) + c", "y = c*((x-a)/(d-x))^(1/b)", "y = a*exp(bx)", "y = a*x^b", "y = a+bx+cx^2+dx^3+ex^4+fx^5", "y = a+bx+cx^2+dx^3+ex^4+fx^5+gx^6", "y = a+bx+cx^2+dx^3+ex^4+fx^5+gx^6+hx^7", "y = a+bx+cx^2+dx^3+ex^4+fx^5+gx^6+hx^7+ix^8", "y = a*exp(-(x-b)*(x-b)/(2*c*c)))"};
    }

    public CurveFitter(double[] xData, double[] yData) {
        this.xData = xData;
        this.yData = yData;
        this.numPoints = xData.length;
    }

    public void doFit(int fitType) {
        this.doFit(fitType, false);
    }

    public void doFit(int fitType, boolean showSettings) {
        if ((fitType < 0 || fitType >= fitList.length) && fitType != 100) {
            throw new IllegalArgumentException("Invalid fit type");
        }
        if (fitType == 100 && this.macro == null && this.userFunction == null) {
            throw new IllegalArgumentException("No custom formula!");
        }
        this.fitType = fitType;
        if (this.isModifiedFitType(fitType) && !this.prepareModifiedFitType(fitType)) {
            return;
        }
        this.numParams = this.getNumParams();
        if (fitType != 100) {
            this.getOffsetAndFactorParams();
        }
        this.calculateSumYandY2();
        long startTime = System.currentTimeMillis();
        if (this.fitType == 0) {
            this.finalParams = new double[]{0.0, 0.0, 0.0};
            this.doRegression(this.finalParams);
            this.linearRegressionUsed = true;
        } else {
            this.minimizer.setFunction(this, this.numParams - this.numRegressionParams);
            this.minimizer.setExtraArrayElements(this.numRegressionParams);
            if (this.macro != null) {
                this.minimizer.setMaximumThreads(1);
            }
            if (!this.makeInitialParamsAndVariations(fitType)) {
                return;
            }
            if (showSettings) {
                this.settingsDialog();
            }
            if (this.numRegressionParams > 0) {
                this.modifyInitialParamsAndVariations();
            } else {
                this.minimizerInitialParams = this.initialParams;
                this.minimizerInitialParamVariations = this.initialParamVariations;
            }
            startTime = System.currentTimeMillis();
            double maxAbsError = Math.min(1.0E-6, this.maxRelError) * Math.sqrt(this.sumY2);
            this.minimizer.setMaxError(this.maxRelError, maxAbsError);
            this.minimizerStatus = this.minimizer.minimize(this.minimizerInitialParams, this.minimizerInitialParamVariations);
            this.finalParams = this.minimizer.getParams();
            if (this.numRegressionParams > 0) {
                this.minimizerParamsToFullParams(this.finalParams, false);
            }
        }
        if (this.isModifiedFitType(fitType)) {
            this.postProcessModifiedFitType(fitType);
        }
        this.time = System.currentTimeMillis() - startTime;
    }

    public int doCustomFit(String equation, double[] initialParams, boolean showSettings) {
        block8: {
            this.customFormula = null;
            this.customParamCount = 0;
            Program pgm = new Tokenizer().tokenize(equation);
            if (!pgm.hasWord("y")) {
                return 0;
            }
            if (!pgm.hasWord("x")) {
                return 0;
            }
            String[] params = new String[]{"a", "b", "c", "d", "e", "f"};
            int i = 0;
            while (i < params.length) {
                if (pgm.hasWord(params[i])) {
                    ++this.customParamCount;
                }
                ++i;
            }
            if (this.customParamCount == 0) {
                return 0;
            }
            this.customFormula = equation;
            String code = "var x, a, b, c, d, e, f;\nfunction dummy() {}\n" + equation + ";\n";
            this.macroStartProgramCounter = 21;
            this.macro = new Interpreter();
            try {
                this.macro.run(code, null);
            }
            catch (Exception e) {
                if ("Macro canceled".equals(e.getMessage())) break block8;
                IJ.handleException(e);
            }
        }
        if (this.macro.wasError()) {
            return 0;
        }
        this.initialParams = initialParams;
        this.doFit(100, showSettings);
        return this.customParamCount;
    }

    public void doCustomFit(UserFunction userFunction, int numParams, String formula, double[] initialParams, double[] initialParamVariations, boolean showSettings) {
        this.userFunction = userFunction;
        this.customParamCount = numParams;
        this.initialParams = initialParams;
        this.initialParamVariations = initialParamVariations;
        this.customFormula = formula == null ? "(defined in plugin)" : formula;
        this.doFit(100, showSettings);
    }

    public void setInitialParameters(double[] initialParams) {
        this.initialParams = initialParams;
    }

    public Minimizer getMinimizer() {
        return this.minimizer;
    }

    public void setOffsetMultiplySlopeParams(int offsetParam, int multiplyParam, int slopeParam) {
        this.offsetParam = offsetParam;
        this.hasSlopeParam = slopeParam >= 0;
        this.factorParam = this.hasSlopeParam ? slopeParam : multiplyParam;
        this.numRegressionParams = 0;
        if (offsetParam >= 0) {
            ++this.numRegressionParams;
        }
        if (this.factorParam >= 0) {
            ++this.numRegressionParams;
        }
    }

    public int getNumParams() {
        switch (this.fitType) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 17: {
                return 6;
            }
            case 18: {
                return 7;
            }
            case 19: {
                return 8;
            }
            case 20: {
                return 9;
            }
            case 4: 
            case 15: {
                return 2;
            }
            case 5: 
            case 16: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 7: 
            case 10: 
            case 14: 
            case 102: {
                return 4;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 3;
            }
            case 11: {
                return 3;
            }
            case 12: 
            case 101: {
                return 4;
            }
            case 21: {
                return 3;
            }
            case 13: {
                return 3;
            }
            case 100: {
                return this.customParamCount;
            }
        }
        return 0;
    }

    public final double f(double[] p, double x) {
        if (this.fitType != 100) {
            return CurveFitter.f(this.fitType, p, x);
        }
        if (this.macro == null) {
            return this.userFunction.userFunction(p, x);
        }
        this.macro.setVariable("x", x);
        this.macro.setVariable("a", p[0]);
        if (this.customParamCount > 1) {
            this.macro.setVariable("b", p[1]);
        }
        if (this.customParamCount > 2) {
            this.macro.setVariable("c", p[2]);
        }
        if (this.customParamCount > 3) {
            this.macro.setVariable("d", p[3]);
        }
        if (this.customParamCount > 4) {
            this.macro.setVariable("e", p[4]);
        }
        if (this.customParamCount > 5) {
            this.macro.setVariable("f", p[5]);
        }
        this.macro.run(this.macroStartProgramCounter);
        return this.macro.getVariable("y");
    }

    public static double f(int fitType, double[] p, double x) {
        switch (fitType) {
            case 0: {
                return p[0] + x * p[1];
            }
            case 1: {
                return p[0] + x * (p[1] + x * p[2]);
            }
            case 2: {
                return p[0] + x * (p[1] + x * (p[2] + x * p[3]));
            }
            case 3: {
                return p[0] + x * (p[1] + x * (p[2] + x * (p[3] + x * p[4])));
            }
            case 17: {
                return p[0] + x * (p[1] + x * (p[2] + x * (p[3] + x * (p[4] + x * p[5]))));
            }
            case 18: {
                return p[0] + x * (p[1] + x * (p[2] + x * (p[3] + x * (p[4] + x * (p[5] + x * p[6])))));
            }
            case 19: {
                return p[0] + x * (p[1] + x * (p[2] + x * (p[3] + x * (p[4] + x * (p[5] + x * (p[6] + x * p[7]))))));
            }
            case 20: {
                return p[0] + x * (p[1] + x * (p[2] + x * (p[3] + x * (p[4] + x * (p[5] + x * (p[6] + x * (p[7] + x * p[8])))))));
            }
            case 4: 
            case 15: {
                return p[0] * Math.exp(p[1] * x);
            }
            case 11: {
                return p[0] * Math.exp(-p[1] * x) + p[2];
            }
            case 13: {
                return p[0] * (1.0 - Math.exp(-p[1] * x)) + p[2];
            }
            case 12: {
                return p[0] + (p[1] - p[0]) * Math.exp(-(x - p[2]) * (x - p[2]) / (2.0 * p[3] * p[3]));
            }
            case 101: {
                return p[0] + p[1] * Math.exp(-(x - p[2]) * (x - p[2]) / (2.0 * p[3] * p[3]));
            }
            case 21: {
                return p[0] * Math.exp(-(x - p[1]) * (x - p[1]) / (2.0 * p[2] * p[2]));
            }
            case 5: 
            case 16: {
                return p[0] * Math.pow(x, p[1]);
            }
            case 6: {
                if (x == 0.0) {
                    return -1000.0 * p[0];
                }
                return p[0] * Math.log(p[1] * x);
            }
            case 7: {
                double ex = Math.pow(x / p[2], p[1]);
                return p[3] + (p[0] - p[3]) / (1.0 + ex);
            }
            case 102: {
                double ex = Math.pow(x / p[2], p[1]);
                return p[3] + p[0] / (1.0 + ex);
            }
            case 8: {
                if (p[0] >= x) {
                    return 0.0;
                }
                if (p[1] <= 0.0) {
                    return Double.NaN;
                }
                if (p[2] <= 0.0) {
                    return Double.NaN;
                }
                if (p[3] <= 0.0) {
                    return Double.NaN;
                }
                double pw = Math.pow(x - p[0], p[2]);
                double e = Math.exp(-(x - p[0]) / p[3]);
                return p[1] * pw * e;
            }
            case 9: {
                double tmp = x - p[2];
                if (tmp <= 0.0) {
                    return Double.NaN;
                }
                return p[0] + p[1] * Math.log(tmp);
            }
            case 10: 
            case 14: {
                double y;
                if (p[3] - x < 9.9E-324 || x < p[0]) {
                    y = fitType == 14 ? Double.NaN : 0.0;
                } else {
                    y = (x - p[0]) / (p[3] - x);
                    y = Math.pow(y, 1.0 / p[1]);
                    y *= p[2];
                }
                return y;
            }
        }
        return 0.0;
    }

    public double[] getParams() {
        return this.finalParams == null ? this.minimizer.getParams() : this.finalParams;
    }

    public double[] getResiduals() {
        double[] params = this.getParams();
        double[] residuals = new double[this.xData.length];
        int i = 0;
        while (i < this.xData.length) {
            residuals[i] = this.yData[i] - this.f(params, this.xData[i]);
            ++i;
        }
        return residuals;
    }

    public double getSumResidualsSqr() {
        return this.getParams()[this.numParams];
    }

    public double getSD() {
        double[] residuals = this.getResiduals();
        int n = residuals.length;
        double sum = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < n) {
            sum += residuals[i];
            sum2 += residuals[i] * residuals[i];
            ++i;
        }
        double stdDev = sum2 - sum * sum / (double)n;
        return Math.sqrt(stdDev / ((double)n - 1.0));
    }

    public double getRSquared() {
        if (Double.isNaN(this.sumY)) {
            this.calculateSumYandY2();
        }
        double sumMeanDiffSqr = this.sumY2 - this.sumY * this.sumY / (double)this.numPoints;
        double rSquared = 0.0;
        if (sumMeanDiffSqr > 0.0) {
            rSquared = 1.0 - this.getSumResidualsSqr() / sumMeanDiffSqr;
        }
        return rSquared;
    }

    public double getFitGoodness() {
        if (Double.isNaN(this.sumY)) {
            this.calculateSumYandY2();
        }
        double sumMeanDiffSqr = this.sumY2 - this.sumY * this.sumY / (double)this.numPoints;
        double fitGoodness = 0.0;
        int degreesOfFreedom = this.numPoints - this.getNumParams();
        if (sumMeanDiffSqr > 0.0 && degreesOfFreedom > 0) {
            fitGoodness = 1.0 - this.getSumResidualsSqr() / sumMeanDiffSqr * (double)this.numPoints / (double)degreesOfFreedom;
        }
        return fitGoodness;
    }

    public int getStatus() {
        return this.linearRegressionUsed ? 0 : this.minimizerStatus;
    }

    public String getStatusString() {
        return this.errorString != null ? this.errorString : Minimizer.STATUS_STRING[this.getStatus()];
    }

    public String getResultString() {
        String resultS = "\nFormula: " + this.getFormula() + "\nStatus: " + this.getStatusString();
        if (!this.linearRegressionUsed) {
            resultS = String.valueOf(resultS) + "\nNumber of completed minimizations: " + this.minimizer.getCompletedMinimizations();
        }
        resultS = String.valueOf(resultS) + "\nNumber of iterations: " + this.getIterations();
        if (!this.linearRegressionUsed) {
            resultS = String.valueOf(resultS) + " (max: " + this.minimizer.getMaxIterations() + ")";
        }
        resultS = String.valueOf(resultS) + "\nTime: " + this.time + " ms" + "\nSum of residuals squared: " + IJ.d2s(this.getSumResidualsSqr(), 5, 9) + "\nStandard deviation: " + IJ.d2s(this.getSD(), 5, 9) + "\nR^2: " + IJ.d2s(this.getRSquared(), 5) + "\nParameters:";
        char pChar = 'a';
        double[] pVal = this.getParams();
        int i = 0;
        while (i < this.numParams) {
            resultS = String.valueOf(resultS) + "\n\t" + pChar + " = " + IJ.d2s(pVal[i], 5, 9);
            pChar = (char)(pChar + '\u0001');
            ++i;
        }
        return resultS;
    }

    public void setRestarts(int maxRestarts) {
        this.minimizer.setMaxRestarts(maxRestarts);
    }

    public void setMaxError(double maxRelError) {
        if (Double.isNaN(maxRelError)) {
            return;
        }
        if (maxRelError > 0.1) {
            maxRelError = 0.1;
        }
        if (maxRelError < 1.0E-16) {
            maxRelError = 1.0E-16;
        }
        this.maxRelError = maxRelError;
    }

    public int getIterations() {
        return this.linearRegressionUsed ? 1 : this.minimizer.getIterations();
    }

    public int getMaxIterations() {
        return this.minimizer.getMaxIterations();
    }

    public void setMaxIterations(int maxIter) {
        this.minimizer.setMaxIterations(maxIter);
    }

    public int getRestarts() {
        return this.minimizer.getMaxRestarts();
    }

    public double[] getXPoints() {
        return this.xData;
    }

    public double[] getYPoints() {
        return this.yData;
    }

    public int getFit() {
        return this.fitType;
    }

    public String getName() {
        if (this.fitType == 100) {
            return "User-defined";
        }
        if (this.fitType == 101) {
            this.fitType = 12;
        } else if (this.fitType == 102) {
            this.fitType = 7;
        }
        return fitList[this.fitType];
    }

    public String getFormula() {
        if (this.fitType == 100) {
            return this.customFormula;
        }
        return fList[this.fitType];
    }

    public static String[] getSortedFitList() {
        if (sortedFitList == null) {
            String[] l = new String[fitList.length];
            int i = 0;
            while (i < fitList.length) {
                CurveFitter.sortedFitList[i] = fitList[sortedTypes[i]];
                ++i;
            }
            sortedFitList = l;
        }
        return sortedFitList;
    }

    public static int getFitCode(String fitName) {
        Integer i;
        if (namesTable == null) {
            Hashtable<String, Integer> h = new Hashtable<String, Integer>();
            int i2 = 0;
            while (i2 < fitList.length) {
                h.put(fitList[i2], new Integer(i2));
                ++i2;
            }
            namesTable = h;
        }
        return (i = (Integer)namesTable.get(fitName)) != null ? i : -1;
    }

    public final double userFunction(double[] params, double dummy) {
        double sumResidualsSqr = 0.0;
        if (this.numRegressionParams == 0) {
            int i = 0;
            while (i < this.numPoints) {
                double fValue = this.f(params, this.xData[i]);
                sumResidualsSqr += this.sqr(fValue - this.yData[i]);
                ++i;
            }
        } else {
            this.minimizerParamsToFullParams(params, true);
            this.doRegression(params);
            sumResidualsSqr = this.fullParamsToMinimizerParams(params);
        }
        return sumResidualsSqr;
    }

    private void minimizerParamsToFullParams(double[] params, boolean forRegression) {
        int i;
        boolean shouldTransformToSmallerParams = false;
        double offset = 0.0;
        double factor = !this.hasSlopeParam ? 1 : 0;
        double sumResidualsSqr = 0.0;
        if (!forRegression) {
            i = params.length - 1;
            if (this.factorParam >= 0) {
                factor = params[i--];
            }
            if (this.offsetParam >= 0) {
                offset = params[i];
            }
            params[this.numParams] = sumResidualsSqr = params[this.numParams - this.numRegressionParams];
        }
        i = this.numParams - 1;
        int iM = this.numParams - this.numRegressionParams - 1;
        while (i >= 0) {
            params[i] = i == this.offsetParam ? offset : (i == this.factorParam ? factor : params[iM--]);
            --i;
        }
        params[this.numParams] = sumResidualsSqr;
    }

    private void doRegression(double[] params) {
        double sumX = 0.0;
        double sumX2 = 0.0;
        double sumXY = 0.0;
        double sumY = 0.0;
        double sumY2 = 0.0;
        int i = 0;
        while (i < this.numPoints) {
            double y;
            double x;
            double fValue;
            double d = fValue = this.fitType == 0 ? 0.0 : this.f(params, this.xData[i]);
            if (Double.isNaN(fValue)) {
                params[this.numParams] = Double.NaN;
                return;
            }
            if (this.hasSlopeParam) {
                x = this.xData[i];
                y = this.yData[i] - fValue;
                sumX += x;
                sumX2 += x * x;
                sumXY += x * y;
                sumY2 += y * y;
                sumY += y;
            } else {
                x = fValue;
                y = this.yData[i];
                sumX += fValue;
                sumX2 += fValue * fValue;
                sumXY += fValue * this.yData[i];
            }
            ++i;
        }
        if (!this.hasSlopeParam) {
            sumY = this.sumY;
            sumY2 = this.sumY2;
        }
        double factor = 0.0;
        double sumResidualsSqr = 0.0;
        if (this.offsetParam < 0) {
            factor = sumXY / sumX2;
            if (Double.isNaN(factor) || Double.isInfinite(factor)) {
                factor = 0.0;
            }
            if ((sumResidualsSqr = sumY2 + factor * (factor * sumX2 - 2.0 * sumXY)) < 2.0E-15 * sumY2) {
                sumResidualsSqr = 2.0E-15 * sumY2;
            }
        } else {
            double offset;
            if (this.factorParam >= 0) {
                factor = (sumXY - sumX * sumY / (double)this.numPoints) / (sumX2 - sumX * sumX / (double)this.numPoints);
                if (this.restrictPower & factor <= 0.0) {
                    factor = 1.0E-100;
                } else if (Double.isNaN(factor) || Double.isInfinite(factor)) {
                    factor = 0.0;
                }
            }
            params[this.offsetParam] = offset = (sumY - factor * sumX) / (double)this.numPoints;
            sumResidualsSqr = this.sqr(factor) * sumX2 + (double)this.numPoints * this.sqr(offset) + sumY2 + 2.0 * factor * offset * sumX - 2.0 * factor * sumXY - 2.0 * offset * sumY;
            if (sumResidualsSqr < 2.0E-15 * (this.sqr(factor) * sumX2 + (double)this.numPoints * this.sqr(offset) + sumY2)) {
                sumResidualsSqr = 2.0E-15 * (this.sqr(factor) * sumX2 + (double)this.numPoints * this.sqr(offset) + sumY2);
            }
        }
        params[this.numParams] = sumResidualsSqr;
        if (this.factorParam >= 0) {
            params[this.factorParam] = factor;
        }
    }

    private double fullParamsToMinimizerParams(double[] params) {
        double offset = this.offsetParam >= 0 ? params[this.offsetParam] : 0.0;
        double factor = this.factorParam >= 0 ? params[this.factorParam] : 0.0;
        double sumResidualsSqr = params[this.numParams];
        int i = 0;
        int iNew = 0;
        while (i < this.numParams) {
            if (i != this.factorParam && i != this.offsetParam) {
                params[iNew++] = params[i];
            }
            ++i;
        }
        i = params.length - 1;
        if (this.factorParam >= 0) {
            params[i--] = factor;
        }
        if (this.offsetParam >= 0) {
            params[i--] = offset;
        }
        params[i--] = sumResidualsSqr;
        return sumResidualsSqr;
    }

    private void modifyInitialParamsAndVariations() {
    }

    private boolean makeInitialParamsAndVariations(int fitType) {
        boolean hasInitialParamVariations;
        boolean hasInitialParams = this.initialParams != null;
        boolean bl = hasInitialParamVariations = this.initialParamVariations != null;
        if (!hasInitialParams) {
            this.initialParams = new double[this.numParams];
        }
        if (!hasInitialParamVariations) {
            this.initialParamVariations = new double[this.numParams];
        }
        if (fitType == 100) {
            return true;
        }
        double firstx = this.xData[0];
        double firsty = this.yData[0];
        double lastx = this.xData[this.numPoints - 1];
        double lasty = this.yData[this.numPoints - 1];
        double xMin = firstx;
        double xMax = firstx;
        double yMin = firsty;
        double yMax = firsty;
        double xMean = 0.0;
        double yMean = 0.0;
        double xOfMax = this.xData[0];
        int i = 1;
        while (i < this.numPoints) {
            xMean += this.xData[i];
            yMean += this.yData[i];
            if (this.xData[i] > xMax) {
                xMax = this.xData[i];
            }
            if (this.xData[i] < xMin) {
                xMin = this.xData[i];
            }
            if (this.yData[i] > yMax) {
                yMax = this.yData[i];
                xOfMax = this.xData[i];
            }
            if (this.yData[i] < yMin) {
                yMin = this.yData[i];
            }
            ++i;
        }
        xMean /= (double)this.numPoints;
        yMean /= (double)this.numPoints;
        double slope = (lasty - firsty) / (lastx - firstx);
        if (Double.isNaN(slope) || Double.isInfinite(slope)) {
            slope = 0.0;
        }
        double yIntercept = yMean - slope * xMean;
        if (xMin < 0.0 && fitType == 5) {
            this.errorString = "Cannot fit " + fitList[fitType] + " when x<0";
            return false;
        }
        if (xMin < 0.0 && xMax > 0.0 && fitType == 7) {
            this.errorString = "Cannot fit " + fitList[fitType] + " to mixture of x<0 and x>0";
            return false;
        }
        if (xMin <= 0.0 && fitType == 6) {
            this.errorString = "Cannot fit " + fitList[fitType] + " when x<=0";
            return false;
        }
        if (!hasInitialParams) {
            double useYmean = 0.0;
            if (yMean > 0.0) {
                useYmean = 1.0;
            } else if (yMean < 0.0) {
                useYmean = -1.0;
            }
            double useSlope = 0.0;
            if (slope > 0.0) {
                useSlope = 1.0;
            } else if (slope < 0.0) {
                useSlope = -1.0;
            }
            switch (fitType) {
                case 4: {
                    this.initialParams[1] = 1.0 / (xMax - xMin + 1.0E-100) * useYmean * useSlope;
                    this.initialParams[0] = yMean / Math.exp(this.initialParams[1] * xMean);
                    break;
                }
                case 11: 
                case 13: {
                    this.initialParams[1] = 1.0 / (xMax - xMin + 1.0E-100);
                    this.initialParams[0] = (yMax - yMin) / Math.exp(this.initialParams[1] * xMean) * useSlope * (double)fitType == 13.0 ? 1 : -1;
                    this.initialParams[2] = 0.5 * yMean;
                    break;
                }
                case 5: {
                    this.initialParams[0] = yMean / Math.abs(xMean + 1.0E-100);
                    this.initialParams[1] = 1.0;
                    break;
                }
                case 6: {
                    this.initialParams[0] = yMean;
                    this.initialParams[1] = Math.E / (xMax + 1.0E-100);
                    break;
                }
                case 9: {
                    this.initialParams[0] = yMean;
                    this.initialParams[1] = (yMax - yMin) / (xMax - xMin + 1.0E-100);
                    this.initialParams[2] = Math.min(0.0, -xMin - 0.1 * (xMax - xMin) - 1.0E-100);
                    break;
                }
                case 7: {
                    this.initialParams[0] = firsty;
                    this.initialParams[1] = 1.0;
                    this.initialParams[2] = xMin < 0.0 ? xMin : xMax;
                    this.initialParams[3] = lasty;
                    break;
                }
                case 10: 
                case 14: {
                    this.initialParams[0] = xMin - 0.1 * (xMax - xMin);
                    this.initialParams[1] = 1.0;
                    this.initialParams[2] = yMax;
                    this.initialParams[3] = xMax + (xMax - xMin);
                    break;
                }
                case 8: {
                    this.initialParams[0] = xMin;
                    double cd = xOfMax - xMin;
                    if (cd < 0.1 * (xMax - xMin)) {
                        cd = 0.1 * (xMax - xMin);
                    }
                    this.initialParams[2] = Math.sqrt(cd);
                    this.initialParams[3] = Math.sqrt(cd);
                    this.initialParams[1] = yMax / (Math.pow(cd, this.initialParams[2]) * Math.exp(-cd / this.initialParams[3]));
                    break;
                }
                case 12: {
                    this.initialParams[0] = yMin;
                    this.initialParams[1] = yMax;
                    this.initialParams[2] = xOfMax;
                    this.initialParams[3] = 0.39894 * (xMax - xMin) * (yMean - yMin) / (yMax - yMin + 1.0E-100);
                    break;
                }
                case 21: {
                    this.initialParams[0] = yMax;
                    this.initialParams[1] = xOfMax;
                    this.initialParams[2] = 0.39894 * (xMax - xMin) * yMean / (yMax + 1.0E-100);
                }
            }
        }
        if (!hasInitialParamVariations) {
            int i2 = 0;
            while (i2 < this.numParams) {
                this.initialParamVariations[i2] = 0.1 * this.initialParams[i2];
                ++i2;
            }
            switch (fitType) {
                case 1: 
                case 2: 
                case 3: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    double xFactor = 0.5 * Math.max(Math.abs(xMax + xMin), xMax - xMin);
                    this.initialParamVariations[this.numParams - 1] = (yMax - yMin) / (Math.pow(0.5 * (xMax - xMin), this.numParams - 1) + 1.0E-100);
                    int i3 = this.numParams - 2;
                    while (i3 >= 0) {
                        this.initialParamVariations[i3] = this.initialParamVariations[i3 + 1] * xFactor;
                        --i3;
                    }
                    break;
                }
                case 4: 
                case 11: 
                case 13: {
                    this.initialParamVariations[1] = 0.1 / (xMax - xMin + 1.0E-100);
                    break;
                }
                case 7: {
                    this.initialParamVariations[2] = 0.5 * Math.max(xMax - xMin, Math.abs(xMean));
                    this.initialParamVariations[3] = 0.5 * Math.max(yMax - yMin, Math.abs(yMax));
                    break;
                }
                case 14: {
                    this.initialParamVariations[0] = 0.01 * Math.max(xMax - xMin, Math.abs(xMax));
                    this.initialParamVariations[2] = 0.1 * Math.max(yMax - yMin, Math.abs(yMax));
                    this.initialParamVariations[3] = 0.1 * Math.max(xMax - xMin, Math.abs(xMean));
                    break;
                }
                case 8: {
                    this.initialParamVariations[0] = 0.1 * Math.max(yMax - yMin, Math.abs(yMax));
                    double ab = xOfMax - firstx + 0.1 * (xMax - xMin);
                    this.initialParamVariations[2] = 0.1 * Math.sqrt(ab);
                    this.initialParamVariations[3] = 0.1 * Math.sqrt(ab);
                    break;
                }
                case 12: {
                    this.initialParamVariations[2] = 0.2 * this.initialParams[3];
                    break;
                }
                case 21: {
                    this.initialParamVariations[1] = 0.2 * this.initialParams[2];
                }
            }
        }
        return true;
    }

    private void getOffsetAndFactorParams() {
        this.offsetParam = -1;
        this.factorParam = -1;
        this.hasSlopeParam = false;
        switch (this.fitType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.offsetParam = 0;
                this.factorParam = 1;
                this.hasSlopeParam = true;
                break;
            }
            case 4: {
                this.factorParam = 0;
                break;
            }
            case 11: 
            case 13: {
                this.offsetParam = 2;
                this.factorParam = 0;
                break;
            }
            case 5: {
                this.factorParam = 0;
                break;
            }
            case 6: {
                this.factorParam = 0;
                break;
            }
            case 9: {
                this.offsetParam = 0;
                this.factorParam = 1;
                break;
            }
            case 102: {
                this.offsetParam = 3;
                this.factorParam = 0;
                break;
            }
            case 14: {
                this.factorParam = 2;
                break;
            }
            case 8: {
                this.factorParam = 1;
                break;
            }
            case 101: {
                this.offsetParam = 0;
                this.factorParam = 1;
                break;
            }
            case 21: {
                this.factorParam = 0;
            }
        }
        this.numRegressionParams = 0;
        if (this.offsetParam >= 0) {
            ++this.numRegressionParams;
        }
        if (this.factorParam >= 0) {
            ++this.numRegressionParams;
        }
    }

    private void calculateSumYandY2() {
        this.sumY = 0.0;
        this.sumY2 = 0.0;
        int i = 0;
        while (i < this.numPoints) {
            double y = this.yData[i];
            this.sumY += y;
            this.sumY2 += y * y;
            ++i;
        }
    }

    private boolean isModifiedFitType(int fitType) {
        return fitType == 16 || fitType == 15 || fitType == 10 || fitType == 12;
    }

    /*
     * Unable to fully structure code
     */
    private boolean prepareModifiedFitType(int fitType) {
        block14: {
            block13: {
                if (fitType == 12) {
                    this.fitType = 101;
                    return true;
                }
                if (fitType == 7) {
                    this.fitType = 102;
                    return true;
                }
                if (fitType != 16 && fitType != 15) break block13;
                if (fitType == 16) {
                    this.xDataSave = this.xData;
                    this.xData = new double[this.numPoints];
                }
                this.yDataSave = this.yData;
                this.yData = new double[this.numPoints];
                this.ySign = 0.0;
                this.numPoints = 0;
                i = 0;
                while (i < this.xData.length) {
                    y = this.yDataSave[i];
                    if (fitType != 16) ** GOTO lbl27
                    x = this.xDataSave[i];
                    if (x == 0.0 && y == 0.0) {
                        this.restrictPower = true;
                    } else {
                        if (x <= 0.0) {
                            this.errorString = "Cannot fit x<=0";
                            return false;
                        }
                        this.xData[this.numPoints] = Math.log(x);
lbl27:
                        // 2 sources

                        useY = 0.0;
                        if (y > 0.0) {
                            useY = 1.0;
                        } else if (y < 0.0) {
                            useY = -1.0;
                        }
                        if (this.ySign == 0.0) {
                            this.ySign = useY;
                        }
                        if (y * this.ySign <= 0.0) {
                            this.errorString = "Cannot fit y=0 or mixture of y>0, y<0";
                            return false;
                        }
                        this.yData[this.numPoints] = Math.log(y * this.ySign);
                        ++this.numPoints;
                    }
                    ++i;
                }
                this.fitType = 0;
                break block14;
            }
            if (fitType == 10) {
                this.xDataSave = this.xData;
                this.yDataSave = this.yData;
                this.xData = this.yDataSave;
                this.yData = this.xDataSave;
                this.fitType = 102;
            }
        }
        return true;
    }

    private void postProcessModifiedFitType(int fitType) {
        if (fitType == 16 || fitType == 15) {
            this.finalParams[0] = this.ySign * Math.exp(this.finalParams[0]);
        }
        if (fitType == 12) {
            this.finalParams[1] = this.finalParams[1] + this.finalParams[0];
        } else if (fitType == 7 || fitType == 10) {
            this.finalParams[0] = this.finalParams[0] + this.finalParams[3];
        }
        if (this.xDataSave != null) {
            this.xData = this.xDataSave;
            this.numPoints = this.xData.length;
        }
        if (this.yDataSave != null) {
            this.yData = this.yDataSave;
        }
        this.fitType = fitType;
    }

    private final double sqr(double d) {
        return d * d;
    }

    private void settingsDialog() {
        GenericDialog gd = new GenericDialog("Simplex Fitting Options");
        gd.addMessage("Function name: " + this.getName() + "\n" + "Formula: " + this.getFormula());
        int pChar = 97;
        int i = 0;
        while (i < this.numParams) {
            gd.addNumericField("Initial_" + (char)(pChar + i) + ":", this.initialParams[i], 2);
            ++i;
        }
        gd.addNumericField("Maximum iterations:", this.minimizer.getMaxIterations(), 0);
        gd.addNumericField("Number of restarts:", this.minimizer.getMaxRestarts(), 0);
        gd.addNumericField("Error tolerance [1*10^(-x)]:", -(Math.log(this.maxRelError) / Math.log(10.0)), 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        i = 0;
        while (i < this.numParams) {
            double p = gd.getNextNumber();
            if (!Double.isNaN(p)) {
                this.initialParams[i] = p;
                this.initialParamVariations[i] = Math.max(0.01 * p, 0.001 * this.initialParamVariations[i]);
            }
            ++i;
        }
        double n = gd.getNextNumber();
        if (n > 0.0) {
            this.minimizer.setMaxIterations((int)n);
        }
        if ((n = gd.getNextNumber()) >= 0.0) {
            this.minimizer.setMaxRestarts((int)n);
        }
        n = gd.getNextNumber();
        this.setMaxError(Math.pow(10.0, -n));
    }

    public static int getMax(double[] array) {
        double max = array[0];
        int index = 0;
        int i = 1;
        while (i < array.length) {
            if (max < array[i]) {
                max = array[i];
                index = i;
            }
            ++i;
        }
        return index;
    }
}

