/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.BitBuffer;
import ij.io.ByteVector;
import ij.io.FileInfo;
import ij.io.RandomAccessStream;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;

public class ImageReader {
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private FileInfo fi;
    private int width;
    private int height;
    private long skipCount;
    private int bytesPerPixel;
    private int bufferSize;
    private int nPixels;
    private long byteCount;
    private boolean showProgressBar = true;
    private int eofErrorCount;
    private long startTime;
    public double min;
    public double max;

    public ImageReader(FileInfo fi) {
        this.fi = fi;
        this.width = fi.width;
        this.height = fi.height;
        this.skipCount = fi.getOffset();
    }

    void eofError() {
        ++this.eofErrorCount;
    }

    byte[] read8bitImage(InputStream in) throws IOException {
        if (this.fi.compression > 1) {
            return this.readCompressed8bitImage(in);
        }
        byte[] pixels = new byte[this.nPixels];
        int totalRead = 0;
        while ((long)totalRead < this.byteCount) {
            int count = (long)(totalRead + this.bufferSize) > this.byteCount ? (int)(this.byteCount - (long)totalRead) : this.bufferSize;
            int actuallyRead = in.read(pixels, totalRead, count);
            if (actuallyRead == -1) {
                this.eofError();
                break;
            }
            this.showProgress((long)(totalRead += actuallyRead), this.byteCount);
        }
        return pixels;
    }

    byte[] readCompressed8bitImage(InputStream in) throws IOException {
        byte[] pixels = new byte[this.nPixels];
        int current = 0;
        byte last = 0;
        int i = 0;
        while (i < this.fi.stripOffsets.length) {
            long skip;
            if (in instanceof RandomAccessStream) {
                ((RandomAccessStream)in).seek(this.fi.stripOffsets[i]);
            } else if (i > 0 && (skip = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[i]];
            int read = 0;
            int left = byteArray.length;
            while (left > 0) {
                int r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
                left -= r;
            }
            byteArray = this.uncompress(byteArray);
            int length = byteArray.length;
            length -= length % this.fi.width;
            if (this.fi.compression == 3) {
                int b = 0;
                while (b < length) {
                    int n = b;
                    byteArray[n] = (byte)(byteArray[n] + last);
                    last = b % this.fi.width == this.fi.width - 1 ? (byte)0 : byteArray[b];
                    ++b;
                }
            }
            if (current + length > pixels.length) {
                length = pixels.length - current;
            }
            System.arraycopy(byteArray, 0, pixels, current, length);
            current += length;
            this.showProgress(i + 1, this.fi.stripOffsets.length);
            ++i;
        }
        return pixels;
    }

    short[] read16bitImage(InputStream in) throws IOException {
        if (this.fi.compression > 1 || this.fi.stripOffsets != null && this.fi.stripOffsets.length > 1) {
            return this.readCompressed16bitImage(in);
        }
        byte[] buffer = new byte[this.bufferSize];
        short[] pixels = new short[this.nPixels];
        long totalRead = 0L;
        int base = 0;
        while (totalRead < this.byteCount) {
            int j;
            int i;
            if (totalRead + (long)this.bufferSize > this.byteCount) {
                this.bufferSize = (int)(this.byteCount - totalRead);
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    if (bufferCount > 0) {
                        i = bufferCount;
                        while (i < this.bufferSize) {
                            buffer[i] = 0;
                            ++i;
                        }
                    }
                    totalRead = this.byteCount;
                    this.eofError();
                    break;
                }
                bufferCount += count;
            }
            this.showProgress(totalRead += (long)this.bufferSize, this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            if (this.fi.intelByteOrder) {
                if (this.fi.fileType == 1) {
                    i = base;
                    j = 0;
                    while (i < base + pixelsRead) {
                        pixels[i] = (short)(((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF) + 32768);
                        ++i;
                        j += 2;
                    }
                } else {
                    i = base;
                    j = 0;
                    while (i < base + pixelsRead) {
                        pixels[i] = (short)((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                        ++i;
                        j += 2;
                    }
                }
            } else if (this.fi.fileType == 1) {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    pixels[i] = (short)(((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF) + 32768);
                    ++i;
                    j += 2;
                }
            } else {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    pixels[i] = (short)((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    ++i;
                    j += 2;
                }
            }
            base += pixelsRead;
        }
        return pixels;
    }

    short[] readCompressed16bitImage(InputStream in) throws IOException {
        short[] pixels = new short[this.nPixels];
        int base = 0;
        short last = 0;
        int k = 0;
        while (k < this.fi.stripOffsets.length) {
            int j;
            int i;
            long skip;
            if (in instanceof RandomAccessStream) {
                ((RandomAccessStream)in).seek(this.fi.stripOffsets[k]);
            } else if (k > 0 && (skip = ((long)this.fi.stripOffsets[k] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[k - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[k - 1]) > 0L) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[k]];
            int read = 0;
            int left = byteArray.length;
            while (left > 0) {
                int r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
                left -= r;
            }
            byteArray = this.uncompress(byteArray);
            int pixelsRead = byteArray.length / this.bytesPerPixel;
            pixelsRead -= pixelsRead % this.fi.width;
            int pmax = base + pixelsRead;
            if (pmax > this.nPixels) {
                pmax = this.nPixels;
            }
            if (this.fi.intelByteOrder) {
                i = base;
                j = 0;
                while (i < pmax) {
                    pixels[i] = (short)((byteArray[j + 1] & 0xFF) << 8 | byteArray[j] & 0xFF);
                    ++i;
                    j += 2;
                }
            } else {
                i = base;
                j = 0;
                while (i < pmax) {
                    pixels[i] = (short)((byteArray[j] & 0xFF) << 8 | byteArray[j + 1] & 0xFF);
                    ++i;
                    j += 2;
                }
            }
            if (this.fi.compression == 3) {
                int b = base;
                while (b < pmax) {
                    int n = b;
                    pixels[n] = (short)(pixels[n] + last);
                    last = b % this.fi.width == this.fi.width - 1 ? (short)0 : pixels[b];
                    ++b;
                }
            }
            base += pixelsRead;
            this.showProgress(k + 1, this.fi.stripOffsets.length);
            ++k;
        }
        if (this.fi.fileType == 1) {
            int i = 0;
            while (i < this.nPixels) {
                pixels[i] = (short)(pixels[i] + 32768);
                ++i;
            }
        }
        return pixels;
    }

    float[] read32bitImage(InputStream in) throws IOException {
        if (this.fi.compression > 1) {
            return this.readCompressed32bitImage(in);
        }
        byte[] buffer = new byte[this.bufferSize];
        float[] pixels = new float[this.nPixels];
        long totalRead = 0L;
        int base = 0;
        while (totalRead < this.byteCount) {
            int tmp;
            int i;
            if (totalRead + (long)this.bufferSize > this.byteCount) {
                this.bufferSize = (int)(this.byteCount - totalRead);
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    if (bufferCount > 0) {
                        int i2 = bufferCount;
                        while (i2 < this.bufferSize) {
                            buffer[i2] = 0;
                            ++i2;
                        }
                    }
                    totalRead = this.byteCount;
                    this.eofError();
                    break;
                }
                bufferCount += count;
            }
            this.showProgress(totalRead += (long)this.bufferSize, this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            int pmax = base + pixelsRead;
            if (pmax > this.nPixels) {
                pmax = this.nPixels;
            }
            int j = 0;
            if (this.fi.intelByteOrder) {
                i = base;
                while (i < pmax) {
                    tmp = (buffer[j + 3] & 0xFF) << 24 | (buffer[j + 2] & 0xFF) << 16 | (buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (this.fi.fileType == 11 ? (float)((long)tmp & 0xFFFFFFFFL) : (float)tmp);
                    j += 4;
                    ++i;
                }
            } else {
                i = base;
                while (i < pmax) {
                    tmp = (buffer[j] & 0xFF) << 24 | (buffer[j + 1] & 0xFF) << 16 | (buffer[j + 2] & 0xFF) << 8 | buffer[j + 3] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (this.fi.fileType == 11 ? (float)((long)tmp & 0xFFFFFFFFL) : (float)tmp);
                    j += 4;
                    ++i;
                }
            }
            base += pixelsRead;
        }
        return pixels;
    }

    float[] readCompressed32bitImage(InputStream in) throws IOException {
        float[] pixels = new float[this.nPixels];
        int base = 0;
        float last = 0.0f;
        int k = 0;
        while (k < this.fi.stripOffsets.length) {
            int tmp;
            int j;
            int i;
            long skip;
            if (in instanceof RandomAccessStream) {
                ((RandomAccessStream)in).seek(this.fi.stripOffsets[k]);
            } else if (k > 0 && (skip = ((long)this.fi.stripOffsets[k] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[k - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[k - 1]) > 0L) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[k]];
            int read = 0;
            int left = byteArray.length;
            while (left > 0) {
                int r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
                left -= r;
            }
            byteArray = this.uncompress(byteArray);
            int pixelsRead = byteArray.length / this.bytesPerPixel;
            pixelsRead -= pixelsRead % this.fi.width;
            int pmax = base + pixelsRead;
            if (pmax > this.nPixels) {
                pmax = this.nPixels;
            }
            if (this.fi.intelByteOrder) {
                i = base;
                j = 0;
                while (i < pmax) {
                    tmp = (byteArray[j + 3] & 0xFF) << 24 | (byteArray[j + 2] & 0xFF) << 16 | (byteArray[j + 1] & 0xFF) << 8 | byteArray[j] & 0xFF;
                    pixels[i] = Float.intBitsToFloat(tmp);
                    ++i;
                    j += 4;
                }
            } else {
                i = base;
                j = 0;
                while (i < pmax) {
                    tmp = (byteArray[j] & 0xFF) << 24 | (byteArray[j + 1] & 0xFF) << 16 | (byteArray[j + 2] & 0xFF) << 8 | byteArray[j + 3] & 0xFF;
                    pixels[i] = Float.intBitsToFloat(tmp);
                    ++i;
                    j += 4;
                }
            }
            if (this.fi.compression == 3) {
                int b = base;
                while (b < pmax) {
                    int n = b;
                    pixels[n] = pixels[n] + last;
                    last = b % this.fi.width == this.fi.width - 1 ? 0.0f : pixels[b];
                    ++b;
                }
            }
            base += pixelsRead;
            this.showProgress(k + 1, this.fi.stripOffsets.length);
            ++k;
        }
        return pixels;
    }

    float[] read64bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        float[] pixels = new float[this.nPixels];
        long totalRead = 0L;
        int base = 0;
        while (totalRead < this.byteCount) {
            if (totalRead + (long)this.bufferSize > this.byteCount) {
                this.bufferSize = (int)(this.byteCount - totalRead);
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    if (bufferCount > 0) {
                        int i = bufferCount;
                        while (i < this.bufferSize) {
                            buffer[i] = 0;
                            ++i;
                        }
                    }
                    totalRead = this.byteCount;
                    this.eofError();
                    break;
                }
                bufferCount += count;
            }
            this.showProgress(totalRead += (long)this.bufferSize, this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            int j = 0;
            int i = base;
            while (i < base + pixelsRead) {
                long b1 = buffer[j + 7] & 0xFF;
                long b2 = buffer[j + 6] & 0xFF;
                long b3 = buffer[j + 5] & 0xFF;
                long b4 = buffer[j + 4] & 0xFF;
                long b5 = buffer[j + 3] & 0xFF;
                long b6 = buffer[j + 2] & 0xFF;
                long b7 = buffer[j + 1] & 0xFF;
                long b8 = buffer[j] & 0xFF;
                long tmp = this.fi.intelByteOrder ? b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8 : b8 << 56 | b7 << 48 | b6 << 40 | b5 << 32 | b4 << 24 | b3 << 16 | b2 << 8 | b1;
                pixels[i] = (float)Double.longBitsToDouble(tmp);
                j += 8;
                ++i;
            }
            base += pixelsRead;
        }
        return pixels;
    }

    int[] readChunkyRGB(InputStream in) throws IOException {
        if (this.fi.compression == 4) {
            return this.readJPEG(in);
        }
        if (this.fi.compression > 1) {
            return this.readCompressedChunkyRGB(in);
        }
        this.bufferSize = 24 * this.width;
        byte[] buffer = new byte[this.bufferSize];
        int[] pixels = new int[this.nPixels];
        long totalRead = 0L;
        int base = 0;
        while (totalRead < this.byteCount) {
            if (totalRead + (long)this.bufferSize > this.byteCount) {
                this.bufferSize = (int)(this.byteCount - totalRead);
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    if (bufferCount > 0) {
                        int i = bufferCount;
                        while (i < this.bufferSize) {
                            buffer[i] = 0;
                            ++i;
                        }
                    }
                    totalRead = this.byteCount;
                    this.eofError();
                    break;
                }
                bufferCount += count;
            }
            this.showProgress(totalRead += (long)this.bufferSize, this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            boolean bgr = this.fi.fileType == 10;
            int j = 0;
            int i = base;
            while (i < base + pixelsRead) {
                int g;
                int r;
                int b;
                if (this.bytesPerPixel == 4) {
                    if (this.fi.fileType == 15) {
                        b = buffer[j++] & 0xFF;
                        int n = ++j;
                        r = buffer[n] & 0xFF;
                        int n2 = ++j;
                        ++j;
                        g = buffer[n2] & 0xFF;
                    } else if (this.fi.fileType == 18) {
                        b = buffer[j++] & 0xFF;
                        g = buffer[j++] & 0xFF;
                        r = buffer[j++] & 0xFF;
                        ++j;
                    } else if (this.fi.fileType == 19) {
                        int a;
                        r = buffer[j++] & 0xFF;
                        g = buffer[j++] & 0xFF;
                        b = buffer[j++] & 0xFF;
                        if ((a = buffer[j++] & 0xFF) > 0) {
                            r = (r * (256 - a) >> 8) + a;
                            g = (g * (256 - a) >> 8) + a;
                            b = (b * (256 - a) >> 8) + a;
                        }
                    } else {
                        r = buffer[j++] & 0xFF;
                        g = buffer[j++] & 0xFF;
                        b = buffer[j++] & 0xFF;
                        ++j;
                    }
                } else {
                    r = buffer[j++] & 0xFF;
                    g = buffer[j++] & 0xFF;
                    b = buffer[j++] & 0xFF;
                }
                pixels[i] = bgr ? 0xFF000000 | b << 16 | g << 8 | r : 0xFF000000 | r << 16 | g << 8 | b;
                ++i;
            }
            base += pixelsRead;
        }
        return pixels;
    }

    int[] readCompressedChunkyRGB(InputStream in) throws IOException {
        int[] pixels = new int[this.nPixels];
        int base = 0;
        boolean lastRed = false;
        boolean lastGreen = false;
        boolean lastBlue = false;
        int red = 0;
        int green = 0;
        int blue = 0;
        int alpha = 0;
        boolean bgr = this.fi.fileType == 10;
        boolean cmyk = this.fi.fileType == 19;
        boolean differencing = this.fi.compression == 3;
        int i = 0;
        while (i < this.fi.stripOffsets.length) {
            int pmax;
            long skip;
            if (i > 0 && (skip = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[i]];
            int read = 0;
            int left = byteArray.length;
            while (left > 0) {
                int r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
                left -= r;
            }
            byteArray = this.uncompress(byteArray);
            if (differencing) {
                int b = 0;
                while (b < byteArray.length) {
                    if (b / this.bytesPerPixel % this.fi.width != 0) {
                        int n = b;
                        byteArray[n] = (byte)(byteArray[n] + byteArray[b - this.bytesPerPixel]);
                    }
                    ++b;
                }
            }
            int k = 0;
            int pixelsRead = byteArray.length / this.bytesPerPixel;
            if ((pmax = base + (pixelsRead -= pixelsRead % this.fi.width)) > this.nPixels) {
                pmax = this.nPixels;
            }
            int j = base;
            while (j < pmax) {
                if (this.bytesPerPixel == 4) {
                    red = byteArray[k++] & 0xFF;
                    green = byteArray[k++] & 0xFF;
                    blue = byteArray[k++] & 0xFF;
                    alpha = byteArray[k++] & 0xFF;
                    if (cmyk && alpha > 0) {
                        red = (red * (256 - alpha) >> 8) + alpha;
                        green = (green * (256 - alpha) >> 8) + alpha;
                        blue = (blue * (256 - alpha) >> 8) + alpha;
                    }
                } else {
                    red = byteArray[k++] & 0xFF;
                    green = byteArray[k++] & 0xFF;
                    blue = byteArray[k++] & 0xFF;
                }
                pixels[j] = bgr ? 0xFF000000 | blue << 16 | green << 8 | red : 0xFF000000 | red << 16 | green << 8 | blue;
                ++j;
            }
            base += pixelsRead;
            this.showProgress(i + 1, this.fi.stripOffsets.length);
            ++i;
        }
        return pixels;
    }

    int[] readJPEG(InputStream in) throws IOException {
        BufferedImage bi = ImageIO.read(in);
        ColorProcessor ip = new ColorProcessor(bi);
        return (int[])((ImageProcessor)ip).getPixels();
    }

    int[] readPlanarRGB(InputStream in) throws IOException {
        if (this.fi.compression > 1) {
            return this.readCompressedPlanarRGBImage(in);
        }
        DataInputStream dis = new DataInputStream(in);
        int planeSize = this.nPixels;
        byte[] buffer = new byte[planeSize];
        int[] pixels = new int[this.nPixels];
        this.startTime = 0L;
        this.showProgress(10, 100);
        dis.readFully(buffer);
        int i = 0;
        while (i < planeSize) {
            int r = buffer[i] & 0xFF;
            pixels[i] = 0xFF000000 | r << 16;
            ++i;
        }
        this.showProgress(40, 100);
        dis.readFully(buffer);
        i = 0;
        while (i < planeSize) {
            int g = buffer[i] & 0xFF;
            int n = i++;
            pixels[n] = pixels[n] | g << 8;
        }
        this.showProgress(70, 100);
        dis.readFully(buffer);
        i = 0;
        while (i < planeSize) {
            int b = buffer[i] & 0xFF;
            int n = i++;
            pixels[n] = pixels[n] | b;
        }
        this.showProgress(90, 100);
        return pixels;
    }

    int[] readCompressedPlanarRGBImage(InputStream in) throws IOException {
        int[] pixels = new int[this.nPixels];
        this.nPixels *= 3;
        byte[] buffer = this.readCompressed8bitImage(in);
        this.nPixels /= 3;
        int i = 0;
        while (i < this.nPixels) {
            int r = buffer[i] & 0xFF;
            pixels[i] = 0xFF000000 | r << 16;
            ++i;
        }
        i = 0;
        while (i < this.nPixels) {
            int g = buffer[this.nPixels + i] & 0xFF;
            int n = i++;
            pixels[n] = pixels[n] | g << 8;
        }
        i = 0;
        while (i < this.nPixels) {
            int b = buffer[this.nPixels * 2 + i] & 0xFF;
            int n = i++;
            pixels[n] = pixels[n] | b;
        }
        return pixels;
    }

    private void showProgress(int current, int last) {
        if (this.showProgressBar && System.currentTimeMillis() - this.startTime > 500L) {
            IJ.showProgress(current, last);
        }
    }

    private void showProgress(long current, long last) {
        this.showProgress((int)(current / 10L), (int)(last / 10L));
    }

    Object readRGB48(InputStream in) throws IOException {
        if (this.fi.compression > 1) {
            return this.readCompressedRGB48(in);
        }
        int channels = 3;
        short[][] stack = new short[channels][this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        int pixel = 0;
        int min = 65535;
        int max = 0;
        if (this.fi.stripLengths == null) {
            this.fi.stripLengths = new int[this.fi.stripOffsets.length];
            this.fi.stripLengths[0] = this.width * this.height * this.bytesPerPixel;
        }
        int i = 0;
        while (i < this.fi.stripOffsets.length) {
            int bytesToGo;
            int len;
            long skip;
            if (i > 0 && (skip = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                dis.skip(skip);
            }
            if ((len = this.fi.stripLengths[i]) > (bytesToGo = (this.nPixels - pixel) * channels * 2)) {
                len = bytesToGo;
            }
            byte[] buffer = new byte[len];
            dis.readFully(buffer);
            int channel = 0;
            boolean intel = this.fi.intelByteOrder;
            int base = 0;
            while (base < len) {
                int value = intel ? (buffer[base + 1] & 0xFF) << 8 | buffer[base] & 0xFF : (buffer[base] & 0xFF) << 8 | buffer[base + 1] & 0xFF;
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
                stack[channel][pixel] = (short)value;
                if (++channel == channels) {
                    channel = 0;
                    ++pixel;
                }
                base += 2;
            }
            this.showProgress(i + 1, this.fi.stripOffsets.length);
            ++i;
        }
        this.min = min;
        this.max = max;
        return stack;
    }

    Object readCompressedRGB48(InputStream in) throws IOException {
        if (this.fi.compression == 3) {
            throw new IOException("ImageJ cannot open 48-bit LZW compressed TIFFs with predictor");
        }
        int channels = 3;
        short[][] stack = new short[channels][this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        int pixel = 0;
        int min = 65535;
        int max = 0;
        int i = 0;
        while (i < this.fi.stripOffsets.length) {
            long skip;
            if (i > 0 && (skip = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                dis.skip(skip);
            }
            int len = this.fi.stripLengths[i];
            byte[] buffer = new byte[len];
            dis.readFully(buffer);
            buffer = this.uncompress(buffer);
            len = buffer.length;
            if (len % 2 != 0) {
                --len;
            }
            int channel = 0;
            boolean intel = this.fi.intelByteOrder;
            int base = 0;
            while (base < len && pixel < this.nPixels) {
                int value = intel ? (buffer[base + 1] & 0xFF) << 8 | buffer[base] & 0xFF : (buffer[base] & 0xFF) << 8 | buffer[base + 1] & 0xFF;
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
                stack[channel][pixel] = (short)value;
                if (++channel == channels) {
                    channel = 0;
                    ++pixel;
                }
                base += 2;
            }
            this.showProgress(i + 1, this.fi.stripOffsets.length);
            ++i;
        }
        this.min = min;
        this.max = max;
        return stack;
    }

    Object readRGB48Planar(InputStream in) throws IOException {
        short[] red = this.read16bitImage(in);
        short[] green = this.read16bitImage(in);
        short[] blue = this.read16bitImage(in);
        Object[] stack = new Object[]{red, green, blue};
        return stack;
    }

    short[] read12bitImage(InputStream in) throws IOException {
        int bytesPerLine = (int)((double)this.width * 1.5);
        if ((this.width & 1) == 1) {
            ++bytesPerLine;
        }
        byte[] buffer = new byte[bytesPerLine * this.height];
        short[] pixels = new short[this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        dis.readFully(buffer);
        int y = 0;
        while (y < this.height) {
            int index1 = y * bytesPerLine;
            int index2 = y * this.width;
            int count = 0;
            while (count < this.width) {
                pixels[index2 + count] = (short)((buffer[index1] & 0xFF) * 16 + (buffer[index1 + 1] >> 4 & 0xF));
                if (++count == this.width) break;
                pixels[index2 + count] = (short)((buffer[index1 + 1] & 0xF) * 256 + (buffer[index1 + 2] & 0xFF));
                ++count;
                index1 += 3;
            }
            ++y;
        }
        return pixels;
    }

    float[] read24bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.width * 3];
        float[] pixels = new float[this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        int y = 0;
        while (y < this.height) {
            dis.readFully(buffer);
            int b = 0;
            int x = 0;
            while (x < this.width) {
                int b1 = buffer[b++] & 0xFF;
                int b2 = buffer[b++] & 0xFF;
                int b3 = buffer[b++] & 0xFF;
                pixels[x + y * this.width] = b3 << 16 | b2 << 8 | b1;
                ++x;
            }
            ++y;
        }
        return pixels;
    }

    byte[] read1bitImage(InputStream in) throws IOException {
        if (this.fi.compression == 2) {
            throw new IOException("ImageJ cannot open 1-bit LZW compressed TIFFs");
        }
        int scan = (int)Math.ceil((double)this.width / 8.0);
        int len = scan * this.height;
        byte[] buffer = new byte[len];
        byte[] pixels = new byte[this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        dis.readFully(buffer);
        int y = 0;
        while (y < this.height) {
            int offset = y * scan;
            int index = y * this.width;
            int x = 0;
            while (x < scan) {
                int value1 = buffer[offset + x] & 0xFF;
                int i = 7;
                while (i >= 0) {
                    int value2;
                    int n = value2 = (value1 & 1 << i) != 0 ? 255 : 0;
                    if (index < pixels.length) {
                        pixels[index++] = (byte)value2;
                    }
                    --i;
                }
                ++x;
            }
            ++y;
        }
        return pixels;
    }

    void skip(InputStream in) throws IOException {
        if (this.skipCount > 0L) {
            long bytesRead = 0L;
            int skipAttempts = 0;
            while (bytesRead < this.skipCount) {
                long count = in.skip(this.skipCount - bytesRead);
                if (count == -1L || ++skipAttempts > 5) break;
                bytesRead += count;
            }
        }
        this.byteCount = (long)this.width * (long)this.height * (long)this.bytesPerPixel;
        if (this.fi.fileType == 8) {
            int scan = this.width / 8;
            int pad = this.width % 8;
            if (pad > 0) {
                ++scan;
            }
            this.byteCount = scan * this.height;
        }
        this.nPixels = this.width * this.height;
        this.bufferSize = (int)(this.byteCount / 25L);
        this.bufferSize = this.bufferSize < 8192 ? 8192 : this.bufferSize / 8192 * 8192;
    }

    public Object readPixels(InputStream in) {
        this.startTime = System.currentTimeMillis();
        try {
            Object pixels;
            switch (this.fi.fileType) {
                case 0: 
                case 5: {
                    this.bytesPerPixel = 1;
                    this.skip(in);
                    pixels = this.read8bitImage(in);
                    break;
                }
                case 1: 
                case 2: {
                    this.bytesPerPixel = 2;
                    this.skip(in);
                    pixels = this.read16bitImage(in);
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    this.bytesPerPixel = 4;
                    this.skip(in);
                    pixels = this.read32bitImage(in);
                    break;
                }
                case 16: {
                    this.bytesPerPixel = 8;
                    this.skip(in);
                    pixels = this.read64bitImage(in);
                    break;
                }
                case 6: 
                case 9: 
                case 10: 
                case 15: 
                case 18: 
                case 19: {
                    this.bytesPerPixel = this.fi.getBytesPerPixel();
                    this.skip(in);
                    pixels = this.readChunkyRGB(in);
                    break;
                }
                case 7: {
                    this.bytesPerPixel = 3;
                    this.skip(in);
                    pixels = this.readPlanarRGB(in);
                    break;
                }
                case 8: {
                    this.bytesPerPixel = 1;
                    this.skip(in);
                    pixels = this.read1bitImage(in);
                    break;
                }
                case 12: {
                    this.bytesPerPixel = 6;
                    this.skip(in);
                    pixels = this.readRGB48(in);
                    break;
                }
                case 17: {
                    this.bytesPerPixel = 2;
                    this.skip(in);
                    pixels = this.readRGB48Planar(in);
                    break;
                }
                case 13: {
                    this.skip(in);
                    short[] data = this.read12bitImage(in);
                    pixels = data;
                    break;
                }
                case 14: {
                    this.skip(in);
                    pixels = this.read24bitImage(in);
                    break;
                }
                default: {
                    pixels = null;
                }
            }
            this.showProgress(1, 1);
            return pixels;
        }
        catch (IOException e) {
            IJ.log("" + e);
            return null;
        }
    }

    public Object readPixels(InputStream in, long skipCount) {
        this.skipCount = skipCount;
        this.showProgressBar = false;
        Object pixels = this.readPixels(in);
        if (this.eofErrorCount > 0) {
            return null;
        }
        return pixels;
    }

    public Object readPixels(String url) {
        InputStream is;
        URL theURL;
        try {
            theURL = new URL(url);
        }
        catch (MalformedURLException e) {
            IJ.log("" + e);
            return null;
        }
        try {
            is = theURL.openStream();
        }
        catch (IOException e) {
            IJ.log("" + e);
            return null;
        }
        return this.readPixels(is);
    }

    byte[] uncompress(byte[] input) {
        if (this.fi.compression == 5) {
            return this.packBitsUncompress(input, this.fi.rowsPerStrip * this.fi.width * this.fi.getBytesPerPixel());
        }
        if (this.fi.compression == 2 || this.fi.compression == 3) {
            return this.lzwUncompress(input);
        }
        if (this.fi.compression == 6) {
            return this.zipUncompress(input);
        }
        return input;
    }

    public byte[] zipUncompress(byte[] input) {
        ByteArrayOutputStream imageBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        Inflater decompressor = new Inflater();
        decompressor.setInput(input);
        try {
            while (!decompressor.finished()) {
                int rlen = decompressor.inflate(buffer);
                imageBuffer.write(buffer, 0, rlen);
            }
        }
        catch (DataFormatException e) {
            IJ.log(e.toString());
        }
        decompressor.end();
        return imageBuffer.toByteArray();
    }

    public byte[] lzwUncompress(byte[] input) {
        if (input == null || input.length == 0) {
            return input;
        }
        byte[][] symbolTable = new byte[4096][1];
        int bitsToRead = 9;
        int nextSymbol = 258;
        int oldCode = -1;
        ByteVector out = new ByteVector(8192);
        BitBuffer bb = new BitBuffer(input);
        byte[] byteBuffer1 = new byte[16];
        byte[] byteBuffer2 = new byte[16];
        while ((long)out.size() < this.byteCount) {
            ByteVector symbol;
            int code = bb.getBits(bitsToRead);
            if (code == 257 || code == -1) break;
            if (code == 256) {
                int i = 0;
                while (i < 256) {
                    symbolTable[i][0] = (byte)i;
                    ++i;
                }
                nextSymbol = 258;
                bitsToRead = 9;
                code = bb.getBits(bitsToRead);
                if (code == 257 || code == -1) break;
                out.add(symbolTable[code]);
                oldCode = code;
                continue;
            }
            if (code < nextSymbol) {
                out.add(symbolTable[code]);
                symbol = new ByteVector(byteBuffer1);
                symbol.add(symbolTable[oldCode]);
                symbol.add(symbolTable[code][0]);
                symbolTable[nextSymbol] = symbol.toByteArray();
                oldCode = code;
                ++nextSymbol;
            } else {
                symbol = new ByteVector(byteBuffer2);
                symbol.add(symbolTable[oldCode]);
                symbol.add(symbolTable[oldCode][0]);
                byte[] outString = symbol.toByteArray();
                out.add(outString);
                symbolTable[nextSymbol] = outString;
                oldCode = code;
                ++nextSymbol;
            }
            if (nextSymbol == 511) {
                bitsToRead = 10;
            }
            if (nextSymbol == 1023) {
                bitsToRead = 11;
            }
            if (nextSymbol != 2047) continue;
            bitsToRead = 12;
        }
        return out.toByteArray();
    }

    public byte[] packBitsUncompress(byte[] input, int expected) {
        if (expected == 0) {
            expected = Integer.MAX_VALUE;
        }
        ByteVector output = new ByteVector(1024);
        int index = 0;
        while (output.size() < expected && index < input.length) {
            byte n;
            if ((n = input[index++]) >= 0) {
                byte[] b = new byte[n + 1];
                int i = 0;
                while (i < n + 1) {
                    b[i] = input[index++];
                    ++i;
                }
                output.add(b);
                b = null;
                continue;
            }
            if (n == -128) continue;
            int len = -n + 1;
            byte inp = input[index++];
            int i = 0;
            while (i < len) {
                output.add(inp);
                ++i;
            }
        }
        return output.toByteArray();
    }
}

