/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.ImageCanvas;
import ij.gui.ScrollbarWithLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Scrollbar;

public class ImageLayout
implements LayoutManager {
    int hgap;
    int vgap;
    ImageCanvas ic;

    public ImageLayout(ImageCanvas ic) {
        this.ic = ic;
        this.hgap = 5;
        this.vgap = 5;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            Dimension d = m.getPreferredSize();
            dim.width = Math.max(dim.width, d.width);
            if (i > 0) {
                dim.height += this.vgap;
            }
            dim.height += d.height;
            ++i;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int nmembers) {
        int x2 = 0;
        y += height / 2;
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            Dimension d = m.getSize();
            if (i == 0 || d.height > 60) {
                x2 = x + (width - d.width) / 2;
            }
            m.setLocation(x2, y);
            y += this.vgap + d.height;
            ++i;
        }
    }

    public void layoutContainer(Container target) {
        Dimension d;
        Insets insets = target.getInsets();
        int nmembers = target.getComponentCount();
        int extraHeight = 0;
        int i = 1;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            d = m.getPreferredSize();
            extraHeight += d.height;
            ++i;
        }
        d = target.getSize();
        int preferredImageWidth = d.width - (insets.left + insets.right + this.hgap * 2);
        int preferredImageHeight = d.height - (insets.top + insets.bottom + this.vgap * 2 + extraHeight);
        this.ic.resizeCanvas(preferredImageWidth, preferredImageHeight);
        int maxwidth = d.width - (insets.left + insets.right + this.hgap * 2);
        int maxheight = d.height - (insets.top + insets.bottom + this.vgap * 2);
        Dimension psize = this.preferredLayoutSize(target);
        int x = insets.left + this.hgap + (d.width - psize.width) / 2;
        int y = 0;
        int colw = 0;
        int i2 = 0;
        while (i2 < nmembers) {
            Component m = target.getComponent(i2);
            d = m.getPreferredSize();
            if (m instanceof ScrollbarWithLabel || m instanceof Scrollbar) {
                int scrollbarWidth = target.getComponent((int)0).getPreferredSize().width;
                Dimension minSize = m.getMinimumSize();
                if (scrollbarWidth < minSize.width) {
                    scrollbarWidth = minSize.width;
                }
                m.setSize(scrollbarWidth, d.height);
            } else {
                m.setSize(d.width, d.height);
            }
            if (y > 0) {
                y += this.vgap;
            }
            y += d.height;
            colw = Math.max(colw, d.width);
            ++i2;
        }
        this.moveComponents(target, x, insets.top + this.vgap, colw, maxheight - y, nmembers);
    }
}

