/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.table;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.table.SortableTableData;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class TinyTableHeaderRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private static final Icon arrowNo = new Arrow(true, -1);
    private static final Icon[][] arrows = new Icon[2][4];
    private int[] horizontalAlignments;

    public TinyTableHeaderRenderer() {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(2);
    }

    public void setHorizontalAlignments(int[] alignments) {
        this.horizontalAlignments = alignments;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf == null || !"TinyLookAndFeel".equals(laf.getName())) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setBackground(header.getBackground());
                this.setForeground(header.getForeground());
                this.setFont(header.getFont());
            }
            this.setIcon(null);
            this.setText(value == null ? "" : value.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
        boolean isRolloverColumn = false;
        Icon icon = arrowNo;
        int sortingDirection = 1;
        int priority = -1;
        boolean paintArrow = false;
        if (table != null) {
            TableModel model;
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                int rolloverColumn;
                Object o = header.getClientProperty("rolloverColumn");
                if (o != null && (rolloverColumn = ((Integer)o).intValue()) == column) {
                    isRolloverColumn = true;
                }
                if ((o = header.getClientProperty("sortedColumn")) != null) {
                    int[] sc = (int[])o;
                    priority = -1;
                    for (int i = 0; i < sc.length; ++i) {
                        if (sc[i] != column) continue;
                        priority = i;
                    }
                    if (priority > -1) {
                        paintArrow = true;
                        o = header.getClientProperty("sortingDirection");
                        if (o != null) {
                            int[] sd = (int[])o;
                            sortingDirection = sd[priority];
                        }
                    }
                }
                if (isRolloverColumn) {
                    this.setBackground(Theme.tableHeaderRolloverBackColor[Theme.style].getColor());
                } else {
                    this.setBackground(header.getBackground());
                }
                this.setForeground(header.getForeground());
                this.setFont(header.getFont());
            }
            if ((model = table.getModel()) instanceof SortableTableData) {
                if (paintArrow) {
                    int pri = Math.min(3, priority);
                    if (sortingDirection == 1) {
                        if (arrows[0][pri] == null) {
                            TinyTableHeaderRenderer.arrows[0][pri] = new Arrow(false, priority);
                        }
                        icon = arrows[0][pri];
                    } else {
                        if (arrows[1][pri] == null) {
                            TinyTableHeaderRenderer.arrows[1][pri] = new Arrow(true, priority);
                        }
                        icon = arrows[1][pri];
                    }
                } else {
                    int modelColumn = table.getColumnModel().getColumn(column).getModelIndex();
                    if (!((SortableTableData)((Object)model)).isColumnSortable(modelColumn)) {
                        icon = null;
                    }
                }
            } else {
                icon = null;
                this.setToolTipText(null);
            }
        }
        this.setIcon(icon);
        this.setText(value == null ? "" : value.toString());
        if (isRolloverColumn) {
            this.setBorder(UIManager.getBorder("TableHeader.cellRolloverBorder"));
        } else {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
        int modelColumn = table.getColumnModel().getColumn(column).getModelIndex();
        if (this.horizontalAlignments != null && this.horizontalAlignments.length > modelColumn) {
            this.setHorizontalAlignment(this.horizontalAlignments[modelColumn]);
        }
        return this;
    }

    private static class Arrow
    implements Icon {
        private static final int height = 11;
        private boolean descending;
        private int priority;

        public Arrow(boolean descending, int priority) {
            this.descending = descending;
            this.priority = Math.min(3, priority);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.priority == -1) {
                return;
            }
            int dx = this.priority;
            int dy = (6 + this.priority) / 2;
            g.translate(x + dx, y + dy);
            g.setColor(Theme.tableHeaderArrowColor[Theme.style].getColor());
            if (this.descending) {
                switch (this.priority) {
                    case 0: {
                        g.drawLine(4, 4, 4, 4);
                        g.drawLine(3, 3, 5, 3);
                        g.drawLine(2, 2, 6, 2);
                        g.drawLine(1, 1, 7, 1);
                        g.drawLine(0, 0, 8, 0);
                        break;
                    }
                    case 1: {
                        g.drawLine(3, 3, 3, 3);
                        g.drawLine(2, 2, 4, 2);
                        g.drawLine(1, 1, 5, 1);
                        g.drawLine(0, 0, 6, 0);
                        break;
                    }
                    case 2: {
                        g.drawLine(2, 2, 2, 2);
                        g.drawLine(1, 1, 3, 1);
                        g.drawLine(0, 0, 4, 0);
                        break;
                    }
                    default: {
                        g.drawLine(1, 1, 1, 1);
                        g.drawLine(0, 0, 2, 0);
                        break;
                    }
                }
            } else {
                switch (this.priority) {
                    case 0: {
                        g.drawLine(4, 0, 4, 0);
                        g.drawLine(3, 1, 5, 1);
                        g.drawLine(2, 2, 6, 2);
                        g.drawLine(1, 3, 7, 3);
                        g.drawLine(0, 4, 8, 4);
                        break;
                    }
                    case 1: {
                        g.drawLine(3, 0, 3, 0);
                        g.drawLine(2, 1, 4, 1);
                        g.drawLine(1, 2, 5, 2);
                        g.drawLine(0, 3, 6, 3);
                        break;
                    }
                    case 2: {
                        g.drawLine(2, 0, 2, 0);
                        g.drawLine(1, 1, 3, 1);
                        g.drawLine(0, 2, 4, 2);
                        break;
                    }
                    default: {
                        g.drawLine(1, 0, 1, 0);
                        g.drawLine(0, 1, 2, 1);
                    }
                }
            }
            g.translate(-(x + dx), -(y + dy));
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 11;
        }
    }
}

