/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TinyToolButtonBorder
extends AbstractBorder {
    protected final Insets insets = new Insets(1, 1, 1, 1);

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(c, g, x, y, w, h);
                break;
            }
            case 1: {
                this.drawWinBorder(c, g, x, y, w, h);
                break;
            }
            case 2: {
                this.drawXpBorder(c, g, x, y, w, h);
            }
        }
    }

    private void drawTinyBorder(Component c, Graphics g, int x, int y, int w, int h) {
    }

    private void drawWinBorder(Component c, Graphics g, int x, int y, int w, int h) {
        AbstractButton b = (AbstractButton)c;
        g.translate(-x, -y);
        g.setColor(Theme.toolBorderLightColor[Theme.style].getColor());
        if (b.isSelected() || b.getModel().isPressed() && b.getModel().isRollover()) {
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 1);
        } else {
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 1, 0, h - 1);
        }
        g.setColor(Theme.toolBorderDarkColor[Theme.style].getColor());
        if (b.isSelected() || b.getModel().isPressed() && b.getModel().isRollover()) {
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 1, 0, h - 1);
        } else {
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 1);
        }
        g.translate(x, y);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawXpBorder(Component c, Graphics g, int x, int y, int w, int h) {
        ColorUIResource col;
        block10: {
            boolean isRollover;
            boolean isFileChooserButton;
            AbstractButton b;
            block11: {
                b = (AbstractButton)c;
                col = null;
                isFileChooserButton = Boolean.TRUE.equals(b.getClientProperty("JFileChooser.isFileChooserButton"));
                boolean bl = isRollover = b.getModel().isRollover() || b.getModel().isArmed();
                if (!b.getModel().isPressed()) break block11;
                if (isRollover) {
                    col = Theme.toolBorderPressedColor[Theme.style].getColor();
                    break block10;
                } else if (b.isSelected()) {
                    col = Theme.toolBorderSelectedColor[Theme.style].getColor();
                    break block10;
                } else {
                    if (isFileChooserButton) {
                        return;
                    }
                    col = Theme.toolBorderColor[Theme.style].getColor();
                    return;
                }
            }
            if (isRollover) {
                col = b.isSelected() ? Theme.toolBorderSelectedColor[Theme.style].getColor() : Theme.toolBorderRolloverColor[Theme.style].getColor();
            } else if (b.isSelected()) {
                col = Theme.toolBorderSelectedColor[Theme.style].getColor();
            } else {
                if (isFileChooserButton) {
                    return;
                }
                col = Theme.toolBorderColor[Theme.style].getColor();
                return;
            }
        }
        DrawRoutines.drawRoundedBorder(g, col, x, y, w, h);
    }

    public Insets getBorderInsets(Component c) {
        if (!(c instanceof AbstractButton)) {
            return this.insets;
        }
        AbstractButton b = (AbstractButton)c;
        if (b.getMargin() == null || b.getMargin() instanceof UIResource) {
            return new Insets(Theme.toolMarginTop[Theme.style], Theme.toolMarginLeft[Theme.style], Theme.toolMarginBottom[Theme.style], Theme.toolMarginRight[Theme.style]);
        }
        Insets margin = b.getMargin();
        return new Insets(margin.top + 1, margin.left + 1, margin.bottom + 1, margin.right + 1);
    }
}

