/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class TinyButtonBorder
extends AbstractBorder
implements UIResource {
    protected final Insets borderInsets = new Insets(2, 2, 2, 2);

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(c, g, x, y, w, h);
                break;
            }
            case 1: {
                this.drawWinBorder(c, g, x, y, w, h);
                break;
            }
            case 2: {
                this.drawXpBorder(c, g, x, y, w, h);
            }
        }
    }

    private void drawTinyBorder(Component c, Graphics g, int x, int y, int w, int h) {
    }

    private void drawWinBorder(Component c, Graphics g, int x, int y, int w, int h) {
        boolean isDefault;
        AbstractButton b = (AbstractButton)c;
        boolean bl = isDefault = c instanceof JButton && ((JButton)c).isDefaultButton();
        if (b.getModel().isPressed() || b instanceof JToggleButton && b.isSelected()) {
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor(Theme.buttonDarkColor[Theme.style].getColor());
            g.drawRect(1, 1, w - 3, h - 3);
            return;
        }
        if (isDefault && b.isEnabled()) {
            g.setColor(Theme.buttonDefaultColor[Theme.style].getColor());
            g.drawRect(0, 0, w - 1, h - 1);
            ++x;
            ++y;
            --w;
            --h;
        }
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonLightColor[Theme.style].getColor());
        }
        g.drawLine(x, y, w - 2, y);
        g.drawLine(x, y + 1, x, h - 2);
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonBorderDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonBorderColor[Theme.style].getColor());
        }
        g.drawLine(x, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, y, w - 1, h - 1);
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonDarkDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonDarkColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, y + 1, w - 2, h - 2);
    }

    private void drawXpBorder(Component c, Graphics g, int x, int y, int w, int h) {
        AbstractButton b = (AbstractButton)c;
        boolean isDefault = c instanceof JButton && ((JButton)c).isDefaultButton();
        boolean isComboBoxButton = Boolean.TRUE.equals(b.getClientProperty("isComboBoxButton"));
        if (isComboBoxButton) {
            if (!b.isEnabled()) {
                DrawRoutines.drawRoundedBorder(g, Theme.comboBorderDisabledColor[Theme.style].getColor(), x, y, w, h);
            } else {
                DrawRoutines.drawRoundedBorder(g, Theme.comboBorderColor[Theme.style].getColor(), x, y, w, h);
                if (b.getModel().isPressed()) {
                    return;
                }
            }
        } else {
            boolean paintRollover;
            boolean isSpinnerButton = Boolean.TRUE.equals(b.getClientProperty("isSpinnerButton"));
            boolean bl = paintRollover = isSpinnerButton && Theme.spinnerRollover[Theme.style] || !isSpinnerButton && Theme.buttonRollover[Theme.style];
            if (!b.isEnabled()) {
                DrawRoutines.drawRoundedBorder(g, Theme.buttonBorderDisabledColor[Theme.style].getColor(), x, y, w, h);
            } else {
                DrawRoutines.drawRoundedBorder(g, Theme.buttonBorderColor[Theme.style].getColor(), x, y, w, h);
                if (b.getModel().isPressed()) {
                    return;
                }
            }
        }
    }

    public Insets getBorderInsets(Component c) {
        return this.borderInsets;
    }
}

