/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyButtonUI;
import de.muntjak.tinylookandfeel.TinyInternalFrameTitlePane;
import de.muntjak.tinylookandfeel.TinyTitlePane;
import de.muntjak.tinylookandfeel.borders.TinyFrameBorder;
import de.muntjak.tinylookandfeel.borders.TinyInternalFrameBorder;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class TinyWindowButtonUI
extends TinyButtonUI {
    private int type;
    public static final int CLOSE = 0;
    public static final int MAXIMIZE = 1;
    public static final int MINIMIZE = 2;

    public static ComponentUI createUI(JComponent c) {
        throw new IllegalStateException("Must not be used this way.");
    }

    TinyWindowButtonUI(int type) {
        this.type = type;
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        button.setBorder(null);
        button.setFocusable(false);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        boolean frameSelected = false;
        boolean frameMaximized = false;
        if (c.getParent() instanceof TinyInternalFrameTitlePane) {
            frameSelected = ((TinyInternalFrameTitlePane)c.getParent()).isFrameSelected();
            frameMaximized = ((TinyInternalFrameTitlePane)c.getParent()).isFrameMaximized();
        } else if (c.getParent() instanceof TinyTitlePane) {
            frameSelected = ((TinyTitlePane)c.getParent()).isSelected();
            frameMaximized = ((TinyTitlePane)c.getParent()).isFrameMaximized();
        }
        int w = button.getWidth();
        int h = button.getHeight();
        ColorUIResource col = null;
        col = !frameSelected ? (button.isEnabled() ? (button.getModel().isPressed() ? (this.type == 0 ? Theme.frameButtClosePressedColor[Theme.style].getColor() : Theme.frameButtPressedColor[Theme.style].getColor()) : (this.type == 0 ? Theme.frameButtCloseColor[Theme.style].getColor() : Theme.frameButtColor[Theme.style].getColor())) : (this.type == 0 ? Theme.frameButtCloseDisabledColor[Theme.style].getColor() : Theme.frameButtDisabledColor[Theme.style].getColor())) : (button.getModel().isPressed() ? (button.getModel().isRollover() ? (this.type == 0 ? Theme.frameButtClosePressedColor[Theme.style].getColor() : Theme.frameButtPressedColor[Theme.style].getColor()) : (this.type == 0 ? Theme.frameButtCloseColor[Theme.style].getColor() : Theme.frameButtColor[Theme.style].getColor())) : (button.getModel().isRollover() ? (this.type == 0 ? Theme.frameButtCloseRolloverColor[Theme.style].getColor() : Theme.frameButtRolloverColor[Theme.style].getColor()) : (this.type == 0 ? Theme.frameButtCloseColor[Theme.style].getColor() : Theme.frameButtColor[Theme.style].getColor())));
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyButton(g, button, col, w, h, frameSelected);
                break;
            }
            case 1: {
                this.drawWinButton(g, button, col, w, h, frameSelected);
                break;
            }
            case 2: {
                this.drawXpButton(g, button, col, w, h, frameSelected);
            }
        }
        if (!button.isEnabled()) {
            if (this.type == 0) {
                g.setColor(Theme.frameSymbolCloseDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.frameSymbolDisabledColor[Theme.style].getColor());
            }
        } else if (this.type == 0) {
            g.setColor(Theme.frameSymbolCloseColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameSymbolColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinySymbol(g, button, col, w, h, frameSelected, frameMaximized);
                break;
            }
            case 1: {
                this.drawWinSymbol(g, button, col, w, h, frameSelected, frameMaximized);
                break;
            }
            case 2: {
                this.drawXpSymbol(g, button, col, w, h, frameSelected, frameMaximized);
            }
        }
    }

    private void drawTinyButton(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected) {
        g.fillRect(1, 1, w - 2, h - 2);
    }

    private void drawWinButton(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected) {
        g.fillRect(1, 1, w - 2, h - 2);
        if (button.getModel().isPressed() && button.getModel().isRollover() || button.getModel().isPressed() && !frameSelected) {
            g.setColor(Theme.frameButtBorderColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameButtLightColor[Theme.style].getColor());
        }
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 1, 0, h - 2);
        g.setColor(Theme.frameButtDarkColor[Theme.style].getColor());
        if (button.getModel().isPressed() && button.getModel().isRollover() || button.getModel().isPressed() && !frameSelected) {
            g.drawLine(1, 1, w - 2, 1);
            g.drawLine(1, 1, 1, h - 3);
        } else {
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.drawLine(w - 2, 1, w - 2, h - 3);
        }
        if (button.getModel().isPressed() && button.getModel().isRollover() || button.getModel().isPressed() && !frameSelected) {
            g.setColor(Theme.frameButtLightColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameButtBorderColor[Theme.style].getColor());
        }
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 0, w - 1, h - 2);
    }

    private void drawXpButton(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected) {
        if (button.getClientProperty("externalFrameButton") == Boolean.TRUE) {
            this.drawXpLargeButton(g, button, c, w, h, frameSelected);
            return;
        }
        g.fillRect(1, 1, w - 2, h - 2);
        boolean isPalette = false;
        if (button.getParent() instanceof TinyInternalFrameTitlePane && ((TinyInternalFrameTitlePane)button.getParent()).isPalette()) {
            isPalette = true;
        }
        if (frameSelected) {
            g.setColor(TinyInternalFrameBorder.frameUpperColor);
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 1, 0, 1);
            g.drawLine(w - 1, 1, w - 1, 1);
            g.setColor(TinyInternalFrameBorder.frameLowerColor);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(0, h - 2, 0, h - 2);
            g.drawLine(w - 1, h - 2, w - 1, h - 2);
        } else {
            g.setColor(TinyInternalFrameBorder.disabledUpperColor);
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 1, 0, 1);
            g.drawLine(w - 1, 1, w - 1, 1);
            g.setColor(TinyInternalFrameBorder.disabledLowerColor);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(0, h - 2, 0, h - 2);
            g.drawLine(w - 1, h - 2, w - 1, h - 2);
        }
        ColorUIResource col = null;
        col = !button.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseBorderDisabledColor[Theme.style].getColor() : Theme.frameButtBorderDisabledColor[Theme.style].getColor()) : (this.type == 0 ? Theme.frameButtCloseBorderColor[Theme.style].getColor() : Theme.frameButtBorderColor[Theme.style].getColor());
        DrawRoutines.drawRoundedBorder(g, col, 0, 0, w, h);
        col = !button.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseLightDisabledColor[Theme.style].getColor() : Theme.frameButtLightDisabledColor[Theme.style].getColor()) : (this.type == 0 ? Theme.frameButtCloseLightColor[Theme.style].getColor() : Theme.frameButtLightColor[Theme.style].getColor());
        g.setColor(col);
        g.drawLine(2, 1, w - 3, 1);
        g.drawLine(1, 2, 1, h - 3);
        col = !button.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseDarkDisabledColor[Theme.style].getColor() : Theme.frameButtDarkDisabledColor[Theme.style].getColor()) : (this.type == 0 ? Theme.frameButtCloseDarkColor[Theme.style].getColor() : Theme.frameButtDarkColor[Theme.style].getColor());
        g.setColor(col);
        g.drawLine(w - 2, 2, w - 2, h - 3);
        g.drawLine(2, h - 2, w - 3, h - 2);
    }

    private void drawXpLargeButton(Graphics g, AbstractButton b, Color c, int w, int h, boolean frameSelected) {
        g.setColor(TinyFrameBorder.buttonUpperColor);
        g.drawLine(0, 0, w - 1, 0);
        g.setColor(TinyFrameBorder.buttonLowerColor);
        g.drawLine(0, h - 1, w - 1, h - 1);
        int spread1 = Theme.frameButtSpreadLight[Theme.style];
        int spread2 = Theme.frameButtSpreadDark[Theme.style];
        if (!b.isEnabled()) {
            if (this.type == 0) {
                spread1 = Theme.frameButtCloseSpreadLightDisabled[Theme.style];
                spread2 = Theme.frameButtCloseSpreadDarkDisabled[Theme.style];
            } else {
                spread1 = Theme.frameButtSpreadLightDisabled[Theme.style];
                spread2 = Theme.frameButtSpreadDarkDisabled[Theme.style];
            }
        } else if (this.type == 0) {
            spread1 = Theme.frameButtCloseSpreadLight[Theme.style];
            spread2 = Theme.frameButtCloseSpreadDark[Theme.style];
        }
        float spreadStep1 = 10.0f * (float)spread1 / (float)(h - 3);
        float spreadStep2 = 10.0f * (float)spread2 / (float)(h - 3);
        int halfY = h / 2;
        for (int y = 1; y < h - 1; ++y) {
            int yd;
            if (y < halfY) {
                yd = halfY - y;
                g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
            } else if (y == halfY) {
                g.setColor(c);
            } else {
                yd = y - halfY;
                g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
            }
            g.drawLine(2, y, w - 3, y);
            if (y == 1 && b.isEnabled()) {
                g.drawLine(1, 2, 1, h - 3);
                continue;
            }
            if (y != h - 2) continue;
            g.drawLine(w - 2, 2, w - 2, h - 3);
        }
        if (!b.isEnabled()) {
            if (this.type == 0) {
                DrawRoutines.drawRoundedBorder(g, Theme.frameButtCloseBorderDisabledColor[Theme.style].getColor(), 0, 0, w, h);
            } else {
                DrawRoutines.drawRoundedBorder(g, Theme.frameButtBorderDisabledColor[Theme.style].getColor(), 0, 0, w, h);
            }
        } else if (this.type == 0) {
            DrawRoutines.drawRoundedBorder(g, Theme.frameButtCloseBorderColor[Theme.style].getColor(), 0, 0, w, h);
        } else {
            DrawRoutines.drawRoundedBorder(g, Theme.frameButtBorderColor[Theme.style].getColor(), 0, 0, w, h);
        }
    }

    private void drawTinySymbol(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected, boolean frameMaximized) {
    }

    private void drawWinSymbol(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected, boolean frameMaximized) {
        int x = 3;
        int y = 2;
        if (button.getModel().isPressed() && button.getModel().isRollover() || button.getModel().isPressed() && !frameSelected) {
            x = 4;
            y = 3;
        }
        switch (this.type) {
            case 0: {
                g.drawLine(x + 1, y + 1, x + 2, y + 1);
                g.drawLine(x + 7, y + 1, x + 8, y + 1);
                g.drawLine(x + 2, y + 2, x + 3, y + 2);
                g.drawLine(x + 6, y + 2, x + 7, y + 2);
                g.drawLine(x + 3, y + 3, x + 6, y + 3);
                g.drawLine(x + 4, y + 4, x + 5, y + 4);
                g.drawLine(x + 3, y + 5, x + 6, y + 5);
                g.drawLine(x + 2, y + 6, x + 3, y + 6);
                g.drawLine(x + 6, y + 6, x + 7, y + 6);
                g.drawLine(x + 1, y + 7, x + 2, y + 7);
                g.drawLine(x + 7, y + 7, x + 8, y + 7);
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.fillRect(x + 2, y, 6, 2);
                    g.drawLine(x + 2, y + 2, x + 2, y + 2);
                    g.drawLine(x + 6, y + 5, x + 7, y + 5);
                    g.drawLine(x + 7, y + 2, x + 7, y + 4);
                    g.drawLine(x, y + 3, x + 5, y + 3);
                    g.drawRect(x, y + 4, 5, 4);
                    break;
                }
                g.drawRect(x, y, 8, 8);
                g.drawLine(x + 1, y + 1, x + 7, y + 1);
                break;
            }
            case 2: {
                g.drawRect(x + 1, y + 7, 6, 1);
            }
        }
    }

    private void drawXpSymbol(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected, boolean frameMaximized) {
        if (button.getClientProperty("externalFrameButton") == Boolean.TRUE) {
            this.drawXpLargeSymbol(g, button, c, w, h, frameSelected, frameMaximized);
            return;
        }
        if (button.getParent() instanceof TinyInternalFrameTitlePane && ((TinyInternalFrameTitlePane)button.getParent()).isPalette()) {
            this.drawXpSmallSymbol(g, button, c, w, h, frameSelected, frameMaximized);
            return;
        }
        if (!frameSelected) {
            if (button.isEnabled() && !button.getModel().isPressed()) {
                if (this.type == 0) {
                    g.setColor(Theme.frameSymbolCloseColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.frameSymbolColor[Theme.style].getColor());
                }
            } else if (this.type == 0) {
                if (button.getModel().isPressed()) {
                    g.setColor(Theme.frameSymbolClosePressedColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.frameSymbolCloseDisabledColor[Theme.style].getColor());
                }
            } else if (button.getModel().isPressed()) {
                g.setColor(Theme.frameSymbolPressedColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.frameSymbolDisabledColor[Theme.style].getColor());
            }
        } else if (button.getModel().isPressed() && button.getModel().isRollover()) {
            if (this.type == 0) {
                g.setColor(Theme.frameSymbolClosePressedColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.frameSymbolPressedColor[Theme.style].getColor());
            }
        } else if (this.type == 0) {
            g.setColor(Theme.frameSymbolCloseColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameSymbolColor[Theme.style].getColor());
        }
        int x = 0;
        int y = 0;
        switch (this.type) {
            case 0: {
                g.drawLine(x + 4, y + 3, x + 4, y + 3);
                g.drawLine(x + 12, y + 3, x + 12, y + 3);
                g.drawLine(x + 3, y + 4, x + 5, y + 4);
                g.drawLine(x + 11, y + 4, x + 13, y + 4);
                g.drawLine(x + 4, y + 5, x + 6, y + 5);
                g.drawLine(x + 10, y + 5, x + 12, y + 5);
                g.drawLine(x + 5, y + 6, x + 7, y + 6);
                g.drawLine(x + 9, y + 6, x + 11, y + 6);
                g.drawLine(x + 6, y + 7, x + 10, y + 7);
                g.drawLine(x + 7, y + 8, x + 9, y + 8);
                g.drawLine(x + 4, y + 13, x + 4, y + 13);
                g.drawLine(x + 12, y + 13, x + 12, y + 13);
                g.drawLine(x + 3, y + 12, x + 5, y + 12);
                g.drawLine(x + 11, y + 12, x + 13, y + 12);
                g.drawLine(x + 4, y + 11, x + 6, y + 11);
                g.drawLine(x + 10, y + 11, x + 12, y + 11);
                g.drawLine(x + 5, y + 10, x + 7, y + 10);
                g.drawLine(x + 9, y + 10, x + 11, y + 10);
                g.drawLine(x + 6, y + 9, x + 10, y + 9);
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.fillRect(x + 6, y + 3, 8, 2);
                    g.drawLine(x + 6, y + 5, x + 6, y + 6);
                    g.drawLine(x + 11, y + 9, x + 13, y + 9);
                    g.drawLine(x + 13, y + 5, x + 13, y + 8);
                    g.drawLine(x + 3, y + 7, x + 10, y + 7);
                    g.drawRect(x + 3, y + 8, 7, 5);
                    break;
                }
                g.fillRect(x + 3, y + 3, 11, 2);
                g.drawRect(x + 3, y + 5, 10, 8);
                break;
            }
            case 2: {
                g.fillRect(x + 3, y + 11, 7, 3);
            }
        }
    }

    private void drawXpSmallSymbol(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected, boolean frameMaximized) {
        if (!frameSelected) {
            if (button.isEnabled() && !button.getModel().isPressed()) {
                if (this.type == 0) {
                    g.setColor(Theme.frameSymbolCloseColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.frameSymbolColor[Theme.style].getColor());
                }
            } else if (this.type == 0) {
                if (button.getModel().isPressed()) {
                    g.setColor(Theme.frameSymbolClosePressedColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.frameSymbolCloseDisabledColor[Theme.style].getColor());
                }
            } else if (button.getModel().isPressed()) {
                g.setColor(Theme.frameSymbolPressedColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.frameSymbolDisabledColor[Theme.style].getColor());
            }
        } else if (button.getModel().isPressed() && button.getModel().isRollover()) {
            if (this.type == 0) {
                g.setColor(Theme.frameSymbolClosePressedColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.frameSymbolPressedColor[Theme.style].getColor());
            }
        } else if (this.type == 0) {
            g.setColor(Theme.frameSymbolCloseColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameSymbolColor[Theme.style].getColor());
        }
        int x = 0;
        int y = 0;
        switch (this.type) {
            case 0: {
                g.drawLine(x + 3, y + 2, x + 3, y + 2);
                g.drawLine(x + 9, y + 2, x + 9, y + 2);
                g.drawLine(x + 2, y + 3, x + 4, y + 3);
                g.drawLine(x + 8, y + 3, x + 10, y + 3);
                g.drawLine(x + 3, y + 4, x + 5, y + 4);
                g.drawLine(x + 7, y + 4, x + 9, y + 4);
                g.drawLine(x + 4, y + 5, x + 8, y + 5);
                g.drawLine(x + 5, y + 6, x + 7, y + 6);
                g.drawLine(x + 4, y + 7, x + 8, y + 7);
                g.drawLine(x + 3, y + 8, x + 5, y + 8);
                g.drawLine(x + 7, y + 8, x + 9, y + 8);
                g.drawLine(x + 2, y + 9, x + 4, y + 9);
                g.drawLine(x + 8, y + 9, x + 10, y + 9);
                g.drawLine(x + 3, y + 10, x + 3, y + 10);
                g.drawLine(x + 9, y + 10, x + 9, y + 10);
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.drawRect(x + 2, y + 6, 6, 4);
                    g.drawLine(x + 2, y + 5, x + 8, y + 5);
                    g.fillRect(x + 4, y + 2, x + 7, y + 2);
                    g.drawLine(x + 4, y + 4, x + 4, y + 4);
                    g.drawLine(x + 9, y + 7, x + 9, y + 7);
                    g.drawLine(x + 10, y + 4, x + 10, y + 7);
                    break;
                }
                g.drawLine(x + 2, y + 2, x + 10, y + 2);
                g.drawRect(x + 2, y + 3, 8, 7);
                break;
            }
            case 2: {
                g.fillRect(x + 2, y + 8, 6, 3);
            }
        }
    }

    private void drawXpLargeSymbol(Graphics g, AbstractButton b, Color c, int w, int h, boolean frameSelected, boolean frameMaximized) {
        if (!frameSelected) {
            if (b.isEnabled() && !b.getModel().isPressed()) {
                if (this.type == 0) {
                    g.setColor(Theme.frameSymbolCloseColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.frameSymbolColor[Theme.style].getColor());
                }
            } else if (this.type == 0) {
                if (b.getModel().isPressed()) {
                    g.setColor(Theme.frameSymbolClosePressedColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.frameSymbolCloseDisabledColor[Theme.style].getColor());
                }
            } else if (b.getModel().isPressed()) {
                g.setColor(Theme.frameSymbolPressedColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.frameSymbolDisabledColor[Theme.style].getColor());
            }
        } else if (b.getModel().isPressed() && b.getModel().isRollover()) {
            if (this.type == 0) {
                g.setColor(Theme.frameSymbolClosePressedColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.frameSymbolPressedColor[Theme.style].getColor());
            }
        } else if (this.type == 0) {
            g.setColor(Theme.frameSymbolCloseColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameSymbolColor[Theme.style].getColor());
        }
        int x = 0;
        int y = 0;
        switch (this.type) {
            case 0: {
                g.drawLine(x + 5, y + 5, x + 6, y + 5);
                g.drawLine(x + 14, y + 5, x + 15, y + 5);
                g.drawLine(x + 5, y + 6, x + 7, y + 6);
                g.drawLine(x + 13, y + 6, x + 15, y + 6);
                g.drawLine(x + 6, y + 7, x + 8, y + 7);
                g.drawLine(x + 12, y + 7, x + 14, y + 7);
                g.drawLine(x + 7, y + 8, x + 9, y + 8);
                g.drawLine(x + 11, y + 8, x + 13, y + 8);
                g.drawLine(x + 8, y + 9, x + 12, y + 9);
                g.drawLine(x + 9, y + 10, x + 11, y + 10);
                g.drawLine(x + 5, y + 15, x + 6, y + 15);
                g.drawLine(x + 14, y + 15, x + 15, y + 15);
                g.drawLine(x + 5, y + 14, x + 7, y + 14);
                g.drawLine(x + 13, y + 14, x + 15, y + 14);
                g.drawLine(x + 6, y + 13, x + 8, y + 13);
                g.drawLine(x + 12, y + 13, x + 14, y + 13);
                g.drawLine(x + 7, y + 12, x + 9, y + 12);
                g.drawLine(x + 11, y + 12, x + 13, y + 12);
                g.drawLine(x + 8, y + 11, x + 12, y + 11);
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.fillRect(x + 8, y + 4, 8, 2);
                    g.fillRect(x + 4, y + 9, 8, 2);
                    break;
                }
                g.fillRect(x + 5, y + 6, 10, 2);
                break;
            }
            case 2: {
                g.fillRect(x + 5, y + 14, 6, 2);
            }
        }
        Color col = null;
        col = this.type == 0 ? Theme.frameSymbolCloseLightColor[Theme.style].getColor() : Theme.frameSymbolLightColor[Theme.style].getColor();
        if (!frameSelected) {
            col = ColorRoutines.getAverage(col, c);
        }
        g.setColor(col);
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.drawLine(x + 7, y + 4, x + 7, y + 7);
                    g.drawLine(x + 9, y + 6, x + 14, y + 6);
                    g.drawLine(x + 15, y + 6, x + 15, y + 10);
                    g.drawLine(x + 13, y + 12, x + 16, y + 12);
                    g.drawLine(x + 3, y + 9, x + 3, y + 16);
                    g.drawLine(x + 3, y + 17, x + 12, y + 17);
                    g.drawLine(x + 5, y + 11, x + 10, y + 11);
                    g.drawLine(x + 11, y + 11, x + 11, y + 15);
                    break;
                }
                g.drawLine(x + 4, y + 6, x + 4, y + 15);
                g.drawLine(x + 4, y + 16, x + 15, y + 16);
                g.drawLine(x + 6, y + 8, x + 13, y + 8);
                g.drawLine(x + 14, y + 8, x + 14, y + 14);
                break;
            }
            case 2: {
                g.drawLine(x + 4, y + 13, x + 4, y + 16);
                g.drawLine(x + 5, y + 16, x + 11, y + 16);
            }
        }
        col = this.type == 0 ? Theme.frameSymbolCloseDarkColor[Theme.style].getColor() : Theme.frameSymbolDarkColor[Theme.style].getColor();
        if (!frameSelected) {
            col = ColorRoutines.getAverage(col, c);
        }
        g.setColor(col);
        switch (this.type) {
            case 0: {
                g.drawLine(x + 5, y + 4, x + 6, y + 4);
                g.drawLine(x + 14, y + 4, x + 15, y + 4);
                g.drawLine(x + 7, y + 5, x + 7, y + 5);
                g.drawLine(x + 13, y + 5, x + 13, y + 5);
                g.drawLine(x + 8, y + 6, x + 8, y + 6);
                g.drawLine(x + 12, y + 6, x + 12, y + 6);
                g.drawLine(x + 9, y + 7, x + 9, y + 7);
                g.drawLine(x + 11, y + 7, x + 11, y + 7);
                g.drawLine(x + 10, y + 8, x + 10, y + 8);
                g.drawLine(x + 8, y + 10, x + 8, y + 10);
                g.drawLine(x + 12, y + 10, x + 12, y + 10);
                g.drawLine(x + 7, y + 11, x + 7, y + 11);
                g.drawLine(x + 13, y + 11, x + 13, y + 11);
                g.drawLine(x + 6, y + 12, x + 6, y + 12);
                g.drawLine(x + 14, y + 12, x + 14, y + 12);
                g.drawLine(x + 5, y + 13, x + 5, y + 13);
                g.drawLine(x + 15, y + 13, x + 15, y + 13);
                g.drawLine(x + 4, y + 14, x + 4, y + 14);
                g.drawLine(x + 16, y + 14, x + 16, y + 14);
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.drawLine(x + 8, y + 3, x + 15, y + 3);
                    g.drawLine(x + 16, y + 3, x + 16, y + 11);
                    g.drawLine(x + 13, y + 11, x + 15, y + 11);
                    g.drawLine(x + 8, y + 6, x + 8, y + 7);
                    g.drawLine(x + 4, y + 8, x + 11, y + 8);
                    g.drawLine(x + 12, y + 8, x + 12, y + 16);
                    g.drawLine(x + 4, y + 16, x + 11, y + 16);
                    g.drawLine(x + 4, y + 11, x + 4, y + 15);
                    break;
                }
                g.drawLine(x + 5, y + 5, x + 14, y + 5);
                g.drawLine(x + 15, y + 5, x + 15, y + 15);
                g.drawLine(x + 5, y + 15, x + 14, y + 15);
                g.drawLine(x + 5, y + 8, x + 5, y + 14);
                break;
            }
            case 2: {
                g.drawLine(x + 5, y + 13, x + 10, y + 13);
                g.drawLine(x + 11, y + 13, x + 11, y + 15);
            }
        }
    }

    public static TinyWindowButtonUI createButtonUIForType(int type) {
        return new TinyWindowButtonUI(type);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (((AbstractButton)c).getClientProperty("externalFrameButton") == Boolean.TRUE) {
            return Theme.frameExternalButtonSize[Theme.derivedStyle[Theme.style]];
        }
        if (c.getParent() instanceof TinyInternalFrameTitlePane && ((TinyInternalFrameTitlePane)c.getParent()).isPalette()) {
            return Theme.framePaletteButtonSize[Theme.derivedStyle[Theme.style]];
        }
        return Theme.frameInternalButtonSize[Theme.derivedStyle[Theme.style]];
    }
}

