/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyScrollButton;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.SBChooser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class TinyScrollBarUI
extends BasicScrollBarUI {
    static final int alpha = 92;
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    private boolean freeStanding = false;
    private int scrollBarWidth;

    protected void installDefaults() {
        this.scrollBarWidth = TinyScrollButton.size[Theme.derivedStyle[Theme.style]].width;
        super.installDefaults();
        this.scrollbar.setBorder(null);
        this.minimumThumbSize = new Dimension(17, 17);
    }

    protected Dimension getMaximumThumbSize() {
        return this.maximumThumbSize;
    }

    public static ComponentUI createUI(JComponent c) {
        return new TinyScrollBarUI();
    }

    protected JButton createDecreaseButton(int orientation) {
        return new TinyScrollButton(orientation, this);
    }

    protected JButton createIncreaseButton(int orientation) {
        return new TinyScrollButton(orientation, this);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    public void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyTrack(g, trackBounds);
                break;
            }
            case 1: {
                this.drawWinTrack(g, trackBounds);
                break;
            }
            case 2: {
                this.drawXpTrack(g, trackBounds);
            }
        }
    }

    private void drawTinyTrack(Graphics g, Rectangle t) {
        if (this.isThumbVisible()) {
            g.setColor(Theme.scrollTrackColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.scrollTrackDisabledColor[Theme.style].getColor());
        }
        g.fillRect(t.x, t.y, t.width, t.height);
        g.setColor(Color.BLACK);
        if (this.scrollbar.getOrientation() == 1) {
            g.drawLine(t.x, t.y, t.x, t.y + t.height - 1);
        } else {
            g.drawLine(t.x, t.y, t.x + t.width - 1, t.y);
        }
        if (!this.isThumbVisible()) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1) {
            g.setColor(ColorRoutines.darken(Theme.scrollTrackColor[Theme.style].getColor(), 30));
            g.drawLine(t.x + 1, t.y + 1, t.x + t.width - 3, t.y + 1);
            g.drawLine(t.x + 1, t.y + 1, t.x + 1, t.y + t.height - 1);
            g.setColor(ColorRoutines.darken(Theme.scrollTrackColor[Theme.style].getColor(), 20));
            g.drawLine(t.x + 2, t.y + 2, t.x + t.width - 4, t.y + 2);
            g.drawLine(t.x + 2, t.y + 2, t.x + 2, t.y + t.height - 1);
            g.setColor(ColorRoutines.lighten(Theme.scrollTrackColor[Theme.style].getColor(), 40));
            g.drawLine(t.x + t.width - 2, t.y + 1, t.x + t.width - 2, t.y + t.height - 1);
            g.setColor(ColorRoutines.lighten(Theme.scrollTrackColor[Theme.style].getColor(), 20));
            g.drawLine(t.x + t.width - 3, t.y + 2, t.x + t.width - 3, t.y + t.height - 1);
        } else {
            g.setColor(ColorRoutines.darken(Theme.scrollTrackColor[Theme.style].getColor(), 30));
            g.drawLine(t.x + 1, t.y + 1, t.x + t.width - 1, t.y + 1);
            g.drawLine(t.x + 1, t.y + 1, t.x + 1, t.y + t.height - 3);
            g.setColor(ColorRoutines.darken(Theme.scrollTrackColor[Theme.style].getColor(), 20));
            g.drawLine(t.x + 2, t.y + 2, t.x + t.width - 1, t.y + 2);
            g.drawLine(t.x + 2, t.y + 2, t.x + 2, t.y + t.height - 4);
            g.setColor(ColorRoutines.lighten(Theme.scrollTrackColor[Theme.style].getColor(), 40));
            g.drawLine(t.x + 1, t.y + t.height - 2, t.x + t.width - 1, t.y + t.height - 2);
            g.setColor(ColorRoutines.lighten(Theme.scrollTrackColor[Theme.style].getColor(), 20));
            g.drawLine(t.x + 2, t.y + t.height - 3, t.x + t.width - 1, t.y + t.height - 3);
        }
    }

    private void drawWinTrack(Graphics g, Rectangle trackBounds) {
        if (this.isThumbVisible()) {
            g.setColor(Theme.scrollTrackColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.scrollTrackDisabledColor[Theme.style].getColor());
        }
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }

    private void drawXpTrack(Graphics g, Rectangle t) {
        if (this.isThumbVisible()) {
            g.setColor(Theme.scrollTrackColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.scrollTrackDisabledColor[Theme.style].getColor());
        }
        g.fillRect(t.x, t.y, t.width, t.height);
        if (this.isThumbVisible()) {
            g.setColor(Theme.scrollTrackBorderColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.scrollTrackBorderDisabledColor[Theme.style].getColor());
        }
        if (this.scrollbar.getOrientation() == 1) {
            g.drawLine(t.x, t.y, t.x, t.y + t.height - 1);
            g.drawLine(t.x + t.width - 1, t.y, t.x + t.width - 1, t.y + t.height - 1);
        } else {
            g.drawLine(t.x, t.y, t.x + t.width - 1, t.y);
            g.drawLine(t.x, t.y + t.height - 1, t.x + t.width - 1, t.y + t.height - 1);
        }
    }

    public void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyThumb(g, thumbBounds);
                break;
            }
            case 1: {
                this.drawWinThumb(g, thumbBounds);
                break;
            }
            case 2: {
                this.drawXpThumb(g, thumbBounds);
            }
        }
    }

    private void drawTinyThumb(Graphics g, Rectangle t) {
    }

    private void drawWinThumb(Graphics g, Rectangle t) {
        if (this.isDragging) {
            g.setColor(Theme.scrollThumbPressedColor[Theme.style].getColor());
        } else if (this.isRollover && Theme.scrollRollover[Theme.style]) {
            g.setColor(Theme.scrollThumbRolloverColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.scrollThumbColor[Theme.style].getColor());
        }
        int x2 = t.x + t.width;
        int y2 = t.y + t.height;
        g.fillRect(t.x, t.y, t.width - 1, t.height - 1);
        g.setColor(Theme.scrollLightColor[Theme.style].getColor());
        g.drawLine(t.x + 1, t.y + 1, x2 - 3, t.y + 1);
        g.drawLine(t.x + 1, t.y + 1, t.x + 1, y2 - 3);
        g.setColor(Theme.scrollDarkColor[Theme.style].getColor());
        g.drawLine(x2 - 2, t.y + 1, x2 - 2, y2 - 3);
        g.drawLine(t.x + 1, y2 - 2, x2 - 2, y2 - 2);
        g.setColor(Theme.scrollBorderColor[Theme.style].getColor());
        g.drawLine(x2 - 1, t.y, x2 - 1, y2 - 2);
        g.drawLine(t.x, y2 - 1, x2 - 1, y2 - 1);
    }

    private void drawXpThumb(Graphics g, Rectangle t) {
        ColorUIResource c = null;
        c = this.isDragging && this.isRollover ? Theme.scrollThumbPressedColor[Theme.style].getColor() : (this.isRollover && Theme.scrollRollover[Theme.style] ? Theme.scrollThumbRolloverColor[Theme.style].getColor() : Theme.scrollThumbColor[Theme.style].getColor());
        g.setColor(c);
        int xs = t.x + 1;
        int ys = t.y + 1;
        int x2 = t.x + t.width - 1;
        int y2 = t.y + t.height - 1;
        ColorUIResource pressedLightColor = Theme.pressedLightColor[Theme.style].getColor();
        ColorUIResource pressedDarkColor = Theme.pressedDarkColor[Theme.style].getColor();
        ColorUIResource rolloverLightColor = Theme.rolloverLightColor[Theme.style].getColor();
        ColorUIResource rolloverDarkColor = Theme.rolloverDarkColor[Theme.style].getColor();
        ColorUIResource normalLightColor = Theme.normalLightColor[Theme.style].getColor();
        ColorUIResource normalDarkColor = Theme.normalDarkColor[Theme.style].getColor();
        ColorUIResource lightBorderColor = Theme.whiteBorderColor[Theme.style].getColor();
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                ColorUIResource a = Theme.scrollBorderColor[Theme.style].getColor();
                Graphics2D g2 = (Graphics2D)g;
                GradientPaint scrollBarBg = null;
                scrollBarBg = this.isDragging && this.isRollover ? new GradientPaint(xs, ys, pressedLightColor, x2, ys, pressedDarkColor) : (this.isRollover && Theme.scrollRollover[Theme.style] ? new GradientPaint(xs, ys, rolloverLightColor, x2, ys, rolloverDarkColor) : new GradientPaint(xs, ys, normalLightColor, x2, ys, normalDarkColor));
                GradientPaint scrollBarHight = new GradientPaint(xs, ys, new Color(1.0f, 1.0f, 1.0f, 0.5f), x2 / 2, ys, new Color(1.0f, 1.0f, 1.0f, 0.2f));
                g2.setPaint(scrollBarBg);
                g2.fillRoundRect(xs, ys, t.width - 2, t.height - 2, 3, 3);
                g2.setPaint(scrollBarHight);
                g2.fillRoundRect(xs, ys, (t.width - 2) / 2, t.height - 2, 3, 3);
                g2.setColor(a);
                g2.drawRoundRect(xs, ys, t.width - 2, t.height - 2, 3, 3);
                g2.setColor(lightBorderColor);
                g2.drawRoundRect(xs + 1, ys + 1, t.width - 4, t.height - 4, 3, 3);
                break;
            }
            case 0: {
                ColorUIResource aH = Theme.scrollBorderColor[Theme.style].getColor();
                Graphics2D g2H = (Graphics2D)g;
                GradientPaint scrollBarBg = this.isDragging && this.isRollover ? new GradientPaint(xs, ys, pressedLightColor, xs, y2, pressedDarkColor) : (this.isRollover && Theme.scrollRollover[Theme.style] ? new GradientPaint(xs, ys, rolloverLightColor, xs, y2, rolloverDarkColor) : new GradientPaint(xs, ys, normalLightColor, xs, y2, normalDarkColor));
                GradientPaint scrollBarHightH = new GradientPaint(xs, ys, new Color(1.0f, 1.0f, 1.0f, 0.5f), xs, y2 / 2, new Color(1.0f, 1.0f, 1.0f, 0.2f));
                g2H.setPaint(scrollBarBg);
                g2H.fillRoundRect(xs, ys, t.width - 2, t.height - 2, 3, 3);
                g2H.setPaint(scrollBarHightH);
                g2H.fillRoundRect(xs, ys, t.width - 2, (t.height - 2) / 2, 3, 3);
                g2H.setColor(aH);
                g2H.drawRoundRect(xs, ys, t.width - 2, t.height - 2, 3, 3);
                g2H.setColor(new Color(240, 240, 240));
                g2H.drawRoundRect(xs + 1, ys + 1, t.width - 4, t.height - 4, 3, 3);
            }
        }
        if (t.height < 11) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1) {
            int y;
            int y1 = t.y + t.height / 2 - 4;
            y2 = Math.min(y1 + 8, t.y + t.height - 5);
            g.setColor(SBChooser.getAdjustedColor(c, Theme.scrollGripLightColor[Theme.style].getSaturation(), Theme.scrollGripLightColor[Theme.style].getBrightness()));
            for (y = y1; y < y2; y += 2) {
                g.drawLine(5, y, 11, y);
            }
            g.setColor(SBChooser.getAdjustedColor(c, Theme.scrollGripDarkColor[Theme.style].getSaturation(), Theme.scrollGripDarkColor[Theme.style].getBrightness()));
            for (y = y1 + 1; y < y2; y += 2) {
                g.drawLine(6, y, 12, y);
            }
        } else {
            int x;
            int x1 = t.x + t.width / 2 - 4;
            x2 = Math.min(x1 + 8, t.x + t.width - 5);
            g.setColor(SBChooser.getAdjustedColor(c, Theme.scrollGripLightColor[Theme.style].getSaturation(), Theme.scrollGripLightColor[Theme.style].getBrightness()));
            for (x = x1 + 1; x < x2; x += 2) {
                g.drawLine(x, 5, x, 11);
            }
            g.setColor(SBChooser.getAdjustedColor(c, Theme.scrollGripDarkColor[Theme.style].getSaturation(), Theme.scrollGripDarkColor[Theme.style].getBrightness()));
            for (x = x1; x < x2; x += 2) {
                g.drawLine(x, 6, x, 12);
            }
        }
    }

    public boolean isThumbVisible() {
        if (this.scrollbar.getOrientation() == 1) {
            return this.getThumbBounds().height > 0;
        }
        return this.getThumbBounds().width > 0;
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    protected class OrientationChangeListener
    implements PropertyChangeListener {
        protected OrientationChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Integer orient = (Integer)e.getNewValue();
            if (TinyScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                if (TinyScrollBarUI.this.incrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.incrButton).setDirection(orient == 0 ? 3 : 5);
                }
                if (TinyScrollBarUI.this.decrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.decrButton).setDirection(orient == 0 ? 7 : 1);
                }
            } else {
                if (TinyScrollBarUI.this.incrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.incrButton).setDirection(orient == 0 ? 7 : 5);
                }
                if (TinyScrollBarUI.this.decrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.decrButton).setDirection(orient == 0 ? 3 : 1);
                }
            }
        }
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(TinyScrollBarUI.this);
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            TinyScrollBarUI.this.scrollbar.repaint();
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            TinyScrollBarUI.this.scrollbar.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            TinyScrollBarUI.this.isRollover = false;
            TinyScrollBarUI.this.wasRollover = false;
            if (TinyScrollBarUI.this.getThumbBounds().contains(e.getPoint())) {
                TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover = true;
                TinyScrollBarUI.this.scrollbar.repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            TinyScrollBarUI.this.isRollover = false;
            if (TinyScrollBarUI.this.isRollover != TinyScrollBarUI.this.wasRollover) {
                TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover;
                TinyScrollBarUI.this.scrollbar.repaint();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (TinyScrollBarUI.this.getThumbBounds().contains(e.getPoint())) {
                TinyScrollBarUI.this.isDragging = true;
            }
            super.mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            if (TinyScrollBarUI.this.getThumbBounds().contains(e.getPoint())) {
                TinyScrollBarUI.this.isRollover = true;
                if (TinyScrollBarUI.this.isRollover != TinyScrollBarUI.this.wasRollover) {
                    TinyScrollBarUI.this.scrollbar.repaint();
                    TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover;
                }
            } else {
                TinyScrollBarUI.this.isRollover = false;
                if (TinyScrollBarUI.this.isRollover != TinyScrollBarUI.this.wasRollover) {
                    TinyScrollBarUI.this.scrollbar.repaint();
                    TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover;
                }
            }
        }
    }
}

