/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyCheckBoxIcon;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.plaf.ColorUIResource;

class TinyRadioButtonIcon
extends TinyCheckBoxIcon {
    static HashMap cache = new HashMap();
    static final int[][] a = new int[][]{{255, 255, 255, 242, 228, 209, 187, 165, 142, 255, 255}, {255, 255, 242, 228, 209, 187, 165, 142, 120, 104, 255}, {255, 242, 228, 209, 187, 165, 142, 120, 104, 86, 72}, {242, 228, 209, 187, 165, 142, 120, 104, 86, 72, 56}, {228, 209, 187, 165, 142, 120, 104, 86, 72, 56, 42}, {209, 187, 165, 142, 120, 104, 86, 72, 56, 42, 28}, {187, 165, 142, 120, 104, 86, 72, 56, 42, 28, 17}, {165, 142, 120, 104, 86, 72, 56, 42, 28, 17, 9}, {142, 120, 104, 86, 72, 56, 42, 28, 17, 9, 0}, {255, 104, 86, 72, 56, 42, 28, 17, 9, 0, 255}, {255, 255, 72, 56, 42, 28, 17, 9, 0, 255, 255}};

    TinyRadioButtonIcon() {
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        AbstractButton button = (AbstractButton)c;
        ColorUIResource col = null;
        col = !button.isEnabled() ? Theme.buttonDisabledColor[Theme.style].getColor() : (button.getModel().isPressed() ? (button.getModel().isRollover() || button.getModel().isArmed() ? Theme.buttonPressedColor[Theme.style].getColor() : Theme.buttonNormalColor[Theme.style].getColor()) : (button.getModel().isRollover() && Theme.buttonRollover[Theme.style] ? Theme.buttonRolloverBgColor[Theme.style].getColor() : Theme.buttonNormalColor[Theme.style].getColor()));
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyRadio(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
                break;
            }
            case 1: {
                this.drawWinRadio(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
                break;
            }
            case 2: {
                if (TinyLookAndFeel.controlPanelInstantiated) {
                    this.drawXpRadioNoCache(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
                    break;
                }
                this.drawXpRadio(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
            }
        }
        if (!button.isSelected()) {
            return;
        }
        col = !button.isEnabled() ? Theme.buttonCheckDisabledColor[Theme.style].getColor() : Theme.buttonCheckColor[Theme.style].getColor();
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyCheckMark(g, col, x, y);
                break;
            }
            case 1: {
                this.drawWinCheckMark(g, col, x, y);
                break;
            }
            case 2: {
                this.drawXpCheckMark(g, col, x, y);
            }
        }
    }

    private void drawTinyRadio(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
    }

    private void drawWinRadio(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        if (b.getModel().isPressed() && b.getModel().isRollover()) {
            g.setColor(Theme.backColor[Theme.style].getColor());
        } else if (!b.isEnabled()) {
            g.setColor(Theme.buttonLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonLightColor[Theme.style].getColor());
        }
        g.fillRect(x + 2, y + 2, 8, 8);
        g.setColor(Theme.backColor[Theme.style].getColor());
        g.drawLine(x + 9, y + 3, x + 9, y + 3);
        g.drawLine(x + 10, y + 4, x + 10, y + 7);
        g.drawLine(x + 9, y + 8, x + 9, y + 8);
        g.drawLine(x + 8, y + 9, x + 9, y + 9);
        g.drawLine(x + 2, y + 9, x + 3, y + 9);
        g.drawLine(x + 4, y + 10, x + 7, y + 10);
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonLightColor[Theme.style].getColor());
        }
        g.drawLine(x + 10, y + 2, x + 10, y + 3);
        g.drawLine(x + 11, y + 4, x + 11, y + 7);
        g.drawLine(x + 10, y + 8, x + 10, y + 9);
        g.drawLine(x + 8, y + 10, x + 9, y + 10);
        g.drawLine(x + 4, y + 11, x + 7, y + 11);
        g.drawLine(x + 2, y + 10, x + 3, y + 10);
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonBorderDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonBorderColor[Theme.style].getColor());
        }
        g.drawLine(x + 4, y + 1, x + 7, y + 1);
        g.drawLine(x + 2, y + 2, x + 3, y + 2);
        g.drawLine(x + 8, y + 2, x + 9, y + 2);
        g.drawLine(x + 2, y + 3, x + 2, y + 3);
        g.drawLine(x + 1, y + 4, x + 1, y + 7);
        g.drawLine(x + 2, y + 8, x + 2, y + 8);
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonDarkDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonDarkColor[Theme.style].getColor());
        }
        g.drawLine(x + 4, y + 0, x + 7, y + 0);
        g.drawLine(x + 2, y + 1, x + 3, y + 1);
        g.drawLine(x + 8, y + 1, x + 9, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + 3);
        g.drawLine(x + 0, y + 4, x + 0, y + 7);
        g.drawLine(x + 1, y + 8, x + 1, y + 9);
    }

    private void drawXpRadio(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        RadioKey key;
        Object value;
        boolean pressed = b.getModel().isPressed();
        boolean armed = b.getModel().isArmed();
        boolean enabled = b.isEnabled();
        boolean rollover = b.getModel().isRollover();
        boolean focused = Theme.buttonFocusBorder[Theme.style] && !rollover && b.isFocusOwner();
        Color bg = b.getBackground();
        if (!b.isOpaque()) {
            Container parent;
            bg = parent.getBackground();
            for (parent = b.getParent(); parent != null && !parent.isOpaque(); parent = parent.getParent()) {
                bg = parent.getBackground();
            }
        }
        if ((value = cache.get(key = new RadioKey(c, bg, pressed, enabled, rollover || armed, focused))) != null) {
            g.drawImage((Image)value, x, y, b);
            return;
        }
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        imgGraphics.setColor(bg);
        imgGraphics.fillRect(0, 0, w, h);
        int spread1 = Theme.buttonSpreadLight[Theme.style];
        int spread2 = Theme.buttonSpreadDark[Theme.style];
        if (!enabled) {
            spread1 = Theme.buttonSpreadLightDisabled[Theme.style];
            spread2 = Theme.buttonSpreadDarkDisabled[Theme.style];
        }
        int spreadStep1 = spread1 * 5;
        int spreadStep2 = spread2 * 4;
        if (pressed && (rollover || armed)) {
            spreadStep2 *= 2;
        }
        c = ColorRoutines.lighten(c, spreadStep1);
        imgGraphics.setColor(ColorRoutines.darken(c, spreadStep2));
        imgGraphics.fillRect(2, 2, w - 4, h - 4);
        imgGraphics.fillRect(1, 5, 1, 3);
        imgGraphics.fillRect(11, 5, 1, 3);
        imgGraphics.fillRect(5, 1, 3, 1);
        imgGraphics.fillRect(5, 11, 3, 1);
        for (int row = 0; row < 11; ++row) {
            for (int col = 0; col < 11; ++col) {
                Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255 - a[col][row]);
                imgGraphics.setColor(color);
                imgGraphics.drawLine(col + 1, row + 1, col + 1, row + 1);
            }
        }
        if (!enabled) {
            DrawRoutines.drawXpRadioBorder(imgGraphics, Theme.buttonBorderDisabledColor[Theme.style].getColor(), 0, 0, w, h);
        } else {
            if (rollover && Theme.buttonRollover[Theme.style] && !pressed) {
                DrawRoutines.drawXpRadioRolloverBorder(imgGraphics, Theme.buttonRolloverColor[Theme.style].getColor(), 0, 0, w, h);
            } else if (focused && !pressed) {
                DrawRoutines.drawXpRadioRolloverBorder(imgGraphics, Theme.buttonDefaultColor[Theme.style].getColor(), 0, 0, w, h);
            }
            DrawRoutines.drawXpRadioBorder(imgGraphics, Theme.buttonBorderColor[Theme.style].getColor(), 0, 0, w, h);
        }
        imgGraphics.dispose();
        g.drawImage(img, x, y, b);
        cache.put(key, img);
    }

    private void drawXpRadioNoCache(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        boolean pressed = b.getModel().isPressed();
        boolean armed = b.getModel().isArmed();
        boolean enabled = b.isEnabled();
        boolean rollover = b.getModel().isRollover();
        boolean focused = Theme.buttonFocusBorder[Theme.style] && !rollover && b.isFocusOwner();
        boolean useCachedImage = !pressed && !armed && !rollover && !focused;
        BufferedImage img = null;
        Object key = null;
        if (useCachedImage) {
            key = enabled ? new EnabledRadioKey(c, Theme.buttonBorderColor[Theme.style].getColor()) : new DisabledRadioKey(c, Theme.buttonBorderDisabledColor[Theme.style].getColor());
            Object value = cache.get(key);
            if (value != null) {
                g.drawImage((Image)value, x, y, b);
                return;
            }
            img = new BufferedImage(w, h, 2);
        }
        int spread1 = Theme.buttonSpreadLight[Theme.style];
        int spread2 = Theme.buttonSpreadDark[Theme.style];
        if (!enabled) {
            spread1 = Theme.buttonSpreadLightDisabled[Theme.style];
            spread2 = Theme.buttonSpreadDarkDisabled[Theme.style];
        }
        int spreadStep1 = spread1 * 5;
        int spreadStep2 = spread2 * 4;
        if (pressed && (rollover || armed)) {
            spreadStep2 *= 2;
        }
        c = ColorRoutines.lighten(c, spreadStep1);
        Graphics graphics = null;
        int bx = x;
        int by = y;
        if (img != null) {
            graphics = ((Image)img).getGraphics();
            Color bg = b.getBackground();
            if (!b.isOpaque()) {
                Container parent;
                bg = parent.getBackground();
                for (parent = b.getParent(); parent != null && !parent.isOpaque(); parent = parent.getParent()) {
                    bg = parent.getBackground();
                }
            }
            graphics.setColor(bg);
            graphics.fillRect(0, 0, w - 1, h - 1);
            bx = 0;
            by = 0;
        } else {
            graphics = g;
            graphics.translate(x, y);
        }
        graphics.setColor(ColorRoutines.darken(c, spreadStep2));
        graphics.fillRect(2, 2, w - 4, h - 4);
        graphics.fillRect(1, 5, 1, 3);
        graphics.fillRect(11, 5, 1, 3);
        graphics.fillRect(6, 1, 1, 1);
        graphics.fillRect(6, 11, 1, 1);
        for (int row = 0; row < 11; ++row) {
            for (int col = 0; col < 11; ++col) {
                Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255 - a[col][row]);
                graphics.setColor(color);
                graphics.drawLine(col + 1, row + 1, col + 1, row + 1);
            }
        }
        if (img == null) {
            graphics.translate(-x, -y);
        }
        if (!enabled) {
            DrawRoutines.drawXpRadioBorder(graphics, Theme.buttonBorderDisabledColor[Theme.style].getColor(), bx, by, w, h);
        } else {
            if (rollover && Theme.buttonRollover[Theme.style] && !pressed) {
                DrawRoutines.drawXpRadioRolloverBorder(graphics, Theme.buttonRolloverColor[Theme.style].getColor(), bx, by, w, h);
            } else if (focused && !pressed) {
                DrawRoutines.drawXpRadioRolloverBorder(graphics, Theme.buttonDefaultColor[Theme.style].getColor(), bx, by, w, h);
            }
            DrawRoutines.drawXpRadioBorder(graphics, Theme.buttonBorderColor[Theme.style].getColor(), bx, by, w, h);
        }
        if (img != null) {
            graphics.dispose();
            g.drawImage(img, x, y, b);
            cache.put(key, img);
        }
    }

    private void drawTinyCheckMark(Graphics g, Color c, int x, int y) {
    }

    private void drawWinCheckMark(Graphics g, Color c, int x, int y) {
        g.fillRect(x + 4, y + 5, 4, 2);
        g.drawLine(x + 5, y + 4, x + 6, y + 4);
        g.drawLine(x + 5, y + 7, x + 6, y + 7);
    }

    private void drawXpCheckMark(Graphics g, Color c, int x, int y) {
        g.translate(x, y);
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 224));
        g.fillRect(5, 5, 3, 3);
        g.setColor(c);
        g.drawLine(6, 6, 6, 6);
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 192));
        g.drawLine(6, 4, 6, 4);
        g.drawLine(4, 6, 4, 6);
        g.drawLine(8, 6, 8, 6);
        g.drawLine(6, 8, 6, 8);
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 128));
        g.drawLine(5, 4, 5, 4);
        g.drawLine(7, 4, 7, 4);
        g.drawLine(4, 5, 4, 5);
        g.drawLine(8, 5, 8, 5);
        g.drawLine(4, 7, 4, 7);
        g.drawLine(8, 7, 8, 7);
        g.drawLine(5, 8, 5, 8);
        g.drawLine(7, 8, 7, 8);
        g.translate(-x, -y);
    }

    static class RadioKey {
        private Color c;
        private Color background;
        private boolean pressed;
        private boolean enabled;
        private boolean rollover;
        private boolean focused;

        RadioKey(Color c, Color background, boolean pressed, boolean enabled, boolean rollover, boolean focused) {
            this.c = c;
            this.background = background;
            this.pressed = pressed;
            this.enabled = enabled;
            this.rollover = rollover;
            this.focused = focused;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof RadioKey)) {
                return false;
            }
            RadioKey other = (RadioKey)o;
            return this.pressed == other.pressed && this.enabled == other.enabled && this.rollover == other.rollover && this.focused == other.focused && this.c.equals(other.c) && this.background.equals(other.background);
        }

        public int hashCode() {
            return this.c.hashCode() * this.background.hashCode() * (this.pressed ? 1 : 2) * (this.enabled ? 4 : 8) * (this.rollover ? 16 : 32);
        }
    }

    static class DisabledRadioKey {
        int spread1 = Theme.buttonSpreadLightDisabled[Theme.style];
        int spread2 = Theme.buttonSpreadDarkDisabled[Theme.style];
        Color c;
        Color back;

        DisabledRadioKey(Color c, Color back) {
            this.c = c;
            this.back = back;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof TinyCheckBoxIcon.DisabledCheckKey)) {
                return false;
            }
            TinyCheckBoxIcon.DisabledCheckKey other = (TinyCheckBoxIcon.DisabledCheckKey)o;
            return this.c.equals(other.c) && this.back.equals(other.back) && this.spread1 == other.spread1 && this.spread2 == other.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }

    static class EnabledRadioKey {
        int spread1 = Theme.buttonSpreadLight[Theme.style];
        int spread2 = Theme.buttonSpreadDark[Theme.style];
        Color c;
        Color back;

        EnabledRadioKey(Color c, Color back) {
            this.c = c;
            this.back = back;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof TinyCheckBoxIcon.EnabledCheckKey)) {
                return false;
            }
            TinyCheckBoxIcon.EnabledCheckKey other = (TinyCheckBoxIcon.EnabledCheckKey)o;
            return this.c.equals(other.c) && this.back.equals(other.back) && this.spread1 == other.spread1 && this.spread2 == other.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }
}

