/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.impl.jdbcjobstore;

import com.fr.third.org.quartz.impl.jdbcjobstore.DBSemaphore;
import com.fr.third.org.quartz.impl.jdbcjobstore.LockException;
import com.fr.third.org.quartz.impl.jdbcjobstore.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class UpdateLockRowSemaphore
extends DBSemaphore {
    public static final String UPDATE_FOR_LOCK = "UPDATE {0}LOCKS SET LOCK_NAME = LOCK_NAME WHERE LOCK_NAME = ? ";

    public UpdateLockRowSemaphore() {
        super("QRTZ_", null, UPDATE_FOR_LOCK);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeSQL(Connection conn, String lockName, String expandedSQL) throws LockException {
        PreparedStatement ps = null;
        try {
            try {
                int numUpdate;
                ps = conn.prepareStatement(expandedSQL);
                ps.setString(1, lockName);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName());
                }
                if ((numUpdate = ps.executeUpdate()) < 1) {
                    throw new SQLException(Util.rtp("No row exists in table {0}LOCKS for lock named: " + lockName, this.getTablePrefix()));
                }
                Object var7_7 = null;
                if (ps == null) return;
            }
            catch (SQLException sqle) {
                if (!this.getLog().isDebugEnabled()) throw new LockException("Failure obtaining db row lock: " + sqle.getMessage(), sqle);
                this.getLog().debug("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName());
                throw new LockException("Failure obtaining db row lock: " + sqle.getMessage(), sqle);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (ps == null) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        ps.close();
        return;
    }

    protected String getUpdateLockRowSQL() {
        return this.getSQL();
    }

    public void setUpdateLockRowSQL(String updateLockRowSQL) {
        this.setSQL(updateLockRowSQL);
    }
}

