/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.impl.calendar;

import com.fr.third.org.quartz.Calendar;
import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;

public class BaseCalendar
implements Calendar,
Serializable {
    static final long serialVersionUID = 3106623404629760239L;
    private Calendar baseCalendar;
    private String description;
    private TimeZone timeZone;

    public BaseCalendar() {
    }

    public BaseCalendar(Calendar baseCalendar) {
        this.setBaseCalendar(baseCalendar);
    }

    public BaseCalendar(TimeZone timeZone) {
        this.setTimeZone(timeZone);
    }

    public BaseCalendar(Calendar baseCalendar, TimeZone timeZone) {
        this.setBaseCalendar(baseCalendar);
        this.setTimeZone(timeZone);
    }

    public void setBaseCalendar(Calendar baseCalendar) {
        this.baseCalendar = baseCalendar;
    }

    public Calendar getBaseCalendar() {
        return this.baseCalendar;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isTimeIncluded(long timeStamp) {
        if (timeStamp <= 0L) {
            throw new IllegalArgumentException("timeStamp must be greater 0");
        }
        return this.baseCalendar == null || this.baseCalendar.isTimeIncluded(timeStamp);
    }

    public long getNextIncludedTime(long timeStamp) {
        if (timeStamp <= 0L) {
            throw new IllegalArgumentException("timeStamp must be greater 0");
        }
        if (this.baseCalendar != null) {
            return this.baseCalendar.getNextIncludedTime(timeStamp);
        }
        return timeStamp;
    }

    public static Date buildHoliday(Date excludedDate) {
        return new BaseCalendar().getStartOfDayJavaCalendar(excludedDate.getTime()).getTime();
    }

    public static long buildHoliday(long timeStamp) {
        return new BaseCalendar().getStartOfDayJavaCalendar(timeStamp).getTime().getTime();
    }

    public static java.util.Calendar getJavaCalendar(long timeStamp) {
        return new BaseCalendar().createJavaCalendar(timeStamp);
    }

    protected java.util.Calendar createJavaCalendar(long timeStamp) {
        java.util.Calendar calendar = this.createJavaCalendar();
        calendar.setTime(new Date(timeStamp));
        return calendar;
    }

    protected java.util.Calendar createJavaCalendar() {
        return this.getTimeZone() == null ? java.util.Calendar.getInstance() : java.util.Calendar.getInstance(this.getTimeZone());
    }

    protected java.util.Calendar getStartOfDayJavaCalendar(long timeInMillis) {
        java.util.Calendar startOfDay = this.createJavaCalendar(timeInMillis);
        startOfDay.set(11, 0);
        startOfDay.set(12, 0);
        startOfDay.set(13, 0);
        startOfDay.set(14, 0);
        return startOfDay;
    }

    protected java.util.Calendar getEndOfDayJavaCalendar(long timeInMillis) {
        java.util.Calendar endOfDay = this.createJavaCalendar(timeInMillis);
        endOfDay.set(11, 23);
        endOfDay.set(12, 59);
        endOfDay.set(13, 59);
        endOfDay.set(14, 999);
        return endOfDay;
    }
}

