/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz;

import com.fr.third.org.quartz.Calendar;
import com.fr.third.org.quartz.JobDataMap;
import com.fr.third.org.quartz.JobDetail;
import com.fr.third.org.quartz.JobListener;
import com.fr.third.org.quartz.SchedulerContext;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.SchedulerListener;
import com.fr.third.org.quartz.SchedulerMetaData;
import com.fr.third.org.quartz.Trigger;
import com.fr.third.org.quartz.TriggerListener;
import com.fr.third.org.quartz.UnableToInterruptJobException;
import com.fr.third.org.quartz.spi.JobFactory;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface Scheduler {
    public static final String DEFAULT_GROUP = "DEFAULT";
    public static final String DEFAULT_MANUAL_TRIGGERS = "MANUAL_TRIGGER";
    public static final String DEFAULT_RECOVERY_GROUP = "RECOVERING_JOBS";
    public static final String DEFAULT_FAIL_OVER_GROUP = "FAILED_OVER_JOBS";
    public static final String FAILED_JOB_ORIGINAL_TRIGGER_NAME = "QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME";
    public static final String FAILED_JOB_ORIGINAL_TRIGGER_GROUP = "QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP";
    public static final String FAILED_JOB_ORIGINAL_TRIGGER_FIRETIME_IN_MILLISECONDS = "QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING";

    public String getSchedulerName() throws SchedulerException;

    public String getSchedulerInstanceId() throws SchedulerException;

    public SchedulerContext getContext() throws SchedulerException;

    public void start() throws SchedulerException;

    public void startDelayed(int var1) throws SchedulerException;

    public boolean isStarted() throws SchedulerException;

    public void standby() throws SchedulerException;

    public void pause() throws SchedulerException;

    public boolean isInStandbyMode() throws SchedulerException;

    public boolean isPaused() throws SchedulerException;

    public void shutdown() throws SchedulerException;

    public void shutdown(boolean var1) throws SchedulerException;

    public boolean isShutdown() throws SchedulerException;

    public SchedulerMetaData getMetaData() throws SchedulerException;

    public List getCurrentlyExecutingJobs() throws SchedulerException;

    public void setJobFactory(JobFactory var1) throws SchedulerException;

    public Date scheduleJob(JobDetail var1, Trigger var2) throws SchedulerException;

    public Date scheduleJob(Trigger var1) throws SchedulerException;

    public boolean unscheduleJob(String var1, String var2) throws SchedulerException;

    public Date rescheduleJob(String var1, String var2, Trigger var3) throws SchedulerException;

    public void addJob(JobDetail var1, boolean var2) throws SchedulerException;

    public boolean deleteJob(String var1, String var2) throws SchedulerException;

    public void triggerJob(String var1, String var2) throws SchedulerException;

    public void triggerJobWithVolatileTrigger(String var1, String var2) throws SchedulerException;

    public void triggerJob(String var1, String var2, JobDataMap var3) throws SchedulerException;

    public void triggerJobWithVolatileTrigger(String var1, String var2, JobDataMap var3) throws SchedulerException;

    public void pauseJob(String var1, String var2) throws SchedulerException;

    public void pauseJobGroup(String var1) throws SchedulerException;

    public void pauseTrigger(String var1, String var2) throws SchedulerException;

    public void pauseTriggerGroup(String var1) throws SchedulerException;

    public void resumeJob(String var1, String var2) throws SchedulerException;

    public void resumeJobGroup(String var1) throws SchedulerException;

    public void resumeTrigger(String var1, String var2) throws SchedulerException;

    public void resumeTriggerGroup(String var1) throws SchedulerException;

    public void pauseAll() throws SchedulerException;

    public void resumeAll() throws SchedulerException;

    public String[] getJobGroupNames() throws SchedulerException;

    public String[] getJobNames(String var1) throws SchedulerException;

    public Trigger[] getTriggersOfJob(String var1, String var2) throws SchedulerException;

    public String[] getTriggerGroupNames() throws SchedulerException;

    public String[] getTriggerNames(String var1) throws SchedulerException;

    public Set getPausedTriggerGroups() throws SchedulerException;

    public JobDetail getJobDetail(String var1, String var2) throws SchedulerException;

    public Trigger getTrigger(String var1, String var2) throws SchedulerException;

    public int getTriggerState(String var1, String var2) throws SchedulerException;

    public void addCalendar(String var1, Calendar var2, boolean var3, boolean var4) throws SchedulerException;

    public boolean deleteCalendar(String var1) throws SchedulerException;

    public Calendar getCalendar(String var1) throws SchedulerException;

    public String[] getCalendarNames() throws SchedulerException;

    public boolean interrupt(String var1, String var2) throws UnableToInterruptJobException;

    public void addGlobalJobListener(JobListener var1) throws SchedulerException;

    public void addJobListener(JobListener var1) throws SchedulerException;

    public boolean removeGlobalJobListener(JobListener var1) throws SchedulerException;

    public boolean removeGlobalJobListener(String var1) throws SchedulerException;

    public boolean removeJobListener(String var1) throws SchedulerException;

    public List getGlobalJobListeners() throws SchedulerException;

    public Set getJobListenerNames() throws SchedulerException;

    public JobListener getGlobalJobListener(String var1) throws SchedulerException;

    public JobListener getJobListener(String var1) throws SchedulerException;

    public void addGlobalTriggerListener(TriggerListener var1) throws SchedulerException;

    public void addTriggerListener(TriggerListener var1) throws SchedulerException;

    public boolean removeGlobalTriggerListener(TriggerListener var1) throws SchedulerException;

    public boolean removeGlobalTriggerListener(String var1) throws SchedulerException;

    public boolean removeTriggerListener(String var1) throws SchedulerException;

    public List getGlobalTriggerListeners() throws SchedulerException;

    public Set getTriggerListenerNames() throws SchedulerException;

    public TriggerListener getGlobalTriggerListener(String var1) throws SchedulerException;

    public TriggerListener getTriggerListener(String var1) throws SchedulerException;

    public void addSchedulerListener(SchedulerListener var1) throws SchedulerException;

    public boolean removeSchedulerListener(SchedulerListener var1) throws SchedulerException;

    public List getSchedulerListeners() throws SchedulerException;
}

