/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz;

import com.fr.third.org.quartz.Calendar;
import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.JobExecutionException;
import com.fr.third.org.quartz.Trigger;
import java.text.NumberFormat;
import java.util.Date;
import java.util.TimeZone;

public class NthIncludedDayTrigger
extends Trigger {
    static final long serialVersionUID = 6267700049629328293L;
    public static final int MISFIRE_INSTRUCTION_FIRE_ONCE_NOW = 1;
    public static final int MISFIRE_INSTRUCTION_DO_NOTHING = 2;
    public static final int INTERVAL_TYPE_MONTHLY = 1;
    public static final int INTERVAL_TYPE_YEARLY = 2;
    public static final int INTERVAL_TYPE_WEEKLY = 3;
    private Date startTime = new Date();
    private Date endTime;
    private Date previousFireTime;
    private Date nextFireTime;
    private Calendar calendar;
    private int n = 1;
    private int intervalType = 1;
    private int fireAtHour = 12;
    private int fireAtMinute = 0;
    private int fireAtSecond = 0;
    private int nextFireCutoffInterval = 12;
    private TimeZone timeZone;

    public NthIncludedDayTrigger() {
    }

    public NthIncludedDayTrigger(String name, String group) {
        super(name, group);
    }

    public NthIncludedDayTrigger(String name, String group, String jobName, String jobGroup) {
        super(name, group, jobName, jobGroup);
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("N must be greater than 0.");
        }
        this.n = n;
    }

    public int getN() {
        return this.n;
    }

    public void setIntervalType(int intervalType) {
        switch (intervalType) {
            case 3: {
                this.intervalType = intervalType;
                break;
            }
            case 1: {
                this.intervalType = intervalType;
                break;
            }
            case 2: {
                this.intervalType = intervalType;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Interval Type:" + intervalType);
            }
        }
    }

    public int getIntervalType() {
        return this.intervalType;
    }

    public void setFireAtTime(String fireAtTime) {
        int newFireMinute;
        int newFireHour;
        int newFireSecond = 0;
        try {
            int i = fireAtTime.indexOf(":");
            newFireHour = Integer.parseInt(fireAtTime.substring(0, i));
            newFireMinute = Integer.parseInt(fireAtTime.substring(i + 1, i + 3));
            i = fireAtTime.indexOf(":", i + 1);
            if (i > -1) {
                newFireSecond = Integer.parseInt(fireAtTime.substring(i + 1));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse time expression '" + fireAtTime + "':" + e.getMessage());
        }
        if (newFireHour < 0 || newFireHour > 23) {
            throw new IllegalArgumentException("Could not parse time expression '" + fireAtTime + "':" + "fireAtHour must be between 0 and 23");
        }
        if (newFireMinute < 0 || newFireMinute > 59) {
            throw new IllegalArgumentException("Could not parse time expression '" + fireAtTime + "':" + "fireAtMinute must be between 0 and 59");
        }
        if (newFireSecond < 0 || newFireSecond > 59) {
            throw new IllegalArgumentException("Could not parse time expression '" + fireAtTime + "':" + "fireAtMinute must be between 0 and 59");
        }
        this.fireAtHour = newFireHour;
        this.fireAtMinute = newFireMinute;
        this.fireAtSecond = newFireSecond;
    }

    public String getFireAtTime() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumIntegerDigits(2);
        format.setMinimumIntegerDigits(2);
        format.setMaximumFractionDigits(0);
        return format.format(this.fireAtHour) + ":" + format.format(this.fireAtMinute) + ":" + format.format(this.fireAtSecond);
    }

    public void setNextFireCutoffInterval(int nextFireCutoffInterval) {
        this.nextFireCutoffInterval = nextFireCutoffInterval;
    }

    public int getNextFireCutoffInterval() {
        return this.nextFireCutoffInterval;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time may not be null");
        }
        if (this.endTime != null && this.endTime.before(startTime)) {
            throw new IllegalArgumentException("Start time must be before end time.");
        }
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Date endTime) {
        if (endTime != null && endTime.before(this.startTime)) {
            throw new IllegalArgumentException("End time must be after start time.");
        }
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public Date getFireTimeAfter(Date afterTime) {
        if (afterTime == null) {
            afterTime = new Date();
        }
        if (afterTime.before(this.startTime)) {
            afterTime = new Date(this.startTime.getTime() - 1000L);
        }
        if (this.intervalType == 3) {
            return this.getWeeklyFireTimeAfter(afterTime);
        }
        if (this.intervalType == 1) {
            return this.getMonthlyFireTimeAfter(afterTime);
        }
        if (this.intervalType == 2) {
            return this.getYearlyFireTimeAfter(afterTime);
        }
        return null;
    }

    public Date getFinalFireTime() {
        if (this.endTime == null) {
            return null;
        }
        Date finalTime = null;
        java.util.Calendar currCal = java.util.Calendar.getInstance();
        currCal.setTime(this.endTime);
        while (finalTime == null && this.startTime.before(currCal.getTime())) {
            currCal.add(5, -1);
            finalTime = this.getFireTimeAfter(currCal.getTime());
        }
        return finalTime;
    }

    public void triggered(Calendar calendar) {
        this.calendar = calendar;
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.calendar = calendar;
        this.nextFireTime = this.getFireTimeAfter(new Date(this.startTime.getTime() - 1000L));
        return this.nextFireTime;
    }

    public int executionComplete(JobExecutionContext jobCtx, JobExecutionException result) {
        if (result != null && result.refireImmediately()) {
            return 1;
        }
        if (result != null && result.unscheduleFiringTrigger()) {
            return 2;
        }
        if (result != null && result.unscheduleAllTriggers()) {
            return 4;
        }
        if (!this.mayFireAgain()) {
            return 3;
        }
        return 0;
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    protected boolean validateMisfireInstruction(int misfireInstruction) {
        return misfireInstruction == 0 || misfireInstruction == 2 || misfireInstruction == 1;
    }

    public void updateAfterMisfire(Calendar calendar) {
        int instruction = this.getMisfireInstruction();
        this.calendar = calendar;
        if (instruction == 0) {
            instruction = 1;
        }
        if (instruction == 2) {
            this.nextFireTime = this.getFireTimeAfter(new Date());
        } else if (instruction == 1) {
            this.nextFireTime = new Date();
        }
    }

    public void updateWithNewCalendar(Calendar calendar, long misfireThreshold) {
        long diff;
        Date now = new Date();
        this.calendar = calendar;
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
        if (this.nextFireTime != null && this.nextFireTime.before(now) && (diff = now.getTime() - this.nextFireTime.getTime()) >= misfireThreshold) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    private Date getWeeklyFireTimeAfter(Date afterDate) {
        int currN = 0;
        int weekCount = 0;
        boolean gotOne = false;
        java.util.Calendar afterCal = java.util.Calendar.getInstance(this.getTimeZone());
        afterCal.setTime(afterDate);
        java.util.Calendar currCal = java.util.Calendar.getInstance(this.getTimeZone());
        currCal.set(afterCal.get(1), afterCal.get(2), afterCal.get(5));
        while (currCal.get(7) != currCal.getFirstDayOfWeek()) {
            currCal.add(5, -1);
        }
        currCal.set(11, this.fireAtHour);
        currCal.set(12, this.fireAtMinute);
        currCal.set(13, this.fireAtSecond);
        currCal.set(14, 0);
        int currWeek = currCal.get(3);
        while (!gotOne && weekCount < this.nextFireCutoffInterval) {
            while (currN != this.n && weekCount < 12) {
                if (currCal.get(3) != currWeek) {
                    currN = 0;
                    ++weekCount;
                    currWeek = currCal.get(3);
                }
                if (this.calendar == null || this.calendar.isTimeIncluded(currCal.getTime().getTime())) {
                    ++currN;
                }
                if (currN != this.n) {
                    currCal.add(5, 1);
                }
                if (this.endTime == null || !currCal.getTime().after(this.endTime)) continue;
                return null;
            }
            if (currN != this.n) continue;
            if (afterDate.before(currCal.getTime())) {
                gotOne = true;
                continue;
            }
            while (currCal.get(7) != currCal.getFirstDayOfWeek()) {
                currCal.add(5, -1);
            }
            currCal.add(5, 7);
            currN = 0;
        }
        if (weekCount < this.nextFireCutoffInterval) {
            return currCal.getTime();
        }
        return null;
    }

    private Date getMonthlyFireTimeAfter(Date afterDate) {
        int currN = 0;
        int monthCount = 0;
        boolean gotOne = false;
        java.util.Calendar afterCal = java.util.Calendar.getInstance(this.getTimeZone());
        afterCal.setTime(afterDate);
        java.util.Calendar currCal = java.util.Calendar.getInstance(this.getTimeZone());
        currCal.set(afterCal.get(1), afterCal.get(2), 1);
        currCal.set(11, this.fireAtHour);
        currCal.set(12, this.fireAtMinute);
        currCal.set(13, this.fireAtSecond);
        currCal.set(14, 0);
        int currMonth = currCal.get(2);
        while (!gotOne && monthCount < this.nextFireCutoffInterval) {
            while (currN != this.n && monthCount < 12) {
                if (currCal.get(2) != currMonth) {
                    currN = 0;
                    ++monthCount;
                    currMonth = currCal.get(2);
                }
                if (this.calendar == null || this.calendar.isTimeIncluded(currCal.getTime().getTime())) {
                    ++currN;
                }
                if (currN != this.n) {
                    currCal.add(5, 1);
                }
                if (this.endTime == null || !currCal.getTime().after(this.endTime)) continue;
                return null;
            }
            if (currN != this.n) continue;
            if (afterDate.before(currCal.getTime())) {
                gotOne = true;
                continue;
            }
            currCal.set(5, 1);
            currCal.add(2, 1);
            currN = 0;
        }
        if (monthCount < this.nextFireCutoffInterval) {
            return currCal.getTime();
        }
        return null;
    }

    private Date getYearlyFireTimeAfter(Date afterDate) {
        int currN = 0;
        int yearCount = 0;
        boolean gotOne = false;
        java.util.Calendar afterCal = java.util.Calendar.getInstance(this.getTimeZone());
        afterCal.setTime(afterDate);
        java.util.Calendar currCal = java.util.Calendar.getInstance(this.getTimeZone());
        currCal.set(afterCal.get(1), 0, 1);
        currCal.set(11, this.fireAtHour);
        currCal.set(12, this.fireAtMinute);
        currCal.set(13, this.fireAtSecond);
        currCal.set(14, 0);
        int currYear = currCal.get(1);
        while (!gotOne && yearCount < this.nextFireCutoffInterval) {
            while (currN != this.n && yearCount < 5) {
                if (currCal.get(1) != currYear) {
                    currN = 0;
                    ++yearCount;
                    currYear = currCal.get(1);
                }
                if (this.calendar == null || this.calendar.isTimeIncluded(currCal.getTime().getTime())) {
                    ++currN;
                }
                if (currN != this.n) {
                    currCal.add(5, 1);
                }
                if (this.endTime == null || !currCal.getTime().after(this.endTime)) continue;
                return null;
            }
            if (currN != this.n) continue;
            if (afterDate.before(currCal.getTime())) {
                gotOne = true;
                continue;
            }
            currCal.set(5, 1);
            currCal.set(2, 0);
            currCal.add(1, 1);
            currN = 0;
        }
        if (yearCount < this.nextFireCutoffInterval) {
            return currCal.getTime();
        }
        return null;
    }
}

