/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.util;

import com.fr.third.org.hsqldb.util.CommonSwing;
import com.fr.third.org.hsqldb.util.DatabaseManagerSwing;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class FontDialogSwing
extends JDialog {
    private static boolean isRunning = false;
    private static final String BACKGROUND = "Background";
    private static String defaultFont = "Dialog";
    private static final String FOREGROUND = "Foreground";
    private static JButton bgColorButton;
    private static JCheckBox ckbbold;
    private static JButton closeButton;
    private static JButton fgColorButton;
    private static JComboBox fontsComboBox;
    private static JComboBox fontSizesComboBox;
    private static final String[] fontSizes;
    private static DatabaseManagerSwing fOwner;
    private static JFrame frame;
    private static JCheckBox ckbitalic;

    public static void creatFontDialog(DatabaseManagerSwing owner) {
        if (isRunning) {
            frame.setVisible(true);
        } else {
            CommonSwing.setSwingLAF(frame, CommonSwing.Native);
            fOwner = owner;
            frame.setIconImage(CommonSwing.getIcon("Frame"));
            isRunning = true;
            frame.setSize(600, 100);
            CommonSwing.setFramePositon(frame);
            ckbitalic = new JCheckBox(new ImageIcon(CommonSwing.getIcon("ItalicFont")));
            ckbitalic.putClientProperty("is3DEnabled", Boolean.TRUE);
            ckbitalic.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FontDialogSwing.setStyle();
                }
            });
            ckbbold = new JCheckBox(new ImageIcon(CommonSwing.getIcon("BoldFont")));
            ckbbold.putClientProperty("is3DEnabled", Boolean.TRUE);
            ckbbold.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FontDialogSwing.setStyle();
                }
            });
            fgColorButton = new JButton(FOREGROUND, new ImageIcon(CommonSwing.getIcon("ColorSelection")));
            fgColorButton.putClientProperty("is3DEnabled", Boolean.TRUE);
            fgColorButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FontDialogSwing.setColor(FontDialogSwing.FOREGROUND);
                }
            });
            bgColorButton = new JButton(BACKGROUND, new ImageIcon(CommonSwing.getIcon("ColorSelection")));
            bgColorButton.putClientProperty("is3DEnabled", Boolean.TRUE);
            bgColorButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FontDialogSwing.setColor(FontDialogSwing.BACKGROUND);
                }
            });
            closeButton = new JButton("Close", new ImageIcon(CommonSwing.getIcon("Close")));
            closeButton.putClientProperty("is3DEnabled", Boolean.TRUE);
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    frame.setVisible(false);
                }
            });
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] fontNames = ge.getAvailableFontFamilyNames();
            Dimension fontsComboBoxDimension = new Dimension(160, 25);
            fontsComboBox = new JComboBox<String>(fontNames);
            fontsComboBox.putClientProperty("is3DEnabled", Boolean.TRUE);
            fontsComboBox.setMaximumSize(fontsComboBoxDimension);
            fontsComboBox.setPreferredSize(fontsComboBoxDimension);
            fontsComboBox.setMaximumSize(fontsComboBoxDimension);
            fontsComboBox.setEditable(false);
            fontsComboBox.setSelectedItem(defaultFont);
            fontsComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FontDialogSwing.setFont();
                }
            });
            fontSizesComboBox = new JComboBox<String>(fontSizes);
            Dimension spinnerDimension = new Dimension(45, 25);
            fontSizesComboBox.putClientProperty("is3DEnabled", Boolean.TRUE);
            fontSizesComboBox.setMinimumSize(spinnerDimension);
            fontSizesComboBox.setPreferredSize(spinnerDimension);
            fontSizesComboBox.setMaximumSize(spinnerDimension);
            fontSizesComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        FontDialogSwing.setFontSize((String)evt.getItem());
                    }
                }
            });
            Container contentPane = frame.getContentPane();
            contentPane.setLayout(new FlowLayout());
            contentPane.add(fontsComboBox);
            contentPane.add(fontSizesComboBox);
            contentPane.add(ckbbold);
            contentPane.add(ckbitalic);
            contentPane.add(fgColorButton);
            contentPane.add(bgColorButton);
            contentPane.add(closeButton);
            frame.pack();
            frame.setVisible(false);
        }
    }

    public static void setFont() {
        Font txtResultFont = FontDialogSwing.fOwner.txtResult.getFont();
        FontDialogSwing.fOwner.txtResult.setFont(new Font(fontsComboBox.getSelectedItem().toString(), txtResultFont.getStyle(), txtResultFont.getSize()));
        Font txtCommandFont = FontDialogSwing.fOwner.txtResult.getFont();
        FontDialogSwing.fOwner.txtCommand.setFont(new Font(fontsComboBox.getSelectedItem().toString(), txtCommandFont.getStyle(), txtCommandFont.getSize()));
        Font txtTreeFont = FontDialogSwing.fOwner.txtResult.getFont();
        FontDialogSwing.fOwner.tTree.setFont(new Font(fontsComboBox.getSelectedItem().toString(), txtTreeFont.getStyle(), txtTreeFont.getSize()));
    }

    public static void setFontSize(String inFontSize) {
        Float stageFloat = new Float(inFontSize);
        float fontSize = stageFloat.floatValue();
        Font fonttTree = FontDialogSwing.fOwner.tTree.getFont().deriveFont(fontSize);
        FontDialogSwing.fOwner.tTree.setFont(fonttTree);
        Font fontTxtCommand = FontDialogSwing.fOwner.txtCommand.getFont().deriveFont(fontSize);
        FontDialogSwing.fOwner.txtCommand.setFont(fontTxtCommand);
        Font fontTxtResult = FontDialogSwing.fOwner.txtResult.getFont().deriveFont(fontSize);
        FontDialogSwing.fOwner.txtResult.setFont(fontTxtResult);
    }

    public static void setStyle() {
        int style = 0;
        if (ckbbold.isSelected()) {
            style |= 1;
        }
        if (ckbitalic.isSelected()) {
            style |= 2;
        }
        FontDialogSwing.fOwner.tTree.setFont(FontDialogSwing.fOwner.txtCommand.getFont().deriveFont(style));
        FontDialogSwing.fOwner.txtCommand.setFont(FontDialogSwing.fOwner.txtCommand.getFont().deriveFont(style));
        FontDialogSwing.fOwner.txtResult.setFont(FontDialogSwing.fOwner.txtResult.getFont().deriveFont(style));
    }

    public static void setColor(String inTarget) {
        if (inTarget.equals(BACKGROUND)) {
            Color backgroundColor = JColorChooser.showDialog(null, "DataBaseManagerSwing Choose Background Color", FontDialogSwing.fOwner.txtResult.getBackground());
            if (backgroundColor != null) {
                bgColorButton.setBackground(backgroundColor);
                FontDialogSwing.fOwner.txtCommand.setBackground(backgroundColor);
                FontDialogSwing.fOwner.txtResult.setBackground(backgroundColor);
            }
        } else {
            Color foregroundColor = JColorChooser.showDialog(null, "DataBaseManagerSwing Choose Foreground Color", FontDialogSwing.fOwner.txtResult.getForeground());
            if (foregroundColor != null) {
                fgColorButton.setBackground(foregroundColor);
                FontDialogSwing.fOwner.txtCommand.setForeground(foregroundColor);
                FontDialogSwing.fOwner.txtResult.setForeground(foregroundColor);
            }
        }
    }

    static {
        fontSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "24", "36"};
        frame = new JFrame("DataBaseManagerSwing Font Selection Dialog");
    }
}

