/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.types;

import com.fr.third.org.hsqldb.lib.ArrayUtil;
import com.fr.third.org.hsqldb.lib.StringConverter;

public class Binary {
    private byte[] data;
    int hash;

    public Binary(byte[] data, boolean clone) {
        if (clone) {
            data = (byte[])ArrayUtil.duplicateArray(data);
        }
        this.data = data;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public byte[] getClonedBytes() {
        return (byte[])this.data.clone();
    }

    public int getBytesLength() {
        return this.data.length;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Binary)) {
            return false;
        }
        if (this.data.length != ((Binary)other).data.length) {
            return false;
        }
        return ArrayUtil.containsAt(this.data, 0, ((Binary)other).data);
    }

    public int hashCode() {
        int h = 0;
        if (this.hash == 0) {
            for (int i = 0; i < this.data.length; ++i) {
                h = 31 * h + this.data[i];
            }
            this.hash = h;
        }
        return this.hash;
    }

    public String toString() {
        return StringConverter.byteToHex(this.data);
    }
}

