/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.scriptio;

import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.NumberSequence;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.scriptio.ScriptReaderBinary;
import com.fr.third.org.hsqldb.scriptio.ScriptReaderText;
import com.fr.third.org.hsqldb.scriptio.ScriptReaderZipped;
import java.io.IOException;

public abstract class ScriptReaderBase {
    public static final int ANY_STATEMENT = 1;
    public static final int DELETE_STATEMENT = 2;
    public static final int INSERT_STATEMENT = 3;
    public static final int SEQUENCE_STATEMENT = 4;
    public static final int COMMIT_STATEMENT = 5;
    public static final int SESSION_ID = 6;
    public static final int SCHEMA_STATEMENT = 7;
    Database db;
    int lineCount;
    String fileName;
    int statementType;
    int sessionNumber;
    Object[] rowData;
    long sequenceValue;
    String statement;
    Table currentTable;
    NumberSequence currentSequence;
    String currentSchema;

    public static ScriptReaderBase newScriptReader(Database db, String file, int scriptType) throws HsqlException, IOException {
        if (scriptType == 0) {
            return new ScriptReaderText(db, file);
        }
        if (scriptType == 1) {
            return new ScriptReaderBinary(db, file);
        }
        return new ScriptReaderZipped(db, file);
    }

    ScriptReaderBase(Database db, String file) throws HsqlException, IOException {
        this.db = db;
        this.fileName = file;
        this.openFile();
    }

    protected abstract void openFile() throws IOException;

    public void readAll(Session session) throws IOException, HsqlException {
        this.readDDL(session);
        this.readExistingData(session);
    }

    protected abstract void readDDL(Session var1) throws IOException, HsqlException;

    protected abstract void readExistingData(Session var1) throws IOException, HsqlException;

    public abstract boolean readLoggedStatement(Session var1) throws IOException;

    public int getStatementType() {
        return this.statementType;
    }

    public int getSessionNumber() {
        return this.sessionNumber;
    }

    public Object[] getData() {
        return this.rowData;
    }

    public String getLoggedStatement() {
        return this.statement;
    }

    public NumberSequence getCurrentSequence() {
        return this.currentSequence;
    }

    public long getSequenceValue() {
        return this.sequenceValue;
    }

    public Table getCurrentTable() {
        return this.currentTable;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public int getLineNumber() {
        return this.lineCount;
    }

    public abstract void close();
}

