/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.rowio;

import com.fr.third.org.hsqldb.CachedRow;
import com.fr.third.org.hsqldb.Column;
import com.fr.third.org.hsqldb.HsqlDateTime;
import com.fr.third.org.hsqldb.lib.StringConverter;
import com.fr.third.org.hsqldb.rowio.RowOutputBase;
import com.fr.third.org.hsqldb.types.Binary;
import com.fr.third.org.hsqldb.types.JavaObject;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class RowOutputTextLog
extends RowOutputBase {
    static final byte[] BYTES_NULL = "NULL".getBytes();
    static final byte[] BYTES_TRUE = "TRUE".getBytes();
    static final byte[] BYTES_FALSE = "FALSE".getBytes();
    static final byte[] BYTES_AND = " AND ".getBytes();
    static final byte[] BYTES_IS = " IS ".getBytes();
    public static final int MODE_DELETE = 1;
    public static final int MODE_INSERT = 0;
    private boolean isWritten;
    private int logMode;

    public void setMode(int mode) {
        this.logMode = mode;
    }

    protected void writeFieldPrefix() {
        if (this.logMode == 1 && this.isWritten) {
            this.write(BYTES_AND);
        }
    }

    protected void writeChar(String s, int t) {
        this.write(39);
        StringConverter.unicodeToAscii(this, s, true);
        this.write(39);
    }

    protected void writeReal(Double o, int type) {
        this.writeBytes(Column.createSQLString(o));
    }

    protected void writeSmallint(Number o) {
        this.writeBytes(o.toString());
    }

    public void writeEnd() {
    }

    protected void writeTime(Time o) {
        this.write(39);
        this.writeBytes(o.toString());
        this.write(39);
    }

    protected void writeBinary(Binary o, int t) {
        this.ensureRoom(o.getBytesLength() * 2 + 2);
        this.write(39);
        StringConverter.writeHex(this.getBuffer(), this.count, o.getBytes());
        this.count += o.getBytesLength() * 2;
        this.write(39);
    }

    public void writeType(int type) {
    }

    public void writeSize(int size) {
    }

    protected void writeDate(Date o) {
        this.write(39);
        this.writeBytes(o.toString());
        this.write(39);
    }

    public int getSize(CachedRow row) {
        return 0;
    }

    protected void writeInteger(Number o) {
        this.writeBytes(o.toString());
    }

    protected void writeBigint(Number o) {
        this.writeBytes(o.toString());
    }

    protected void writeNull(int type) {
        if (this.logMode == 1) {
            this.write(BYTES_IS);
        } else if (this.isWritten) {
            this.write(44);
        }
        this.isWritten = true;
        this.write(BYTES_NULL);
    }

    protected void writeOther(JavaObject o) {
        this.ensureRoom(o.getBytesLength() * 2 + 2);
        this.write(39);
        StringConverter.writeHex(this.getBuffer(), this.count, o.getBytes());
        this.count += o.getBytesLength() * 2;
        this.write(39);
    }

    public void writeString(String value) {
        StringConverter.unicodeToAscii(this, value, false);
    }

    protected void writeBit(Boolean o) {
        this.write(o != false ? BYTES_TRUE : BYTES_FALSE);
    }

    protected void writeDecimal(BigDecimal o) {
        this.writeBytes(o.toString());
    }

    protected void writeFieldType(int type) {
        if (this.logMode == 1) {
            this.write(61);
        } else if (this.isWritten) {
            this.write(44);
        }
        this.isWritten = true;
    }

    public void writeLongData(long value) {
        this.writeBytes(Long.toString(value));
    }

    public void writeIntData(int i, int position) {
    }

    protected void writeTimestamp(Timestamp o) {
        this.write(39);
        this.writeBytes(HsqlDateTime.getTimestampString(o));
        this.write(39);
    }

    public void writeShortData(short i) {
        this.writeBytes(Integer.toString(i));
    }

    public void writeIntData(int i) {
        this.writeBytes(Integer.toString(i));
    }

    public void reset() {
        super.reset();
        this.isWritten = false;
    }
}

