/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.rowio;

import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.rowio.RowInputText;
import java.io.IOException;

public class RowInputTextQuoted
extends RowInputText {
    private static final int NORMAL_FIELD = 0;
    private static final int NEED_END_QUOTE = 1;
    private static final int FOUND_QUOTE = 2;
    private char[] qtext;

    public RowInputTextQuoted(String fieldSep, String varSep, String longvarSep, boolean allQuoted) {
        super(fieldSep, varSep, longvarSep, allQuoted);
    }

    public void setSource(String text, int pos, int byteSize) {
        super.setSource(text, pos, byteSize);
        this.qtext = text.toCharArray();
    }

    protected String getField(String sep, int sepLen, boolean isEnd) throws IOException {
        String s = null;
        if (this.next >= this.qtext.length || this.qtext[this.next] != '\"') {
            return super.getField(sep, sepLen, isEnd);
        }
        try {
            ++this.field;
            StringBuffer ret = new StringBuffer();
            boolean done = false;
            int state = 0;
            int end = -1;
            if (!isEnd) {
                end = this.text.indexOf(sep, this.next);
            }
            while (this.next < this.qtext.length) {
                switch (state) {
                    default: {
                        if (this.next == end) {
                            this.next += sepLen;
                            done = true;
                            break;
                        }
                        if (this.qtext[this.next] == '\"') {
                            state = 1;
                            break;
                        }
                        ret.append(this.qtext[this.next]);
                        break;
                    }
                    case 1: {
                        if (this.qtext[this.next] == '\"') {
                            state = 2;
                            break;
                        }
                        ret.append(this.qtext[this.next]);
                        break;
                    }
                    case 2: {
                        if (this.qtext[this.next] == '\"') {
                            ret.append(this.qtext[this.next]);
                            state = 1;
                            break;
                        }
                        this.next += sepLen - 1;
                        state = 0;
                        if (isEnd) break;
                        ++this.next;
                        done = true;
                    }
                }
                if (done) break;
                ++this.next;
            }
            s = ret.toString();
        }
        catch (Exception e) {
            throw new IOException(Trace.getMessage(181, true, new Object[]{new Integer(this.field), e.toString()}));
        }
        return s;
    }
}

