/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.rowio;

import com.fr.third.org.hsqldb.Column;
import com.fr.third.org.hsqldb.HsqlDateTime;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.rowio.RowInputBase;
import com.fr.third.org.hsqldb.rowio.RowInputInterface;
import com.fr.third.org.hsqldb.types.Binary;
import com.fr.third.org.hsqldb.types.JavaObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class RowInputText
extends RowInputBase
implements RowInputInterface {
    private String fieldSep;
    private String varSep;
    private String longvarSep;
    private int fieldSepLen;
    private int varSepLen;
    private int longvarSepLen;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private int textLen;
    protected String text;
    protected int line;
    protected int field;
    protected int next = 0;
    protected boolean allQuoted;

    public RowInputText(String fieldSep, String varSep, String longvarSep, boolean allQuoted) {
        super(new byte[0]);
        if (fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            fieldSep = fieldSep.substring(0, fieldSep.length() - 1);
        }
        if (varSep.endsWith("\n")) {
            this.varSepEnd = true;
            varSep = varSep.substring(0, varSep.length() - 1);
        }
        if (longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            longvarSep = longvarSep.substring(0, longvarSep.length() - 1);
        }
        this.allQuoted = allQuoted;
        this.fieldSep = fieldSep;
        this.varSep = varSep;
        this.longvarSep = longvarSep;
        this.fieldSepLen = fieldSep.length();
        this.varSepLen = varSep.length();
        this.longvarSepLen = longvarSep.length();
    }

    public void setSource(String text, int pos, int byteSize) {
        this.size = byteSize;
        this.text = text;
        this.textLen = text.length();
        this.filePos = pos;
        this.next = 0;
        ++this.line;
        this.field = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getField(String sep, int sepLen, boolean isEnd) throws IOException {
        String s = null;
        try {
            int start = this.next;
            ++this.field;
            if (isEnd) {
                if (this.next >= this.textLen && sepLen > 0) {
                    throw Trace.error(182);
                }
                if (!this.text.endsWith(sep)) throw Trace.error(183);
                this.next = this.textLen - sepLen;
            } else {
                this.next = this.text.indexOf(sep, start);
                if (this.next == -1) {
                    this.next = this.textLen;
                }
            }
            if (start > this.next) {
                start = this.next;
            }
            s = this.text.substring(start, this.next);
            this.next += sepLen;
            if ((s = s.trim()).length() != 0) return s;
            return null;
        }
        catch (Exception e) {
            throw new IOException(Trace.getMessage(184, true, new Object[]{new Integer(this.field), e.toString()}));
        }
    }

    public String readString() throws IOException {
        return this.getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
    }

    private String readVarString() throws IOException {
        return this.getField(this.varSep, this.varSepLen, this.varSepEnd);
    }

    private String readLongVarString() throws IOException {
        return this.getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
    }

    public short readShortData() throws IOException {
        return (short)this.readIntData();
    }

    public int readIntData() throws IOException {
        String s = this.readString();
        if (s == null) {
            return 0;
        }
        if ((s = s.trim()).length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public long readLongData() throws IOException {
        throw Trace.runtimeError(201, "RowInputText");
    }

    public int readType() throws IOException {
        return 0;
    }

    protected boolean checkNull() {
        return false;
    }

    protected String readChar(int type) throws IOException {
        switch (type) {
            case 1: {
                return this.readString();
            }
            case 12: 
            case 100: {
                return this.readVarString();
            }
        }
        return this.readLongVarString();
    }

    protected Integer readSmallint() throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Integer.valueOf(s);
    }

    protected Integer readInteger() throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Integer.valueOf(s);
    }

    protected Long readBigint() throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Long.valueOf(s);
    }

    protected Double readReal(int type) throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Double.valueOf(s);
    }

    protected BigDecimal readDecimal() throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return new BigDecimal(s);
    }

    protected Time readTime() throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return HsqlDateTime.timeValue(s);
    }

    protected Date readDate() throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return HsqlDateTime.dateValue(s);
    }

    protected Timestamp readTimestamp() throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return HsqlDateTime.timestampValue(s);
    }

    protected Boolean readBit() throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object readOther() throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        byte[] data = Column.hexToByteArray(s);
        return new JavaObject(data);
    }

    protected Binary readBinary(int type) throws IOException, HsqlException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return new Binary(Column.hexToByteArray(s), false);
    }

    public int getLineNumber() {
        return this.line;
    }

    public void skippedLine() {
        ++this.line;
    }

    public void reset() {
        this.text = "";
        this.textLen = 0;
        this.filePos = 0;
        this.next = 0;
        this.field = 0;
        this.line = 0;
    }
}

