/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.rowio;

import com.fr.third.org.hsqldb.HsqlDateTime;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.lib.StringConverter;
import com.fr.third.org.hsqldb.rowio.RowInputBase;
import com.fr.third.org.hsqldb.rowio.RowInputInterface;
import com.fr.third.org.hsqldb.rowio.RowOutputBinary;
import com.fr.third.org.hsqldb.store.ValuePool;
import com.fr.third.org.hsqldb.types.Binary;
import com.fr.third.org.hsqldb.types.JavaObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class RowInputBinary
extends RowInputBase
implements RowInputInterface {
    private RowOutputBinary out;

    public RowInputBinary() {
    }

    public RowInputBinary(byte[] buf) {
        super(buf);
    }

    public RowInputBinary(RowOutputBinary out) {
        super(out.getBuffer());
        this.out = out;
    }

    protected byte[] readByteArray() throws IOException {
        byte[] b = new byte[this.readInt()];
        this.readFully(b);
        return b;
    }

    public int readType() throws IOException {
        return this.readShort();
    }

    public short readShortData() throws IOException {
        return this.readShort();
    }

    public int readIntData() throws IOException {
        return this.readInt();
    }

    public long readLongData() throws IOException {
        return this.readLong();
    }

    public String readString() throws IOException {
        int length = this.readInt();
        String s = StringConverter.readUTF(this.buffer, this.pos, length);
        s = ValuePool.getString(s);
        this.pos += length;
        return s;
    }

    protected boolean checkNull() throws IOException {
        byte b = this.readByte();
        return b == 0;
    }

    protected String readChar(int type) throws IOException {
        return this.readString();
    }

    protected Integer readSmallint() throws IOException, HsqlException {
        return ValuePool.getInt(this.readShort());
    }

    protected Integer readInteger() throws IOException, HsqlException {
        return ValuePool.getInt(this.readInt());
    }

    protected Long readBigint() throws IOException, HsqlException {
        return ValuePool.getLong(this.readLong());
    }

    protected Double readReal(int type) throws IOException, HsqlException {
        return ValuePool.getDouble(this.readLong());
    }

    protected BigDecimal readDecimal() throws IOException, HsqlException {
        byte[] bytes = this.readByteArray();
        int scale = this.readInt();
        BigInteger bigint = new BigInteger(bytes);
        return ValuePool.getBigDecimal(new BigDecimal(bigint, scale));
    }

    protected Boolean readBit() throws IOException, HsqlException {
        return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Time readTime() throws IOException, HsqlException {
        return new Time(HsqlDateTime.getNormalisedTime(this.readLong()));
    }

    protected Date readDate() throws IOException, HsqlException {
        long date = HsqlDateTime.getNormalisedDate(this.readLong());
        return ValuePool.getDate(date);
    }

    protected Timestamp readTimestamp() throws IOException, HsqlException {
        return HsqlDateTime.timestampValue(this.readLong(), this.readInt());
    }

    protected Object readOther() throws IOException, HsqlException {
        return new JavaObject(this.readByteArray());
    }

    protected Binary readBinary(int type) throws IOException, HsqlException {
        return new Binary(this.readByteArray(), false);
    }

    public void resetRow(int rowsize) {
        if (this.out != null) {
            this.out.reset(rowsize);
            this.buffer = this.out.getBuffer();
        }
        super.reset();
    }

    public void resetRow(int filepos, int rowsize) throws IOException {
        if (this.out != null) {
            this.out.reset(rowsize);
            this.buffer = this.out.getBuffer();
        }
        super.resetRow(filepos, rowsize);
    }
}

