/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.persist;

import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.Result;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.lib.IntKeyHashMap;
import com.fr.third.org.hsqldb.lib.StopWatch;
import com.fr.third.org.hsqldb.scriptio.ScriptReaderBase;
import java.io.EOFException;

public class ScriptRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScript(Database database, String logFilename, int logType) throws HsqlException {
        Session sysSession;
        IntKeyHashMap sessionMap = new IntKeyHashMap();
        Session current = sysSession = database.getSessionManager().getSysSession();
        int currentId = 0;
        database.setReferentialIntegrity(false);
        ScriptReaderBase scr = null;
        try {
            try {
                StopWatch sw = new StopWatch();
                scr = ScriptReaderBase.newScriptReader(database, logFilename, logType);
                while (scr.readLoggedStatement(current)) {
                    int sessionId = scr.getSessionNumber();
                    if (currentId != sessionId && (current = (Session)sessionMap.get(currentId = sessionId)) == null) {
                        current = database.getSessionManager().newSession(database, sysSession.getUser(), false, true);
                        sessionMap.put(currentId, current);
                    }
                    if (current.isClosed()) {
                        sessionMap.remove(currentId);
                        continue;
                    }
                    Result result = null;
                    switch (scr.getStatementType()) {
                        case 1: {
                            result = current.sqlExecuteDirectNoPreChecks(scr.getLoggedStatement());
                            if (result == null || !result.isError()) break;
                            if (result.getException() != null) {
                                throw result.getException();
                            }
                            throw Trace.error(result);
                        }
                        case 4: {
                            scr.getCurrentSequence().reset(scr.getSequenceValue());
                            break;
                        }
                        case 5: {
                            current.commit();
                            break;
                        }
                        case 3: {
                            Object[] data = scr.getData();
                            scr.getCurrentTable().insertNoCheckFromLog(current, data);
                            break;
                        }
                        case 2: {
                            Object[] data = scr.getData();
                            scr.getCurrentTable().deleteNoCheckFromLog(current, data);
                            break;
                        }
                        case 7: {
                            current.setSchema(scr.getCurrentSchema());
                        }
                    }
                    if (!current.isClosed()) continue;
                    sessionMap.remove(currentId);
                }
                Object var13_15 = null;
                if (scr != null) {
                    scr.close();
                }
                database.getSessionManager().closeAllSessions();
                database.setReferentialIntegrity(true);
            }
            catch (Throwable e) {
                if (!(e instanceof EOFException)) {
                    if (e instanceof OutOfMemoryError) {
                        String message = "out of memory processing " + logFilename + " line: " + scr.getLineNumber();
                        database.logger.appLog.logContext(1, message);
                        throw Trace.error(72);
                    }
                    String message = logFilename + " line: " + scr.getLineNumber() + " " + e.toString();
                    database.logger.appLog.logContext(1, message);
                }
                Object var13_16 = null;
                if (scr != null) {
                    scr.close();
                }
                database.getSessionManager().closeAllSessions();
                database.setReferentialIntegrity(true);
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (scr != null) {
                scr.close();
            }
            database.getSessionManager().closeAllSessions();
            database.setReferentialIntegrity(true);
            throw throwable;
        }
    }
}

