/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.persist;

import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.NumberSequence;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.lib.SimpleLog;
import com.fr.third.org.hsqldb.persist.DataFileCache;
import com.fr.third.org.hsqldb.persist.LockFile;
import com.fr.third.org.hsqldb.persist.Log;

public class Logger {
    public SimpleLog appLog = new SimpleLog(null, 0, false);
    private Log log;
    private LockFile lockFile;
    boolean needsCheckpoint;
    private boolean logStatements;
    private boolean syncFile = false;

    public void openLog(Database db) throws HsqlException {
        this.needsCheckpoint = false;
        String path = db.getPath();
        int loglevel = db.getProperties().getIntegerProperty("hsqldb.applog", 0);
        if (loglevel != 0) {
            this.appLog = new SimpleLog(path + ".app.log", loglevel, !db.isFilesReadOnly());
        }
        this.appLog.sendLine(1, "Database (re)opened");
        this.logStatements = false;
        boolean useLock = db.getProperties().isPropertyTrue("hsqldb.lock_file");
        if (useLock && !db.isFilesReadOnly()) {
            this.acquireLock(path);
        }
        this.log = new Log(db);
        this.log.open();
        this.logStatements = !db.isFilesReadOnly();
    }

    public boolean closeLog(int closemode) {
        if (this.log == null) {
            return true;
        }
        try {
            switch (closemode) {
                case -1: {
                    this.log.shutdown();
                    break;
                }
                case 0: {
                    this.log.close(false);
                    break;
                }
                case 1: 
                case 2: {
                    this.log.close(true);
                }
            }
        }
        catch (Throwable e) {
            this.appLog.logContext(e, "error closing log");
            this.appLog.close();
            this.log = null;
            return false;
        }
        this.appLog.sendLine(1, "Database closed");
        this.appLog.close();
        this.log = null;
        return true;
    }

    public boolean hasLog() {
        return this.log != null;
    }

    public DataFileCache getCache() throws HsqlException {
        if (this.log == null) {
            return null;
        }
        return this.log.getCache();
    }

    public boolean hasCache() {
        if (this.log == null) {
            return false;
        }
        return this.log.hasCache();
    }

    public synchronized void logConnectUser(Session session) throws HsqlException {
        if (this.logStatements) {
            this.writeToLog(session, session.getUser().getConnectStatement());
        }
    }

    public synchronized void writeToLog(Session session, String statement) throws HsqlException {
        if (this.logStatements && this.log != null) {
            this.log.writeStatement(session, statement);
        }
    }

    public synchronized void writeInsertStatement(Session session, Table table, Object[] row) throws HsqlException {
        if (this.logStatements) {
            this.log.writeInsertStatement(session, table, row);
        }
    }

    public synchronized void writeDeleteStatement(Session session, Table t, Object[] row) throws HsqlException {
        if (this.logStatements) {
            this.log.writeDeleteStatement(session, t, row);
        }
    }

    public synchronized void writeSequenceStatement(Session session, NumberSequence s) throws HsqlException {
        if (this.logStatements) {
            this.log.writeSequenceStatement(session, s);
        }
    }

    public synchronized void writeCommitStatement(Session session) throws HsqlException {
        if (this.logStatements) {
            this.log.writeCommitStatement(session);
            this.synchLog();
        }
    }

    public synchronized void synchLog() {
        if (this.logStatements && this.syncFile) {
            this.log.synchLog();
        }
    }

    public synchronized void synchLogForce() {
        if (this.logStatements) {
            this.log.synchLog();
        }
    }

    public synchronized void checkpoint(boolean mode) throws HsqlException {
        if (this.logStatements) {
            this.appLog.logContext(2, "start");
            this.needsCheckpoint = false;
            this.log.checkpoint(mode);
            this.appLog.logContext(2, "end");
        }
    }

    public synchronized void setLogSize(int megas) {
        if (this.log != null) {
            this.log.setLogSize(megas);
        }
    }

    public synchronized void setScriptType(int i) throws HsqlException {
        if (this.log != null) {
            this.log.setScriptType(i);
        }
    }

    public synchronized void setWriteDelay(int delay) {
        if (this.log != null) {
            this.syncFile = delay == 0;
            this.log.setWriteDelay(delay);
        }
    }

    public int getWriteDelay() {
        return this.log != null ? this.log.getWriteDelay() : 0;
    }

    public int getLogSize() {
        return this.log != null ? this.log.getLogSize() : 0;
    }

    public int getScriptType() {
        return this.log != null ? this.log.getScriptType() : 0;
    }

    public synchronized void setIncrementalBackup(boolean val) throws HsqlException {
        if (this.log != null) {
            this.log.setIncrementalBackup(val);
        }
    }

    public DataFileCache openTextCache(Table table, String source, boolean readOnlyData, boolean reversed) throws HsqlException {
        return this.log.openTextCache(table, source, readOnlyData, reversed);
    }

    public void closeTextCache(Table table) throws HsqlException {
        this.log.closeTextCache(table);
    }

    public boolean needsCheckpoint() {
        return this.needsCheckpoint;
    }

    public void acquireLock(String path) throws HsqlException {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = LockFile.newLockFileLock(path);
    }

    public void releaseLock() {
        block3: {
            try {
                if (this.lockFile != null) {
                    this.lockFile.tryRelease();
                }
            }
            catch (Exception e) {
                if (!Trace.TRACE) break block3;
                Trace.printSystemOut(e.toString());
            }
        }
        this.lockFile = null;
    }
}

