/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.persist;

import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.lib.ObjectComparator;
import com.fr.third.org.hsqldb.lib.Sort;
import com.fr.third.org.hsqldb.lib.StopWatch;
import com.fr.third.org.hsqldb.persist.CachedObject;
import com.fr.third.org.hsqldb.persist.DataFileCache;
import com.fr.third.org.hsqldb.store.ObjectCacheHashMap;
import java.io.IOException;

public class Cache {
    final DataFileCache dataFileCache;
    private int capacity;
    private long bytesCapacity;
    private final CachedObjectComparator rowComparator;
    private CachedObject[] rowTable;
    private final ObjectCacheHashMap cacheMap;
    long cacheBytesLength;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch makeRowTimer = new StopWatch(false);
    StopWatch sortTimer = new StopWatch(false);
    int makeRowCount = 0;
    int saveRowCount = 0;

    Cache(DataFileCache dfc) {
        this.dataFileCache = dfc;
        this.capacity = dfc.capacity();
        this.bytesCapacity = dfc.bytesCapacity();
        this.rowComparator = new CachedObjectComparator();
        this.rowTable = new CachedObject[this.capacity];
        this.cacheMap = new ObjectCacheHashMap(this.capacity);
        this.cacheBytesLength = 0L;
    }

    void init(int capacity, long bytesCapacity) {
    }

    int size() {
        return this.cacheMap.size();
    }

    long getTotalCachedBlockSize() {
        return this.cacheBytesLength;
    }

    synchronized CachedObject get(int pos) {
        return (CachedObject)this.cacheMap.get(pos);
    }

    synchronized void put(int key, CachedObject row) throws IOException {
        int storageSize = row.getStorageSize();
        if (this.cacheMap.size() >= this.capacity || (long)storageSize + this.cacheBytesLength > this.bytesCapacity) {
            this.cleanUp();
        }
        this.cacheMap.put(key, row);
        this.cacheBytesLength += (long)storageSize;
    }

    synchronized CachedObject release(int i) {
        CachedObject r = (CachedObject)this.cacheMap.remove(i);
        if (r == null) {
            return null;
        }
        this.cacheBytesLength -= (long)r.getStorageSize();
        return r;
    }

    private synchronized void cleanUp() throws IOException {
        int removeCount = this.cacheMap.size() / 2;
        int accessTarget = this.cacheMap.getAccessCountCeiling(removeCount, removeCount / 8);
        ObjectCacheHashMap.ObjectCacheIterator it = this.cacheMap.iterator();
        int savecount = 0;
        while (it.hasNext()) {
            CachedObject r = (CachedObject)it.next();
            if (it.getAccessCount() > accessTarget || r.isKeepInMemory()) continue;
            if (r.hasChanged()) {
                this.rowTable[savecount++] = r;
            }
            it.remove();
            this.cacheBytesLength -= (long)r.getStorageSize();
        }
        this.cacheMap.setAccessCountFloor(accessTarget);
        this.saveRows(savecount);
    }

    private synchronized void saveRows(int count) throws IOException {
        if (count == 0) {
            return;
        }
        this.rowComparator.setType(1);
        this.sortTimer.start();
        Sort.sort(this.rowTable, this.rowComparator, 0, count - 1);
        this.sortTimer.stop();
        this.saveAllTimer.start();
        this.dataFileCache.saveRows(this.rowTable, 0, count);
        this.saveRowCount += count;
        this.saveAllTimer.stop();
    }

    synchronized void saveAll() throws IOException {
        ObjectCacheHashMap.ObjectCacheIterator it = this.cacheMap.iterator();
        int savecount = 0;
        while (it.hasNext()) {
            CachedObject r = (CachedObject)it.next();
            if (!r.hasChanged()) continue;
            this.rowTable[savecount++] = r;
        }
        this.saveRows(savecount);
        Trace.printSystemOut(this.saveAllTimer.elapsedTimeToMessage("Cache.saveRow() total row save time"));
        Trace.printSystemOut("Cache.saveRow() total row save count = " + this.saveRowCount);
        Trace.printSystemOut(this.makeRowTimer.elapsedTimeToMessage("Cache.makeRow() total row load time"));
        Trace.printSystemOut("Cache.makeRow() total row load count = " + this.makeRowCount);
        Trace.printSystemOut(this.sortTimer.elapsedTimeToMessage("Cache.sort() total time"));
    }

    synchronized void clear() {
        this.cacheMap.clear();
        this.cacheBytesLength = 0L;
    }

    static class CachedObjectComparator
    implements ObjectComparator {
        static final int COMPARE_LAST_ACCESS = 0;
        static final int COMPARE_POSITION = 1;
        static final int COMPARE_SIZE = 2;
        private int compareType;

        CachedObjectComparator() {
        }

        void setType(int type) {
            this.compareType = type;
        }

        public int compare(Object a, Object b) {
            switch (this.compareType) {
                case 1: {
                    return ((CachedObject)a).getPos() - ((CachedObject)b).getPos();
                }
                case 2: {
                    return ((CachedObject)a).getStorageSize() - ((CachedObject)b).getStorageSize();
                }
            }
            return 0;
        }
    }
}

