/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.lib;

import com.fr.third.org.hsqldb.HsqlDateTime;
import com.fr.third.org.hsqldb.lib.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class SimpleLog {
    public static final int LOG_NONE = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_NORMAL = 2;
    private PrintWriter writer;
    private int level;
    private boolean isSystem;

    public SimpleLog(String path, int level, boolean useFile) {
        this.level = level;
        if (level != 0) {
            if (useFile) {
                File file = new File(path);
                this.makeLog(file);
            } else {
                this.isSystem = true;
                this.writer = new PrintWriter(System.out);
            }
        }
    }

    private void makeLog(File file) {
        try {
            FileUtil.getDefaultInstance().makeParentDirectories(file);
            this.writer = new PrintWriter((Writer)new FileWriter(file.getPath(), true), true);
        }
        catch (Exception e) {
            this.isSystem = true;
            this.writer = new PrintWriter(System.out);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public synchronized void sendLine(int atLevel, String message) {
        if (this.level >= atLevel) {
            this.writer.println(HsqlDateTime.getSytemTimeString() + " " + message);
        }
    }

    public synchronized void logContext(int atLevel, String message) {
        if (this.level < atLevel) {
            return;
        }
        String info = HsqlDateTime.getSytemTimeString();
        Throwable temp = new Throwable();
        StackTraceElement[] elements = temp.getStackTrace();
        if (elements.length > 1) {
            info = info + " " + elements[1].getClassName() + "." + elements[1].getMethodName();
        }
        this.writer.println(info + " " + message);
    }

    public synchronized void logContext(Throwable t, String message) {
        if (this.level == 0) {
            return;
        }
        String info = HsqlDateTime.getSytemTimeString();
        Throwable temp = new Throwable();
        StackTraceElement[] elements = temp.getStackTrace();
        if (elements.length > 1) {
            info = info + " " + elements[1].getClassName() + "." + elements[1].getMethodName();
        }
        if ((elements = t.getStackTrace()).length > 0) {
            info = info + " " + elements[0].getClassName() + "." + elements[0].getMethodName();
        }
        if (message == null) {
            message = "";
        }
        this.writer.println(info + " " + t.toString() + " " + message);
    }

    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() {
        if (this.writer != null && !this.isSystem) {
            this.writer.close();
        }
        this.writer = null;
    }
}

