/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.lib;

import com.fr.third.org.hsqldb.lib.BaseList;
import com.fr.third.org.hsqldb.lib.HsqlList;

public class HsqlLinkedList
extends BaseList
implements HsqlList {
    private Node first;
    private Node last;

    public HsqlLinkedList() {
        this.last = this.first = new Node(null, null);
        this.elementCount = 0;
    }

    public void add(int index, Object element) {
        if (index == this.size()) {
            this.add(element);
        } else {
            if (index > this.size()) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + index + " > " + this.size());
            }
            Node current = this.getInternal(index);
            Node newNext = new Node(current.data, current.next);
            current.data = element;
            current.next = newNext;
            ++this.elementCount;
            if (this.last == current) {
                this.last = newNext;
            }
        }
    }

    public boolean add(Object element) {
        this.last = this.last.next = new Node(element, null);
        ++this.elementCount;
        return true;
    }

    public void clear() {
        this.first.next = null;
    }

    public Object get(int index) {
        return this.getInternal((int)index).data;
    }

    public Object remove(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.size());
        }
        Node previousToRemove = index == 0 ? this.first : this.getInternal(index - 1);
        Node toRemove = previousToRemove.next;
        previousToRemove.next = toRemove.next;
        --this.elementCount;
        if (this.last == toRemove) {
            this.last = previousToRemove;
        }
        return toRemove.data;
    }

    public Object set(int index, Object element) {
        Node setMe = this.getInternal(index);
        Object oldData = setMe.data;
        setMe.data = element;
        return oldData;
    }

    public final int size() {
        return this.elementCount;
    }

    protected final Node getInternal(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.size());
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        if (index == 0) {
            return this.first.next;
        }
        if (index == this.size() - 1) {
            return this.last;
        }
        Node pointer = this.first.next;
        for (int i = 0; i < index; ++i) {
            pointer = pointer.next;
        }
        return pointer;
    }

    private static class Node {
        public Node next;
        public Object data;

        public Node() {
            this.next = null;
            this.data = null;
        }

        public Node(Object data) {
            this.next = null;
            this.data = data;
        }

        public Node(Object data, Node next) {
            this.next = next;
            this.data = data;
        }
    }
}

