/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.lib;

import com.fr.third.org.hsqldb.lib.FileAccess;
import com.fr.third.org.hsqldb.lib.java.JavaSystem;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class FileUtil
implements FileAccess {
    private static FileUtil fileUtil = new FileUtil();
    public final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
    final Random random = new Random(System.currentTimeMillis());

    FileUtil() {
    }

    public static FileUtil getDefaultInstance() {
        return fileUtil;
    }

    public boolean isStreamElement(String elementName) {
        return new File(elementName).exists();
    }

    public InputStream openInputStreamElement(String streamName) throws IOException {
        try {
            return new FileInputStream(new File(streamName));
        }
        catch (Throwable e) {
            throw FileUtil.toIOException(e);
        }
    }

    public void createParentDirs(String filename) {
        this.makeParentDirectories(new File(filename));
    }

    public void removeElement(String filename) {
        if (this.isStreamElement(filename)) {
            this.delete(filename);
        }
    }

    public void renameElement(String oldName, String newName) {
        this.renameOverwrite(oldName, newName);
    }

    public OutputStream openOutputStreamElement(String streamName) throws IOException {
        return new FileOutputStream(new File(streamName));
    }

    public boolean delete(String filename) {
        return new File(filename).delete();
    }

    public void deleteOnExit(File f) {
        JavaSystem.deleteOnExit(f);
    }

    public boolean exists(String filename) {
        return new File(filename).exists();
    }

    public boolean exists(String fileName, boolean resource, Class cla) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        return resource ? null != cla.getResource(fileName) : FileUtil.getDefaultInstance().exists(fileName);
    }

    private boolean renameOverwrite(String oldname, String newname) {
        boolean deleted = this.delete(newname);
        if (this.exists(oldname)) {
            File file = new File(oldname);
            return file.renameTo(new File(newname));
        }
        return deleted;
    }

    public static IOException toIOException(Throwable e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e.toString());
    }

    public String absolutePath(String path) {
        return new File(path).getAbsolutePath();
    }

    public File canonicalFile(File f) throws IOException {
        return new File(f.getCanonicalPath());
    }

    public File canonicalFile(String path) throws IOException {
        return new File(new File(path).getCanonicalPath());
    }

    public String canonicalPath(File f) throws IOException {
        return f.getCanonicalPath();
    }

    public String canonicalPath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    public String canonicalOrAbsolutePath(String path) {
        try {
            return this.canonicalPath(path);
        }
        catch (Exception e) {
            return this.absolutePath(path);
        }
    }

    public void makeParentDirectories(File f) {
        String parent = f.getParent();
        if (parent != null) {
            new File(parent).mkdirs();
        } else {
            parent = f.getPath();
            int index = parent.lastIndexOf(47);
            if (index > 0) {
                parent = parent.substring(0, index);
                new File(parent).mkdirs();
            }
        }
    }

    public FileAccess.FileSync getFileSync(OutputStream os) throws IOException {
        return new FileSync((FileOutputStream)os);
    }

    public class FileSync
    implements FileAccess.FileSync {
        FileDescriptor outDescriptor;

        FileSync(FileOutputStream os) throws IOException {
            this.outDescriptor = os.getFD();
        }

        public void sync() throws IOException {
            this.outDescriptor.sync();
        }
    }
}

