/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.jdbc;

import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.Result;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.jdbc.Util;
import com.fr.third.org.hsqldb.jdbc.jdbcConnection;
import com.fr.third.org.hsqldb.jdbc.jdbcResultSet;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class jdbcStatement
implements Statement {
    volatile boolean isClosed;
    private boolean isEscapeProcessing = true;
    protected jdbcConnection connection;
    protected int maxRows;
    protected Result resultIn;
    protected int rsType = 1003;
    protected Result resultOut = new Result(65547);
    protected Result batchResultOut = null;

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(sql);
        return new jdbcResultSet(this, this.resultIn, this.connection.connProperties, this.connection.isNetConn);
    }

    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(sql);
        if (this.resultIn == null || this.resultIn.isData()) {
            throw new SQLException(Trace.getMessage(142));
        }
        if (this.resultIn.isError()) {
            Util.throwError(this.resultIn);
        }
        return this.resultIn.getUpdateCount();
    }

    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.batchResultOut = null;
        this.connection = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw Util.sqlException(62);
        }
    }

    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw Util.sqlException(62);
        }
        this.maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.isEscapeProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0) {
            throw Util.sqlException(62);
        }
    }

    public void cancel() throws SQLException {
        this.checkClosed();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(sql);
        return this.resultIn.isData();
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.resultIn == null || !this.resultIn.isData() ? null : new jdbcResultSet(this, this.resultIn, this.connection.connProperties, this.connection.isNetConn);
    }

    public int getUpdateCount() throws SQLException {
        return this.resultIn == null || this.resultIn.isData() ? -1 : this.resultIn.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        this.resultIn = null;
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000) {
            throw Util.notSupported();
        }
    }

    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        if (this.isEscapeProcessing) {
            sql = this.connection.nativeSQL(sql);
        }
        if (this.batchResultOut == null) {
            this.batchResultOut = new Result(8, new int[]{12}, 0);
        }
        this.batchResultOut.add(new Object[]{sql});
    }

    public void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.batchResultOut != null) {
            this.batchResultOut.clear();
        }
    }

    public int[] executeBatch() throws SQLException {
        int[] updateCounts;
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        if (this.batchResultOut == null) {
            this.batchResultOut = new Result(8, new int[]{12}, 0);
        }
        int batchCount = this.batchResultOut.getSize();
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.batchResultOut);
        }
        catch (HsqlException e) {
            this.batchResultOut.clear();
            throw Util.sqlException(e);
        }
        this.batchResultOut.clear();
        if (this.resultIn.isError()) {
            Util.throwError(this.resultIn);
        }
        if ((updateCounts = this.resultIn.getUpdateCounts()).length != batchCount) {
            throw new BatchUpdateException("failed batch", updateCounts);
        }
        return updateCounts;
    }

    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw Util.notSupported();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw Util.notSupported();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Util.notSupported();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Util.notSupported();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Util.notSupported();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw Util.notSupported();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Util.notSupported();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Util.notSupported();
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    jdbcStatement(jdbcConnection c, int type) {
        this.connection = c;
        this.rsType = type;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.sqlException(126);
        }
        if (this.connection.isClosed) {
            throw Util.sqlException(2);
        }
    }

    private void fetchResult(String sql) throws SQLException {
        if (this.isEscapeProcessing) {
            sql = this.connection.nativeSQL(sql);
        }
        this.resultIn = null;
        this.resultOut.setMainString(sql);
        this.resultOut.setMaxRows(this.maxRows);
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
            if (this.resultIn.isError()) {
                throw new HsqlException(this.resultIn);
            }
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }
}

