/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.Row;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Table;

class Transaction {
    boolean isDelete;
    Table tTable;
    Row row;
    long SCN;

    Transaction(boolean delete, Table table, Row row, long SCN) {
        this.isDelete = delete;
        this.tTable = table;
        this.row = row;
    }

    void rollback(Session session, boolean log) {
        try {
            if (this.isDelete) {
                this.tTable.insertNoCheckRollback(session, this.row, log);
            } else {
                this.tTable.deleteNoCheckRollback(session, this.row, log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void commit(Session session) {
        try {
            if (this.isDelete) {
                this.tTable.removeRowFromStore(this.row);
            } else {
                this.tTable.commitRowToStore(this.row);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void logRollback(Session session) {
        try {
            if (this.isDelete) {
                this.tTable.database.logger.writeInsertStatement(session, this.tTable, this.row.getData());
            } else {
                this.tTable.database.logger.writeDeleteStatement(session, this.tTable, this.row.getData());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void logAction(Session session) {
        try {
            if (this.isDelete) {
                this.tTable.database.logger.writeDeleteStatement(session, this.tTable, this.row.getData());
            } else {
                this.tTable.database.logger.writeInsertStatement(session, this.tTable, this.row.getData());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

