/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.HsqlNameManager;
import com.fr.third.org.hsqldb.NumberSequence;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.lib.HashMappedList;
import com.fr.third.org.hsqldb.persist.Logger;

public class SequenceManager {
    HashMappedList sequenceMap = new HashMappedList();

    SequenceManager() {
    }

    void dropSequence(String name) throws HsqlException {
        boolean found = this.sequenceMap.containsKey(name);
        Trace.check(found, 191, name);
        this.sequenceMap.remove(name);
    }

    public NumberSequence getSequence(String name) {
        return (NumberSequence)this.sequenceMap.get(name);
    }

    NumberSequence createSequence(HsqlNameManager.HsqlName hsqlname, long start, long increment, int type) throws HsqlException {
        Trace.check(!this.sequenceMap.containsKey(hsqlname.name), 192);
        NumberSequence sequence = new NumberSequence(hsqlname, start, increment, type);
        this.sequenceMap.put(hsqlname.name, sequence);
        return sequence;
    }

    String logSequences(Session c, Logger logger) throws HsqlException {
        for (int i = 0; i < this.sequenceMap.size(); ++i) {
            NumberSequence seq = (NumberSequence)this.sequenceMap.get(i);
            if (!seq.wasUsed()) continue;
            logger.writeSequenceStatement(c, seq);
            seq.resetWasUsed();
        }
        return null;
    }
}

