/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.CachedRow;
import com.fr.third.org.hsqldb.DiskNode;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.MemoryNode;
import com.fr.third.org.hsqldb.PointerNode;
import com.fr.third.org.hsqldb.Row;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.rowio.RowInputInterface;
import com.fr.third.org.hsqldb.rowio.RowOutputInterface;
import java.io.IOException;

abstract class Node {
    static final int NO_POS = -1;
    int iBalance;
    Node nNext;

    Node() {
    }

    static final Node newNode(Row r, int id, Table t) {
        switch (t.getIndexType()) {
            case 0: {
                return new MemoryNode(r);
            }
            case 2: {
                return new PointerNode((CachedRow)r, id);
            }
        }
        return new DiskNode((CachedRow)r, id);
    }

    static final Node newNode(Row r, RowInputInterface in, int id, Table t) throws IOException, HsqlException {
        switch (t.getIndexType()) {
            case 0: {
                return new MemoryNode(r);
            }
            case 2: {
                return new PointerNode((CachedRow)r, id);
            }
        }
        return new DiskNode((CachedRow)r, in, id);
    }

    abstract void delete();

    abstract int getKey();

    abstract Row getRow() throws HsqlException;

    abstract boolean isLeft(Node var1) throws HsqlException;

    abstract boolean isRight(Node var1) throws HsqlException;

    abstract Node getLeft() throws HsqlException;

    abstract void setLeft(Node var1) throws HsqlException;

    abstract Node getRight() throws HsqlException;

    abstract void setRight(Node var1) throws HsqlException;

    abstract Node getParent() throws HsqlException;

    abstract void setParent(Node var1) throws HsqlException;

    final int getBalance() throws HsqlException {
        return this.iBalance;
    }

    abstract void setBalance(int var1) throws HsqlException;

    abstract boolean isRoot();

    abstract boolean isFromLeft() throws HsqlException;

    abstract Object[] getData() throws HsqlException;

    abstract boolean equals(Node var1);

    Node getUpdatedNode() throws HsqlException {
        return this;
    }

    abstract void write(RowOutputInterface var1) throws IOException;

    boolean isDeleted() {
        return this.iBalance == -2;
    }
}

