/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.Collation;
import com.fr.third.org.hsqldb.Column;
import com.fr.third.org.hsqldb.Constraint;
import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.HsqlNameManager;
import com.fr.third.org.hsqldb.Node;
import com.fr.third.org.hsqldb.Row;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.index.RowIterator;
import com.fr.third.org.hsqldb.lib.ArrayUtil;
import java.util.NoSuchElementException;

public class Index {
    static final int MEMORY_INDEX = 0;
    static final int DISK_INDEX = 1;
    static final int POINTER_INDEX = 2;
    private final HsqlNameManager.HsqlName indexName;
    final boolean[] colCheck;
    final int[] colIndex;
    private final int[] colTypes;
    final int[] pkCols;
    final int[] pkTypes;
    private final boolean isUnique;
    private final boolean useRowId;
    final boolean isConstraint;
    final boolean isForward;
    final boolean isTemp;
    private Node root;
    private int depth;
    final Collation collation;
    static IndexRowIterator emptyIterator = new IndexRowIterator(null, null, null);
    IndexRowIterator updatableIterators;
    final boolean onCommitPreserve;
    final Table table;

    Index(Database database, HsqlNameManager.HsqlName name, Table table, int[] column, int[] colTypes, boolean isPk, boolean unique, boolean constraint, boolean forward, int[] pkcols, int[] pktypes, boolean temp) {
        this.table = table;
        this.indexName = name;
        this.colIndex = column;
        this.colTypes = colTypes;
        this.pkCols = pkcols;
        this.pkTypes = pktypes;
        this.isUnique = unique;
        this.isConstraint = constraint;
        this.isForward = forward;
        this.useRowId = !this.isUnique && this.pkCols.length == 0 || this.colIndex.length == 0;
        this.colCheck = table.getNewColumnCheckList();
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
        this.updatableIterators.next = this.updatableIterators.last = (this.updatableIterators = new IndexRowIterator(null, null, null));
        this.collation = database.collation;
        this.isTemp = temp;
        this.onCommitPreserve = table.onCommitPreserve;
    }

    HsqlNameManager.HsqlName getName() {
        return this.indexName;
    }

    void setName(String name, boolean isquoted) throws HsqlException {
        this.indexName.rename(name, isquoted);
    }

    int getVisibleColumns() {
        return this.colIndex.length;
    }

    boolean isUnique() {
        return this.isUnique;
    }

    boolean isConstraint() {
        return this.isConstraint;
    }

    int[] getColumns() {
        return this.colIndex;
    }

    int[] getColumnTypes() {
        return this.colTypes;
    }

    String getColumnNameList() {
        String columnNameList = "";
        for (int j = 0; j < this.colIndex.length; ++j) {
            columnNameList = columnNameList + this.table.getColumn((int)this.colIndex[j]).columnName.statementName;
            if (j >= this.colIndex.length - 1) continue;
            columnNameList = columnNameList + ",";
        }
        return columnNameList;
    }

    int size(Session session) throws HsqlException {
        int count = 0;
        RowIterator it = this.firstRow(session);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    boolean isEmpty(Session session) {
        return this.getRoot(session) == null;
    }

    public int sizeEstimate() throws HsqlException {
        this.firstRow(null);
        return (int)(1L << this.depth);
    }

    void clearAll(Session session) {
        this.setRoot(session, null);
        this.depth = 0;
        this.updatableIterators.next = this.updatableIterators.last = this.updatableIterators;
    }

    void clearIterators() {
        this.updatableIterators.next = this.updatableIterators.last = this.updatableIterators;
    }

    void setRoot(Session session, Node node) {
        if (this.isTemp) {
            session.setIndexRoot(this.indexName, this.onCommitPreserve, node);
        } else {
            this.root = node;
        }
    }

    int getRoot() {
        return this.root == null ? -1 : this.root.getKey();
    }

    private Node getRoot(Session session) {
        if (this.isTemp && session != null) {
            return session.getIndexRoot(this.indexName, this.onCommitPreserve);
        }
        return this.root;
    }

    void insert(Session session, Row row, int offset) throws HsqlException {
        Node n;
        Node x = n = this.getRoot(session);
        boolean isleft = true;
        int compare = -1;
        while (true) {
            if (n == null) {
                if (x == null) {
                    this.setRoot(session, row.getNode(offset));
                    return;
                }
                break;
            }
            compare = this.compareRowForInsert(session, row, n.getRow());
            if (compare == 0) {
                Constraint c;
                int errorCode = 9;
                String name = this.indexName.statementName;
                if (this.isConstraint && (c = this.table.getUniqueOrPKConstraintForIndex(this)) != null) {
                    name = c.getName().name;
                    errorCode = 104;
                }
                throw Trace.error(errorCode, new Object[]{name, this.getColumnNameList()});
            }
            isleft = compare < 0;
            x = n;
            n = this.child(x, isleft);
        }
        this.set(x, isleft, row.getNode(offset));
        this.balance(session, x, isleft);
    }

    private void balance(Session session, Node x, boolean isleft) throws HsqlException {
        while (true) {
            int sign = isleft ? 1 : -1;
            x = x.getUpdatedNode();
            switch (x.getBalance() * sign) {
                case 1: {
                    x.setBalance(0);
                    return;
                }
                case 0: {
                    x.setBalance(-sign);
                    break;
                }
                case -1: {
                    Node l = this.child(x, isleft);
                    if (l.getBalance() == -sign) {
                        this.replace(session, x, l);
                        this.set(x, isleft, this.child(l, !isleft));
                        this.set(l, !isleft, x);
                        x = x.getUpdatedNode();
                        x.setBalance(0);
                        l = l.getUpdatedNode();
                        l.setBalance(0);
                    } else {
                        Node r = this.child(l, !isleft);
                        this.replace(session, x, r);
                        this.set(l, !isleft, this.child(r.getUpdatedNode(), isleft));
                        this.set(r, isleft, l);
                        this.set(x, isleft, this.child(r.getUpdatedNode(), !isleft));
                        this.set(r, !isleft, x);
                        int rb = r.getUpdatedNode().getBalance();
                        x.getUpdatedNode().setBalance(rb == -sign ? sign : 0);
                        l.getUpdatedNode().setBalance(rb == sign ? -sign : 0);
                        r.getUpdatedNode().setBalance(0);
                    }
                    return;
                }
            }
            x = x.getUpdatedNode();
            if (x.isRoot()) {
                return;
            }
            isleft = x.isFromLeft();
            x = x.getParent();
        }
    }

    void delete(Session session, Node x) throws HsqlException {
        Node n;
        if (x == null) {
            return;
        }
        IndexRowIterator it = this.updatableIterators.next;
        while (it != this.updatableIterators) {
            it.updateForDelete(x);
            it = it.next;
        }
        if (x.getLeft() == null) {
            n = x.getRight();
        } else if (x.getRight() == null) {
            n = x.getLeft();
        } else {
            Node dl;
            Node d = x;
            Node temp = x = x.getLeft();
            while ((temp = temp.getRight()) != null) {
                x = temp;
            }
            n = x.getLeft();
            int b = x.getBalance();
            x = x.getUpdatedNode();
            x.setBalance(d.getBalance());
            d = d.getUpdatedNode();
            d.setBalance(b);
            Node xp = x.getParent();
            Node dp = d.getParent();
            x = x.getUpdatedNode();
            if (d.isRoot()) {
                this.setRoot(session, x);
            }
            x.setParent(dp);
            if (dp != null) {
                if ((dp = dp.getUpdatedNode()).isRight(d)) {
                    dp.setRight(x);
                } else {
                    dp.setLeft(x);
                }
            }
            if ((d = d.getUpdatedNode()).equals(xp)) {
                d.setParent(x);
                if (d.isLeft(x)) {
                    x = x.getUpdatedNode();
                    x.setLeft(d);
                    Node dr = d.getRight();
                    x = x.getUpdatedNode();
                    x.setRight(dr);
                } else {
                    x.setRight(d);
                    dl = d.getLeft();
                    x = x.getUpdatedNode();
                    x.setLeft(dl);
                }
            } else {
                d.setParent(xp);
                xp = xp.getUpdatedNode();
                xp.setRight(d);
                dl = d.getLeft();
                Node dr = d.getRight();
                x = x.getUpdatedNode();
                x.setLeft(dl);
                x.setRight(dr);
            }
            x.getRight().setParent(x);
            x.getLeft().setParent(x);
            d = d.getUpdatedNode();
            d.setLeft(n);
            if (n != null) {
                n = n.getUpdatedNode();
                n.setParent(d);
            }
            d = d.getUpdatedNode();
            d.setRight(null);
            x = d;
        }
        boolean isleft = x.isFromLeft();
        this.replace(session, x, n);
        n = x.getParent();
        x = x.getUpdatedNode();
        x.delete();
        while (n != null) {
            x = n;
            int sign = isleft ? 1 : -1;
            x = x.getUpdatedNode();
            switch (x.getBalance() * sign) {
                case -1: {
                    x.setBalance(0);
                    break;
                }
                case 0: {
                    x.setBalance(sign);
                    return;
                }
                case 1: {
                    Node r = this.child(x, !isleft);
                    int b = r.getBalance();
                    if (b * sign >= 0) {
                        this.replace(session, x, r);
                        this.set(x, !isleft, this.child(r, isleft));
                        this.set(r, isleft, x);
                        if (b == 0) {
                            x = x.getUpdatedNode();
                            x.setBalance(sign);
                            r = r.getUpdatedNode();
                            r.setBalance(-sign);
                            return;
                        }
                        x = x.getUpdatedNode();
                        x.setBalance(0);
                        r = r.getUpdatedNode();
                        r.setBalance(0);
                        x = r;
                        break;
                    }
                    Node l = this.child(r, isleft);
                    this.replace(session, x, l);
                    l = l.getUpdatedNode();
                    b = l.getBalance();
                    this.set(r, isleft, this.child(l, !isleft));
                    this.set(l, !isleft, r);
                    this.set(x, !isleft, this.child(l, isleft));
                    this.set(l, isleft, x);
                    x = x.getUpdatedNode();
                    x.setBalance(b == sign ? -sign : 0);
                    r = r.getUpdatedNode();
                    r.setBalance(b == -sign ? sign : 0);
                    l = l.getUpdatedNode();
                    l.setBalance(0);
                    x = l;
                }
            }
            isleft = x.isFromLeft();
            n = x.getParent();
        }
    }

    RowIterator findFirstRow(Session session, Object[] rowdata, int[] rowColMap) throws HsqlException {
        Node node = this.findNotNull(session, rowdata, rowColMap, true);
        return this.getIterator(session, node);
    }

    RowIterator findFirstRowForDelete(Session session, Object[] rowdata, int[] rowColMap) throws HsqlException {
        Node node = this.findNotNull(session, rowdata, rowColMap, true);
        IndexRowIterator it = this.getIterator(session, node);
        if (node != null) {
            this.updatableIterators.link(it);
        }
        return it;
    }

    Row findRow(Session session, Row row) throws HsqlException {
        Node node = this.search(session, row);
        return node == null ? null : node.getRow();
    }

    boolean exists(Session session, Object[] rowdata, int[] rowColMap) throws HsqlException {
        return this.findNotNull(session, rowdata, rowColMap, true) != null;
    }

    RowIterator emptyIterator() {
        return emptyIterator;
    }

    private Node findNotNull(Session session, Object[] rowdata, int[] rowColMap, boolean first) throws HsqlException {
        Node x = this.getRoot(session);
        Node result = null;
        if (Index.isNull(rowdata, rowColMap)) {
            return null;
        }
        while (x != null) {
            Node n;
            int i = this.compareRowNonUnique(session, rowdata, rowColMap, x.getData());
            if (i == 0) {
                if (!first) {
                    result = x;
                    break;
                }
                if (result == x) break;
                result = x;
                n = x.getLeft();
            } else {
                n = i > 0 ? x.getRight() : x.getLeft();
            }
            if (n == null) break;
            x = n;
        }
        return result;
    }

    static boolean isNull(Object[] row, int[] rowColMap) {
        int count = rowColMap.length;
        for (int i = 0; i < count; ++i) {
            if (row[rowColMap[i]] != null) continue;
            return true;
        }
        return false;
    }

    boolean isNull(Object[] row) {
        int count = this.colIndex.length;
        for (int i = 0; i < count; ++i) {
            int j = this.colIndex[i];
            if (row[j] != null) continue;
            return true;
        }
        return false;
    }

    RowIterator findFirstRow(Session session, Object[] rowdata, int count) throws HsqlException {
        boolean unique;
        Node x = this.getRoot(session);
        Node found = null;
        boolean bl = unique = this.isUnique && !this.isNull(rowdata);
        while (x != null) {
            int c = this.compareRowNonUnique(session, rowdata, this.colIndex, x.getData(), count);
            if (c == 0) {
                found = x;
                if (unique) break;
                x = x.getLeft();
                continue;
            }
            if (c < 0) {
                x = x.getLeft();
                continue;
            }
            x = x.getRight();
        }
        return this.getIterator(session, found);
    }

    RowIterator findFirstRow(Session session, Object value, int compare) throws HsqlException {
        boolean isEqual = compare == 21 || compare == 34;
        Node x = this.getRoot(session);
        int iTest = 1;
        if (compare == 23) {
            iTest = 0;
        }
        if (value == null && !isEqual) {
            return emptyIterator;
        }
        while (x != null) {
            boolean t;
            boolean bl = t = Column.compare(this.collation, value, x.getData()[this.colIndex[0]], this.colTypes[0]) >= iTest;
            if (t) {
                Node r = x.getRight();
                if (r == null) break;
                x = r;
                continue;
            }
            Node l = x.getLeft();
            if (l == null) break;
            x = l;
        }
        while (x != null) {
            Object colvalue = x.getData()[this.colIndex[0]];
            int result = Column.compare(this.collation, value, colvalue, this.colTypes[0]);
            if (result >= iTest) {
                x = this.next(x);
                continue;
            }
            if (isEqual) {
                if (result == 0) break;
                x = null;
                break;
            }
            if (colvalue != null) break;
            x = this.next(x);
        }
        return this.getIterator(session, x);
    }

    RowIterator findFirstRowNotNull(Session session) throws HsqlException {
        Object colvalue;
        Node x = this.getRoot(session);
        while (x != null) {
            boolean t;
            boolean bl = t = Column.compare(this.collation, null, x.getData()[this.colIndex[0]], this.colTypes[0]) >= 0;
            if (t) {
                Node r = x.getRight();
                if (r == null) break;
                x = r;
                continue;
            }
            Node l = x.getLeft();
            if (l == null) break;
            x = l;
        }
        while (x != null && (colvalue = x.getData()[this.colIndex[0]]) == null) {
            x = this.next(x);
        }
        return this.getIterator(session, x);
    }

    RowIterator firstRow(Session session) throws HsqlException {
        Node x;
        this.depth = 0;
        Node l = x = this.getRoot(session);
        while (l != null) {
            x = l;
            l = x.getLeft();
            ++this.depth;
        }
        return this.getIterator(session, x);
    }

    Row lastRow(Session session) throws HsqlException {
        Node x;
        Node l = x = this.getRoot(session);
        while (l != null) {
            x = l;
            l = x.getRight();
        }
        return x == null ? null : x.getRow();
    }

    Node next(Node x) throws HsqlException {
        if (x == null) {
            return null;
        }
        Node r = x.getRight();
        if (r != null) {
            x = r;
            Node l = x.getLeft();
            while (l != null) {
                x = l;
                l = x.getLeft();
            }
            return x;
        }
        Node ch = x;
        for (x = x.getParent(); x != null && ch.equals(x.getRight()); x = x.getParent()) {
            ch = x;
        }
        return x;
    }

    private Node child(Node x, boolean isleft) throws HsqlException {
        return isleft ? x.getLeft() : x.getRight();
    }

    private void replace(Session session, Node x, Node n) throws HsqlException {
        if (x.isRoot()) {
            if (n != null) {
                n = n.getUpdatedNode();
                n.setParent(null);
            }
            this.setRoot(session, n);
        } else {
            this.set(x.getParent(), x.isFromLeft(), n);
        }
    }

    private void set(Node x, boolean isleft, Node n) throws HsqlException {
        x = x.getUpdatedNode();
        if (isleft) {
            x.setLeft(n);
        } else {
            x.setRight(n);
        }
        if (n != null) {
            n = n.getUpdatedNode();
            n.setParent(x);
        }
    }

    private Node search(Session session, Row row) throws HsqlException {
        Object[] d = row.getData();
        Node x = this.getRoot(session);
        while (x != null) {
            int c = this.compareRowForInsert(session, row, x.getRow());
            if (c == 0) {
                return x;
            }
            if (c < 0) {
                x = x.getLeft();
                continue;
            }
            x = x.getRight();
        }
        return null;
    }

    int compareRowNonUnique(Session session, Object[] a, int[] rowColMap, Object[] b) throws HsqlException {
        return this.compareRowNonUnique(session, a, rowColMap, b, rowColMap.length);
    }

    int compareRowNonUnique(Session session, Object[] a, int[] rowColMap, Object[] b, int colCount) throws HsqlException {
        int i = Column.compare(this.collation, a[rowColMap[0]], b[this.colIndex[0]], this.colTypes[0]);
        if (i != 0) {
            return i;
        }
        for (int j = 1; j < colCount; ++j) {
            i = Column.compare(this.collation, a[rowColMap[j]], b[this.colIndex[j]], this.colTypes[j]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    static int compareRows(Session session, Object[] a, Object[] b, int[] cols, int[] coltypes) throws HsqlException {
        int fieldcount = cols.length;
        for (int j = 0; j < fieldcount; ++j) {
            int i = Column.compare(session.database.collation, a[cols[j]], b[cols[j]], coltypes[cols[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    private int compareRowForInsert(Session session, Row newRow, Row existingRow) throws HsqlException {
        int i;
        Object currentvalue;
        int j;
        Object[] a = newRow.getData();
        Object[] b = existingRow.getData();
        boolean hasNull = false;
        for (j = 0; j < this.colIndex.length; ++j) {
            currentvalue = a[this.colIndex[j]];
            i = Column.compare(this.collation, currentvalue, b[this.colIndex[j]], this.colTypes[j]);
            if (i != 0) {
                return i;
            }
            if (currentvalue != null) continue;
            hasNull = true;
        }
        if (this.isUnique && !this.useRowId && !hasNull) {
            return 0;
        }
        for (j = 0; j < this.pkCols.length; ++j) {
            currentvalue = a[this.pkCols[j]];
            i = Column.compare(this.collation, currentvalue, b[this.pkCols[j]], this.pkTypes[j]);
            if (i == 0) continue;
            return i;
        }
        if (this.useRowId) {
            int difference = newRow.getPos() - existingRow.getPos();
            if (difference < 0) {
                difference = -1;
            } else if (difference > 0) {
                difference = 1;
            }
            return difference;
        }
        return 0;
    }

    int getIndexOrderValue() {
        boolean value = false;
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    private IndexRowIterator getIterator(Session session, Node x) {
        if (x == null) {
            return emptyIterator;
        }
        IndexRowIterator it = new IndexRowIterator(session, this, x);
        return it;
    }

    static class IndexRowIterator
    implements RowIterator {
        Session session;
        Index index;
        Node nextnode;
        protected IndexRowIterator last;
        protected IndexRowIterator next;

        private IndexRowIterator(Session session, Index index, Node node) {
            if (index == null) {
                return;
            }
            this.session = session;
            this.index = index;
            this.nextnode = node;
        }

        public boolean hasNext() {
            return this.nextnode != null;
        }

        public Row next() {
            if (this.hasNext()) {
                try {
                    Row row = this.nextnode.getRow();
                    this.nextnode = this.index.next(this.nextnode);
                    return row;
                }
                catch (Exception e) {
                    throw new NoSuchElementException(e.getMessage());
                }
            }
            return null;
        }

        void updateForDelete(Node node) {
            try {
                if (node.equals(this.nextnode)) {
                    this.nextnode = this.index.next(node);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void link(IndexRowIterator other) {
            other.next = this.next;
            other.last = this;
            this.next.last = other;
            this.next = other;
        }

        public void release() {
            if (this.last != null) {
                this.last.next = this.next;
            }
            if (this.next != null) {
                this.next.last = this.last;
            }
        }
    }
}

