/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.GranteeManager;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.HsqlNameManager;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.lib.HashSet;
import com.fr.third.org.hsqldb.lib.IntValueHashMap;
import com.fr.third.org.hsqldb.lib.Iterator;
import com.fr.third.org.hsqldb.lib.Set;

public class Grantee {
    boolean isRole;
    private boolean isAdminDirect = false;
    private boolean isAdmin = false;
    private IntValueHashMap fullRightsMap = new IntValueHashMap();
    private String granteeName;
    private IntValueHashMap rightsMap;
    HashSet roles = new HashSet();
    private Grantee pubGrantee;
    private GranteeManager granteeManager;

    Grantee(String name, Grantee inGrantee, GranteeManager man) throws HsqlException {
        this.rightsMap = new IntValueHashMap();
        this.granteeName = name;
        this.granteeManager = man;
        this.pubGrantee = inGrantee;
    }

    String getName() {
        return this.granteeName;
    }

    IntValueHashMap getRights() {
        return this.rightsMap;
    }

    public void grant(String role) throws HsqlException {
        this.roles.add(role);
    }

    public void revoke(String role) throws HsqlException {
        if (!this.hasRoleDirect(role)) {
            throw Trace.error(246, role);
        }
        this.roles.remove(role);
    }

    public HashSet getDirectRoles() {
        return this.roles;
    }

    String getDirectRolesString() {
        return this.setToString(this.roles);
    }

    String getAllRolesString() {
        return this.setToString(this.getAllRoles());
    }

    public String setToString(Set set) {
        Iterator it = set.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public HashSet getAllRoles() {
        HashSet newSet = new HashSet();
        this.addGranteeAndRoles(newSet);
        newSet.remove(this.granteeName);
        return newSet;
    }

    private HashSet addGranteeAndRoles(HashSet set) {
        set.add(this.granteeName);
        Iterator it = this.roles.iterator();
        while (it.hasNext()) {
            String candidateRole = (String)it.next();
            if (set.contains(candidateRole)) continue;
            try {
                this.granteeManager.getRole(candidateRole).addGranteeAndRoles(set);
            }
            catch (HsqlException he) {
                throw new RuntimeException(he.getMessage());
            }
        }
        return set;
    }

    public boolean hasRoleDirect(String role) {
        return this.roles.contains(role);
    }

    public boolean hasRole(String role) {
        return this.getAllRoles().contains(role);
    }

    public String allRolesString() {
        HashSet allRoles = this.getAllRoles();
        if (allRoles.size() < 1) {
            return null;
        }
        Iterator it = this.getAllRoles().iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append((String)it.next());
        }
        return sb.toString();
    }

    void grant(Object dbobject, int rights) {
        if (rights == 0) {
            return;
        }
        int n = this.rightsMap.get(dbobject, 0);
        this.rightsMap.put(dbobject, n |= rights);
    }

    void revoke(Object dbobject, int rights) {
        if (rights == 0) {
            return;
        }
        int n = this.rightsMap.get(dbobject, 0);
        if (n == 0) {
            return;
        }
        if ((rights = n & 15 - rights) == 0) {
            this.rightsMap.remove(dbobject);
        } else {
            this.rightsMap.put(dbobject, rights);
        }
    }

    void revokeDbObject(Object dbobject) {
        this.rightsMap.remove(dbobject);
        this.fullRightsMap.remove(dbobject);
    }

    void clearPrivileges() {
        this.roles.clear();
        this.rightsMap.clear();
        this.fullRightsMap.clear();
        this.isAdminDirect = false;
    }

    void check(HsqlNameManager.HsqlName dbobject, int rights) throws HsqlException {
        if (!this.isAccessible(dbobject, rights)) {
            throw Trace.error(33);
        }
    }

    void check(String dbobject) throws HsqlException {
        if (!this.isAccessible(dbobject)) {
            throw Trace.error(33);
        }
    }

    boolean isAccessible(HsqlNameManager.HsqlName dbObject, int rights) throws HsqlException {
        if (this.isAdmin) {
            return true;
        }
        if (this.pubGrantee != null && this.pubGrantee.isAccessible(dbObject, rights)) {
            return true;
        }
        int n = this.fullRightsMap.get((Object)dbObject, 0);
        if (n != 0) {
            return (n & rights) != 0;
        }
        return false;
    }

    boolean isAccessible(String functionName) throws HsqlException {
        if (functionName.startsWith("com.fr.third.org.hsqldb.Library") || functionName.startsWith("java.lang.Math")) {
            return true;
        }
        if (this.isAdmin) {
            return true;
        }
        if (this.pubGrantee != null && this.pubGrantee.isAccessible(functionName)) {
            return true;
        }
        int n = this.fullRightsMap.get((Object)functionName, 0);
        return n != 0;
    }

    protected boolean isDirectlyAccessible(Object dbObject, int rights) throws HsqlException {
        int n = this.rightsMap.get(dbObject, 0);
        if (n != 0) {
            return (n & rights) != 0;
        }
        return false;
    }

    boolean isAccessible(HsqlNameManager.HsqlName dbObject) throws HsqlException {
        return this.isAccessible(dbObject, 15);
    }

    void checkAdmin() throws HsqlException {
        if (!this.isAdmin()) {
            throw Trace.error(33);
        }
    }

    boolean isAdmin() {
        return this.isAdmin;
    }

    boolean isAdminDirect() {
        return this.isAdminDirect;
    }

    HashSet getGrantedClassNames(boolean andToPublic) throws HsqlException {
        IntValueHashMap rights = this.rightsMap;
        HashSet out = this.getGrantedClassNamesDirect();
        if (andToPublic && this.pubGrantee != null) {
            rights = this.pubGrantee.rightsMap;
            Iterator i = rights.keySet().iterator();
            while (i.hasNext()) {
                int right;
                Object key = i.next();
                if (!(key instanceof String) || (right = rights.get(key, 0)) != 15) continue;
                out.add(key);
            }
        }
        Iterator it = this.getAllRoles().iterator();
        while (it.hasNext()) {
            out.addAll(this.granteeManager.getRole((String)it.next()).getGrantedClassNamesDirect());
        }
        return out;
    }

    HashSet getGrantedClassNamesDirect() throws HsqlException {
        IntValueHashMap rights = this.rightsMap;
        HashSet out = new HashSet();
        Iterator i = this.rightsMap.keySet().iterator();
        while (i.hasNext()) {
            int right;
            Object key = i.next();
            if (!(key instanceof String) || (right = rights.get(key, 0)) != 15) continue;
            out.add(key);
        }
        return out;
    }

    String[] listGrantedTablePrivileges(HsqlNameManager.HsqlName name) {
        return GranteeManager.getRightsArray(this.rightsMap.get((Object)name, 0));
    }

    void setAdminDirect() {
        this.isAdminDirect = true;
        this.isAdmin = true;
    }

    boolean updateNestedRoles(String role) {
        boolean hasNested = false;
        boolean isSelf = role.equals(this.granteeName);
        if (!isSelf) {
            Iterator it = this.roles.iterator();
            while (it.hasNext()) {
                String roleName = (String)it.next();
                try {
                    Grantee currentRole = this.granteeManager.getRole(roleName);
                    hasNested |= currentRole.updateNestedRoles(role);
                }
                catch (HsqlException e) {}
            }
        }
        if (hasNested) {
            this.updateAllRights();
        }
        return hasNested || isSelf;
    }

    void updateAllRights() {
        this.fullRightsMap.clear();
        this.isAdmin = this.isAdminDirect;
        Iterator it = this.roles.iterator();
        while (it.hasNext()) {
            String roleName = (String)it.next();
            try {
                Grantee currentRole = this.granteeManager.getRole(roleName);
                this.fullRightsMap.putAll(currentRole.fullRightsMap);
                this.isAdmin |= currentRole.isAdmin();
            }
            catch (HsqlException hsqlException) {}
        }
        this.fullRightsMap.putAll(this.rightsMap);
    }
}

