/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.Server;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.lib.FileUtil;
import com.fr.third.org.hsqldb.lib.HashMap;
import com.fr.third.org.hsqldb.lib.HashSet;
import com.fr.third.org.hsqldb.lib.HsqlTimer;
import com.fr.third.org.hsqldb.lib.IntKeyHashMap;
import com.fr.third.org.hsqldb.lib.Iterator;
import com.fr.third.org.hsqldb.persist.HsqlProperties;
import com.fr.third.org.hsqldb.store.BaseHashMap;
import com.fr.third.org.hsqldb.store.ValuePool;
import java.util.Vector;

public class DatabaseManager {
    private static int dbIDCounter;
    static final HashMap memDatabaseMap;
    static final HashMap fileDatabaseMap;
    static final HashMap resDatabaseMap;
    static final IntKeyHashMap databaseIDMap;
    static HashMap serverMap;
    private static final HsqlTimer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getDatabaseURIs() {
        Vector<String> v = new Vector<String>();
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator it = databaseIDMap.values().iterator();
            while (it.hasNext()) {
                Database db = (Database)it.next();
                v.addElement(db.getURI());
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDatabases(int mode) {
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator it = databaseIDMap.values().iterator();
            while (it.hasNext()) {
                Database db = (Database)it.next();
                try {
                    db.close(mode);
                }
                catch (HsqlException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Session newSession(int dbID, String user, String password) throws HsqlException {
        Database db = null;
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            db = (Database)databaseIDMap.get(dbID);
        }
        return db == null ? null : db.connect(user, password);
    }

    public static Session newSession(String type, String path, String user, String password, HsqlProperties props) throws HsqlException {
        Database db = DatabaseManager.getDatabase(type, path, props);
        return db == null ? null : db.connect(user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Session getSession(int dbId, int sessionId) {
        Database db = null;
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            db = (Database)databaseIDMap.get(dbId);
        }
        return db == null ? null : db.sessionManager.getSession(sessionId);
    }

    static int getDatabase(String type, String path, Server server, HsqlProperties props) throws HsqlException {
        Database db = DatabaseManager.getDatabase(type, path, props);
        DatabaseManager.registerServer(server, db);
        return db.databaseID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Database getDatabase(String type, String path, HsqlProperties props) throws HsqlException {
        Database db;
        Database database = db = DatabaseManager.getDatabaseObject(type, path, props);
        synchronized (database) {
            switch (db.getState()) {
                case 1: {
                    break;
                }
                case 16: {
                    if (DatabaseManager.lookupDatabaseObject(type, path) == null) {
                        DatabaseManager.addDatabaseObject(type, path, db);
                    }
                    db.open();
                    break;
                }
                case 4: 
                case 8: {
                    throw Trace.error(1, 107);
                }
            }
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static synchronized Database getDatabaseObject(String type, String path, HsqlProperties props) throws HsqlException {
        void var5_4;
        HashMap databaseMap;
        String key = path;
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.getDatabaseObject");
        }
        Database db = (Database)var5_4.get(key);
        if (db == null) {
            db = new Database(type, path, key, props);
            db.databaseID = dbIDCounter;
            IntKeyHashMap intKeyHashMap = databaseIDMap;
            synchronized (intKeyHashMap) {
                databaseIDMap.put(dbIDCounter, db);
                ++dbIDCounter;
            }
            var5_4.put(key, db);
        }
        return db;
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized Database lookupDatabaseObject(String type, String path) throws HsqlException {
        void var3_3;
        HashMap databaseMap;
        String key = path;
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.lookupDatabaseObject()");
        }
        return (Database)var3_3.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static synchronized void addDatabaseObject(String type, String path, Database db) throws HsqlException {
        void var4_4;
        HashMap databaseMap;
        String key = path;
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.addDatabaseObject()");
        }
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            databaseIDMap.put(db.databaseID, db);
        }
        var4_4.put(key, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static void removeDatabase(Database database) {
        void var5_5;
        BaseHashMap baseHashMap;
        HashMap databaseMap;
        String path;
        int dbID = database.databaseID;
        String type = database.getType();
        String key = path = database.getPath();
        DatabaseManager.notifyServers(database);
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            try {
                key = DatabaseManager.filePathToKey(path);
            }
            catch (HsqlException e) {
                baseHashMap = databaseMap;
                synchronized (baseHashMap) {
                    Iterator it = databaseMap.keySet().iterator();
                    Object foundKey = null;
                    while (it.hasNext()) {
                        Object currentKey = it.next();
                        if (databaseMap.get(currentKey) != database) continue;
                        foundKey = currentKey;
                        break;
                    }
                    if (foundKey != null) {
                        key = foundKey;
                    }
                }
            }
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.lookupDatabaseObject()");
        }
        boolean isEmpty = false;
        baseHashMap = databaseIDMap;
        synchronized (baseHashMap) {
            databaseIDMap.remove(dbID);
            isEmpty = databaseIDMap.isEmpty();
        }
        baseHashMap = var5_5;
        synchronized (baseHashMap) {
            var5_5.remove(key);
        }
        if (isEmpty) {
            ValuePool.resetPool();
        }
    }

    static void deRegisterServer(Server server) {
        serverMap.remove(server);
    }

    private static void deRegisterServer(Server server, Database db) {
        Iterator it = serverMap.values().iterator();
        while (it.hasNext()) {
            HashSet databases = (HashSet)it.next();
            databases.remove(db);
            if (!databases.isEmpty()) continue;
            it.remove();
        }
    }

    private static void registerServer(Server server, Database db) {
        if (!serverMap.containsKey(server)) {
            serverMap.put(server, new HashSet());
        }
        HashSet databases = (HashSet)serverMap.get(server);
        databases.add(db);
    }

    private static void notifyServers(Database db) {
        Iterator it = serverMap.keySet().iterator();
        while (it.hasNext()) {
            Server server = (Server)it.next();
            HashSet databases = (HashSet)serverMap.get(server);
            if (!databases.contains(db)) continue;
            server.notify(0, db.databaseID);
        }
    }

    static boolean isServerDB(Database db) {
        Iterator it = serverMap.keySet().iterator();
        while (it.hasNext()) {
            Server server = (Server)it.next();
            HashSet databases = (HashSet)serverMap.get(server);
            if (!databases.contains(db)) continue;
            return true;
        }
        return false;
    }

    public static HsqlTimer getTimer() {
        return timer;
    }

    private static String filePathToKey(String path) throws HsqlException {
        try {
            return FileUtil.getDefaultInstance().canonicalOrAbsolutePath(path);
        }
        catch (Exception e) {
            throw Trace.error(29, e.toString());
        }
    }

    static {
        memDatabaseMap = new HashMap();
        fileDatabaseMap = new HashMap();
        resDatabaseMap = new HashMap();
        databaseIDMap = new IntKeyHashMap();
        serverMap = new HashMap();
        timer = new HsqlTimer();
    }
}

