/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.CompiledStatement;
import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.HsqlNameManager;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.lib.IntKeyHashMap;
import com.fr.third.org.hsqldb.lib.IntKeyIntValueHashMap;
import com.fr.third.org.hsqldb.lib.IntValueHashMap;
import com.fr.third.org.hsqldb.lib.Iterator;

final class CompiledStatementManager {
    private Database database;
    private IntKeyHashMap schemaMap;
    private IntKeyHashMap sqlLookup;
    private IntKeyHashMap csidMap;
    private IntKeyHashMap sessionUseMap;
    private IntKeyIntValueHashMap useMap;
    private int next_cs_id;

    CompiledStatementManager(Database database) {
        this.database = database;
        this.schemaMap = new IntKeyHashMap();
        this.sqlLookup = new IntKeyHashMap();
        this.csidMap = new IntKeyHashMap();
        this.sessionUseMap = new IntKeyHashMap();
        this.useMap = new IntKeyIntValueHashMap();
        this.next_cs_id = 0;
    }

    synchronized void reset() {
        this.schemaMap.clear();
        this.sqlLookup.clear();
        this.csidMap.clear();
        this.sessionUseMap.clear();
        this.useMap.clear();
        this.next_cs_id = 0;
    }

    synchronized void resetStatements() {
        Iterator it = this.csidMap.values().iterator();
        while (it.hasNext()) {
            CompiledStatement cs = (CompiledStatement)it.next();
            cs.clearVariables();
        }
    }

    private int nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private int getStatementID(HsqlNameManager.HsqlName schema, String sql) {
        IntValueHashMap sqlMap = (IntValueHashMap)this.schemaMap.get(schema.hashCode());
        if (sqlMap == null) {
            return -1;
        }
        return sqlMap.get((Object)sql, -1);
    }

    synchronized CompiledStatement getStatement(Session session, int csid) {
        CompiledStatement cs = (CompiledStatement)this.csidMap.get(csid);
        if (cs == null) {
            return null;
        }
        if (!cs.isValid) {
            String sql = (String)this.sqlLookup.get(csid);
            try {
                cs = this.compileSql(session, sql, cs.schemaHsqlName.name);
                cs.id = csid;
                this.csidMap.put(csid, cs);
            }
            catch (Throwable t) {
                this.freeStatement(csid, session.getId(), true);
                return null;
            }
        }
        return cs;
    }

    private void linkSession(int csid, int sid) {
        IntKeyIntValueHashMap scsMap = (IntKeyIntValueHashMap)this.sessionUseMap.get(sid);
        if (scsMap == null) {
            scsMap = new IntKeyIntValueHashMap();
            this.sessionUseMap.put(sid, scsMap);
        }
        int count = scsMap.get(csid, 0);
        scsMap.put(csid, count + 1);
        if (count == 0) {
            this.useMap.put(csid, this.useMap.get(csid, 0) + 1);
        }
    }

    private int registerStatement(int csid, CompiledStatement cs) {
        if (csid < 0) {
            csid = this.nextID();
            int schemaid = cs.schemaHsqlName.hashCode();
            IntValueHashMap sqlMap = (IntValueHashMap)this.schemaMap.get(schemaid);
            if (sqlMap == null) {
                sqlMap = new IntValueHashMap();
                this.schemaMap.put(schemaid, sqlMap);
            }
            sqlMap.put(cs.sql, csid);
            this.sqlLookup.put(csid, cs.sql);
        }
        cs.id = csid;
        this.csidMap.put(csid, cs);
        return csid;
    }

    void freeStatement(int csid, int sid, boolean freeAll) {
        if (csid == -1) {
            return;
        }
        IntKeyIntValueHashMap scsMap = (IntKeyIntValueHashMap)this.sessionUseMap.get(sid);
        if (scsMap == null) {
            return;
        }
        int sessionUseCount = scsMap.get(csid, 0);
        if (sessionUseCount != 0) {
            if (sessionUseCount == 1 || freeAll) {
                scsMap.remove(csid);
                int usecount = this.useMap.get(csid, 0);
                if (usecount != 0) {
                    if (usecount == 1) {
                        CompiledStatement cs = (CompiledStatement)this.csidMap.remove(csid);
                        if (cs != null) {
                            int schemaid = cs.schemaHsqlName.hashCode();
                            IntValueHashMap sqlMap = (IntValueHashMap)this.schemaMap.get(schemaid);
                            String sql = (String)this.sqlLookup.remove(csid);
                            sqlMap.remove(sql);
                        }
                        this.useMap.remove(csid);
                    } else {
                        this.useMap.put(csid, usecount - 1);
                    }
                }
            } else {
                scsMap.put(csid, sessionUseCount - 1);
            }
        }
    }

    synchronized void removeSession(int sid) {
        IntKeyIntValueHashMap scsMap = (IntKeyIntValueHashMap)this.sessionUseMap.remove(sid);
        if (scsMap == null) {
            return;
        }
        Iterator i = scsMap.keySet().iterator();
        while (i.hasNext()) {
            int csid = i.nextInt();
            int usecount = this.useMap.get(csid, 1) - 1;
            if (usecount == 0) {
                CompiledStatement cs = (CompiledStatement)this.csidMap.remove(csid);
                if (cs != null) {
                    int schemaid = cs.schemaHsqlName.hashCode();
                    IntValueHashMap sqlMap = (IntValueHashMap)this.schemaMap.get(schemaid);
                    String sql = (String)this.sqlLookup.remove(csid);
                    sqlMap.remove(sql);
                }
                this.useMap.remove(csid);
                continue;
            }
            this.useMap.put(csid, usecount);
        }
    }

    synchronized CompiledStatement compile(Session session, String sql) throws Throwable {
        int csid = this.getStatementID(session.currentSchema, sql);
        CompiledStatement cs = (CompiledStatement)this.csidMap.get(csid);
        if (cs == null || !cs.isValid || !session.isAdmin()) {
            cs = this.compileSql(session, sql, session.currentSchema.name);
            csid = this.registerStatement(csid, cs);
        }
        this.linkSession(csid, session.getId());
        return cs;
    }

    private CompiledStatement compileSql(Session session, String sql, String schemaName) throws Throwable {
        Session sys = this.database.sessionManager.getSysSession(schemaName, session.getUser());
        return sys.sqlCompileStatement(sql);
    }
}

