/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.record.CFHeaderRecord;
import com.fr.third.org.apache.poi.hssf.record.CFRuleRecord;
import com.fr.third.org.apache.poi.hssf.record.aggregates.CFRecordsAggregate;
import com.fr.third.org.apache.poi.hssf.record.cf.CellRange;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingRule;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.Region;

public final class HSSFConditionalFormatting {
    private final HSSFWorkbook _workbook;
    private final CFRecordsAggregate cfAggregate;

    HSSFConditionalFormatting(HSSFWorkbook workbook, CFRecordsAggregate cfAggregate) {
        if (workbook == null) {
            throw new IllegalArgumentException("workbook must not be null");
        }
        if (cfAggregate == null) {
            throw new IllegalArgumentException("cfAggregate must not be null");
        }
        this._workbook = workbook;
        this.cfAggregate = cfAggregate;
    }

    CFRecordsAggregate getCFRecordsAggregate() {
        return this.cfAggregate;
    }

    public Region[] getFormattingRegions() {
        CFHeaderRecord cfh = this.cfAggregate.getHeader();
        CellRange[] cellRanges = cfh.getCellRanges();
        return CellRange.convertCellRangesToRegions(cellRanges);
    }

    public void setRule(int idx, HSSFConditionalFormattingRule cfRule) {
        this.cfAggregate.setRule(idx, cfRule.getCfRuleRecord());
    }

    public void addRule(HSSFConditionalFormattingRule cfRule) {
        this.cfAggregate.addRule(cfRule.getCfRuleRecord());
    }

    public HSSFConditionalFormattingRule getRule(int idx) {
        CFRuleRecord ruleRecord = this.cfAggregate.getRule(idx);
        return new HSSFConditionalFormattingRule(this._workbook, ruleRecord);
    }

    public int getNumberOfRules() {
        return this.cfAggregate.getNumberOfRules();
    }

    public String toString() {
        return this.cfAggregate.toString();
    }
}

