/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public abstract class XYNumericFunction
implements Function {
    protected static final int X = 0;
    protected static final int Y = 1;

    public final Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        double[][] values;
        if (args.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            values = XYNumericFunction.getValues(args[0], args[1]);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        if (values == null || values[0] == null || values[1] == null || values[0].length == 0 || values[1].length == 0 || values[0].length != values[1].length) {
            return ErrorEval.VALUE_INVALID;
        }
        double d = this.evaluate(values[0], values[1]);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(d);
    }

    protected abstract double evaluate(double[] var1, double[] var2);

    private static double[][] getNumberArray(Eval[] xops, Eval[] yops) throws EvaluationException {
        Eval eval;
        int i;
        int nArrayItems = xops.length;
        if (nArrayItems != yops.length) {
            throw new EvaluationException(ErrorEval.NA);
        }
        for (i = 0; i < xops.length; ++i) {
            eval = xops[i];
            if (!(eval instanceof ErrorEval)) continue;
            throw new EvaluationException((ErrorEval)eval);
        }
        for (i = 0; i < yops.length; ++i) {
            eval = yops[i];
            if (!(eval instanceof ErrorEval)) continue;
            throw new EvaluationException((ErrorEval)eval);
        }
        double[] xResult = new double[nArrayItems];
        double[] yResult = new double[nArrayItems];
        int count = 0;
        int iSize = nArrayItems;
        for (int i2 = 0; i2 < iSize; ++i2) {
            Eval xEval = xops[i2];
            Eval yEval = yops[i2];
            if (!XYNumericFunction.isNumberEval(xEval) || !XYNumericFunction.isNumberEval(yEval)) continue;
            xResult[count] = XYNumericFunction.getDoubleValue(xEval);
            yResult[count] = XYNumericFunction.getDoubleValue(yEval);
            if (Double.isNaN(xResult[count]) || Double.isNaN(xResult[count])) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            ++count;
        }
        return new double[][]{XYNumericFunction.trimToSize(xResult, count), XYNumericFunction.trimToSize(yResult, count)};
    }

    private static double[][] getValues(Eval argX, Eval argY) throws EvaluationException {
        Eval[] yEvals;
        Eval[] xEvals;
        AreaEval ae;
        if (argX instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)argX);
        }
        if (argY instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)argY);
        }
        if (argX instanceof AreaEval) {
            ae = (AreaEval)argX;
            xEvals = ae.getValues();
        } else {
            xEvals = new Eval[]{argX};
        }
        if (argY instanceof AreaEval) {
            ae = (AreaEval)argY;
            yEvals = ae.getValues();
        } else {
            yEvals = new Eval[]{argY};
        }
        return XYNumericFunction.getNumberArray(xEvals, yEvals);
    }

    private static double[] trimToSize(double[] arr, int len) {
        double[] tarr = arr;
        if (arr.length > len) {
            tarr = new double[len];
            System.arraycopy(arr, 0, tarr, 0, len);
        }
        return tarr;
    }

    private static boolean isNumberEval(Eval eval) {
        boolean retval = false;
        if (eval instanceof NumberEval) {
            retval = true;
        } else if (eval instanceof RefEval) {
            RefEval re = (RefEval)eval;
            ValueEval ve = re.getInnerValueEval();
            retval = ve instanceof NumberEval;
        }
        return retval;
    }

    private static double getDoubleValue(Eval eval) {
        double retval = 0.0;
        if (eval instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval;
            retval = ne.getNumberValue();
        } else if (eval instanceof RefEval) {
            RefEval re = (RefEval)eval;
            ValueEval ve = re.getInnerValueEval();
            retval = ve instanceof NumberEval ? ((NumberEval)ve).getNumberValue() : Double.NaN;
        } else if (eval instanceof ErrorEval) {
            retval = Double.NaN;
        }
        return retval;
    }

    protected static final class DoubleArrayPair {
        private final double[] _xArray;
        private final double[] _yArray;

        public DoubleArrayPair(double[] xArray, double[] yArray) {
            this._xArray = xArray;
            this._yArray = yArray;
        }

        public double[] getXArray() {
            return this._xArray;
        }

        public double[] getYArray() {
            return this._yArray;
        }
    }
}

