/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.FinanceFunction;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.FinanceLib;

public final class Pmt
extends FinanceFunction {
    public Eval evaluate(Eval[] args, int srcRow, short srcCol) {
        if (args.length < 3 || args.length > 5) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double rate = this.evalArg(args[0], srcRow, srcCol);
            double nper = this.evalArg(args[1], srcRow, srcCol);
            double pv = this.evalArg(args[2], srcRow, srcCol);
            double fv = 0.0;
            boolean arePaymentsAtPeriodBeginning = false;
            switch (args.length) {
                case 5: {
                    ValueEval ve = this.singleOperandNumericAsBoolean(args[4], srcRow, srcCol);
                    if (ve instanceof ErrorEval) {
                        return ve;
                    }
                    arePaymentsAtPeriodBeginning = ((BoolEval)ve).getBooleanValue();
                }
                case 4: {
                    fv = this.evalArg(args[3], srcRow, srcCol);
                }
            }
            double d = FinanceLib.pmt(rate, nper, pv, fv, arePaymentsAtPeriodBeginning);
            if (Double.isNaN(d)) {
                return ErrorEval.VALUE_INVALID;
            }
            if (Double.isInfinite(d)) {
                return ErrorEval.NUM_ERROR;
            }
            return new NumberEval(d);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private double evalArg(Eval arg, int srcRow, short srcCol) throws EvaluationException {
        ValueEval ve = this.singleOperandEvaluate(arg, srcRow, srcCol);
        if (ve instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)ve);
        }
        if (ve instanceof NumericValueEval) {
            return ((NumericValueEval)ve).getNumberValue();
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }
}

