/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.eval;

import com.fr.third.org.apache.poi.hssf.record.formula.PercentPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericOperationEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;

public final class PercentEval
extends NumericOperationEval {
    private PercentPtg _delegate;
    private static final ValueEvalToNumericXlator NUM_XLATOR = new ValueEvalToNumericXlator(27);

    public PercentEval(Ptg ptg) {
        this._delegate = (PercentPtg)ptg;
    }

    protected ValueEvalToNumericXlator getXlator() {
        return NUM_XLATOR;
    }

    public Eval evaluate(Eval[] args, int srcRow, short srcCol) {
        if (args.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        ValueEval ve = this.singleOperandEvaluate(args[0], srcRow, srcCol);
        if (ve instanceof NumericValueEval) {
            double d0 = ((NumericValueEval)ve).getNumberValue();
            return new NumberEval(d0 / 100.0);
        }
        if (ve instanceof BlankEval) {
            return NumberEval.ZERO;
        }
        if (ve instanceof ErrorEval) {
            return ve;
        }
        return ErrorEval.VALUE_INVALID;
    }

    public int getNumberOfOperands() {
        return this._delegate.getNumberOfOperands();
    }

    public int getType() {
        return this._delegate.getType();
    }
}

