/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.eval;

import com.fr.third.org.apache.poi.hssf.record.formula.DividePtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericOperationEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;

public final class DivideEval
extends NumericOperationEval {
    private DividePtg delegate;
    private static final ValueEvalToNumericXlator NUM_XLATOR = new ValueEvalToNumericXlator(27);

    public DivideEval(Ptg ptg) {
        this.delegate = (DividePtg)ptg;
    }

    protected ValueEvalToNumericXlator getXlator() {
        return NUM_XLATOR;
    }

    public Eval evaluate(Eval[] args, int srcRow, short srcCol) {
        if (args.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        ErrorEval retval = null;
        double d0 = 0.0;
        double d1 = 0.0;
        ValueEval ve = this.singleOperandEvaluate(args[0], srcRow, srcCol);
        if (ve instanceof NumericValueEval) {
            d0 = ((NumericValueEval)ve).getNumberValue();
        } else if (!(ve instanceof BlankEval)) {
            retval = ErrorEval.VALUE_INVALID;
        }
        if (retval == null) {
            ve = this.singleOperandEvaluate(args[1], srcRow, srcCol);
            if (ve instanceof NumericValueEval) {
                d1 = ((NumericValueEval)ve).getNumberValue();
            } else if (!(ve instanceof BlankEval)) {
                retval = ErrorEval.VALUE_INVALID;
            }
        }
        if (retval == null) {
            retval = d1 == 0.0 ? ErrorEval.DIV_ZERO : (Double.isNaN(d0) || Double.isNaN(d1) ? ErrorEval.VALUE_INVALID : new NumberEval(d0 / d1));
        }
        return retval;
    }

    public int getNumberOfOperands() {
        return this.delegate.getNumberOfOperands();
    }

    public int getType() {
        return this.delegate.getType();
    }
}

