/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaI;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ref3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.SheetNameFormatter;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.AreaReference;
import com.fr.third.org.apache.poi.hssf.util.CellReference;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class Area3DPtg
extends OperandPtg
implements AreaI {
    public static final byte sid = 59;
    private static final int SIZE = 11;
    private short field_1_index_extern_sheet;
    private int field_2_first_row;
    private int field_3_last_row;
    private int field_4_first_column;
    private int field_5_last_column;
    private BitField rowRelative = BitFieldFactory.getInstance(32768);
    private BitField colRelative = BitFieldFactory.getInstance(16384);

    public Area3DPtg() {
    }

    public Area3DPtg(String arearef, short externIdx) {
        this.setArea(arearef);
        this.setExternSheetIndex(externIdx);
    }

    public Area3DPtg(RecordInputStream in) {
        this.field_1_index_extern_sheet = in.readShort();
        this.field_2_first_row = in.readUShort();
        this.field_3_last_row = in.readUShort();
        this.field_4_first_column = in.readUShort();
        this.field_5_last_column = in.readUShort();
    }

    public Area3DPtg(short firstRow, short lastRow, short firstColumn, short lastColumn, boolean firstRowRelative, boolean lastRowRelative, boolean firstColRelative, boolean lastColRelative, short externalSheetIndex) {
        this.setFirstRow(firstRow);
        this.setLastRow(lastRow);
        this.setFirstColumn(firstColumn);
        this.setLastColumn(lastColumn);
        this.setFirstRowRelative(firstRowRelative);
        this.setLastRowRelative(lastRowRelative);
        this.setFirstColRelative(firstColRelative);
        this.setLastColRelative(lastColRelative);
        this.setExternSheetIndex(externalSheetIndex);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append("sheetIx=").append(this.getExternSheetIndex());
        sb.append(" ! ");
        sb.append(AreaReference.formatAsString(this));
        sb.append("]");
        return sb.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[0 + offset] = (byte)(59 + this.getPtgClass());
        LittleEndian.putShort(array, 1 + offset, this.getExternSheetIndex());
        LittleEndian.putShort(array, 3 + offset, (short)this.getFirstRow());
        LittleEndian.putShort(array, 5 + offset, (short)this.getLastRow());
        LittleEndian.putShort(array, 7 + offset, (short)this.getFirstColumnRaw());
        LittleEndian.putShort(array, 9 + offset, (short)this.getLastColumnRaw());
    }

    public int getSize() {
        return 11;
    }

    public short getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    public void setExternSheetIndex(short index) {
        this.field_1_index_extern_sheet = index;
    }

    public int getFirstRow() {
        return this.field_2_first_row;
    }

    public void setFirstRow(int row) {
        this.field_2_first_row = row;
    }

    public int getLastRow() {
        return this.field_3_last_row;
    }

    public void setLastRow(int row) {
        this.field_3_last_row = row;
    }

    public int getFirstColumn() {
        return this.field_4_first_column & 0xFF;
    }

    public int getFirstColumnRaw() {
        return this.field_4_first_column;
    }

    public boolean isFirstRowRelative() {
        return this.rowRelative.isSet(this.field_4_first_column);
    }

    public boolean isFirstColRelative() {
        return this.colRelative.isSet(this.field_4_first_column);
    }

    public void setFirstColumn(short column) {
        this.field_4_first_column &= 0xFF00;
        this.field_4_first_column |= column & 0xFF;
    }

    public void setFirstColumnRaw(short column) {
        this.field_4_first_column = column;
    }

    public int getLastColumn() {
        return this.field_5_last_column & 0xFF;
    }

    public int getLastColumnRaw() {
        return this.field_5_last_column;
    }

    public boolean isLastRowRelative() {
        return this.rowRelative.isSet(this.field_5_last_column);
    }

    public boolean isLastColRelative() {
        return this.colRelative.isSet(this.field_5_last_column);
    }

    public void setLastColumn(short column) {
        this.field_5_last_column &= 0xFF00;
        this.field_5_last_column |= column & 0xFF;
    }

    public void setLastColumnRaw(short column) {
        this.field_5_last_column = column;
    }

    public void setFirstRowRelative(boolean rel) {
        this.field_4_first_column = this.rowRelative.setBoolean(this.field_4_first_column, rel);
    }

    public void setFirstColRelative(boolean rel) {
        this.field_4_first_column = this.colRelative.setBoolean(this.field_4_first_column, rel);
    }

    public void setLastRowRelative(boolean rel) {
        this.field_5_last_column = this.rowRelative.setBoolean(this.field_5_last_column, rel);
    }

    public void setLastColRelative(boolean rel) {
        this.field_5_last_column = this.colRelative.setBoolean(this.field_5_last_column, rel);
    }

    public void setArea(String ref) {
        AreaReference ar = new AreaReference(ref);
        CellReference frstCell = ar.getFirstCell();
        CellReference lastCell = ar.getLastCell();
        this.setFirstRow((short)frstCell.getRow());
        this.setFirstColumn(frstCell.getCol());
        this.setLastRow((short)lastCell.getRow());
        this.setLastColumn(lastCell.getCol());
        this.setFirstColRelative(!frstCell.isColAbsolute());
        this.setLastColRelative(!lastCell.isColAbsolute());
        this.setFirstRowRelative(!frstCell.isRowAbsolute());
        this.setLastRowRelative(!lastCell.isRowAbsolute());
    }

    public String toFormulaString(HSSFWorkbook book) {
        StringBuffer retval = new StringBuffer();
        String sheetName = Ref3DPtg.getSheetName(book, this.field_1_index_extern_sheet);
        if (sheetName != null) {
            if (sheetName.length() == 0) {
                sheetName = "#REF";
                retval.append(sheetName);
            } else {
                SheetNameFormatter.appendFormat(retval, sheetName);
            }
            retval.append('!');
        }
        retval.append(AreaReference.formatAsString(this));
        return retval.toString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Area3DPtg)) {
            return false;
        }
        Area3DPtg area3DPtg = (Area3DPtg)o;
        if (this.field_1_index_extern_sheet != area3DPtg.field_1_index_extern_sheet) {
            return false;
        }
        if (this.field_2_first_row != area3DPtg.field_2_first_row) {
            return false;
        }
        if (this.field_3_last_row != area3DPtg.field_3_last_row) {
            return false;
        }
        if (this.field_4_first_column != area3DPtg.field_4_first_column) {
            return false;
        }
        return this.field_5_last_column == area3DPtg.field_5_last_column;
    }
}

