/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import com.fr.third.org.apache.poi.hssf.record.BOFRecord;
import com.fr.third.org.apache.poi.hssf.record.BackupRecord;
import com.fr.third.org.apache.poi.hssf.record.BlankRecord;
import com.fr.third.org.apache.poi.hssf.record.BookBoolRecord;
import com.fr.third.org.apache.poi.hssf.record.BoolErrRecord;
import com.fr.third.org.apache.poi.hssf.record.BottomMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.BoundSheetRecord;
import com.fr.third.org.apache.poi.hssf.record.CFHeaderRecord;
import com.fr.third.org.apache.poi.hssf.record.CFRuleRecord;
import com.fr.third.org.apache.poi.hssf.record.CRNCountRecord;
import com.fr.third.org.apache.poi.hssf.record.CRNRecord;
import com.fr.third.org.apache.poi.hssf.record.CalcCountRecord;
import com.fr.third.org.apache.poi.hssf.record.CalcModeRecord;
import com.fr.third.org.apache.poi.hssf.record.ChartRecord;
import com.fr.third.org.apache.poi.hssf.record.ChartTitleFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.CodepageRecord;
import com.fr.third.org.apache.poi.hssf.record.ColumnInfoRecord;
import com.fr.third.org.apache.poi.hssf.record.ContinueRecord;
import com.fr.third.org.apache.poi.hssf.record.CountryRecord;
import com.fr.third.org.apache.poi.hssf.record.DBCellRecord;
import com.fr.third.org.apache.poi.hssf.record.DSFRecord;
import com.fr.third.org.apache.poi.hssf.record.DVALRecord;
import com.fr.third.org.apache.poi.hssf.record.DVRecord;
import com.fr.third.org.apache.poi.hssf.record.DateWindow1904Record;
import com.fr.third.org.apache.poi.hssf.record.DefaultColWidthRecord;
import com.fr.third.org.apache.poi.hssf.record.DefaultRowHeightRecord;
import com.fr.third.org.apache.poi.hssf.record.DeltaRecord;
import com.fr.third.org.apache.poi.hssf.record.DimensionsRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingGroupRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingSelectionRecord;
import com.fr.third.org.apache.poi.hssf.record.EOFRecord;
import com.fr.third.org.apache.poi.hssf.record.ExtSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.ExtendedFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.ExternSheetRecord;
import com.fr.third.org.apache.poi.hssf.record.ExternalNameRecord;
import com.fr.third.org.apache.poi.hssf.record.FilePassRecord;
import com.fr.third.org.apache.poi.hssf.record.FileSharingRecord;
import com.fr.third.org.apache.poi.hssf.record.FnGroupCountRecord;
import com.fr.third.org.apache.poi.hssf.record.FontRecord;
import com.fr.third.org.apache.poi.hssf.record.FooterRecord;
import com.fr.third.org.apache.poi.hssf.record.FormatRecord;
import com.fr.third.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.GridsetRecord;
import com.fr.third.org.apache.poi.hssf.record.GutsRecord;
import com.fr.third.org.apache.poi.hssf.record.HCenterRecord;
import com.fr.third.org.apache.poi.hssf.record.HeaderRecord;
import com.fr.third.org.apache.poi.hssf.record.HideObjRecord;
import com.fr.third.org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import com.fr.third.org.apache.poi.hssf.record.HyperlinkRecord;
import com.fr.third.org.apache.poi.hssf.record.IndexRecord;
import com.fr.third.org.apache.poi.hssf.record.InterfaceEndRecord;
import com.fr.third.org.apache.poi.hssf.record.InterfaceHdrRecord;
import com.fr.third.org.apache.poi.hssf.record.IterationRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.LeftMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.LegendRecord;
import com.fr.third.org.apache.poi.hssf.record.MMSRecord;
import com.fr.third.org.apache.poi.hssf.record.MergeCellsRecord;
import com.fr.third.org.apache.poi.hssf.record.MulBlankRecord;
import com.fr.third.org.apache.poi.hssf.record.MulRKRecord;
import com.fr.third.org.apache.poi.hssf.record.NameRecord;
import com.fr.third.org.apache.poi.hssf.record.NoteRecord;
import com.fr.third.org.apache.poi.hssf.record.NumberRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjectProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.PaletteRecord;
import com.fr.third.org.apache.poi.hssf.record.PaneRecord;
import com.fr.third.org.apache.poi.hssf.record.PasswordRecord;
import com.fr.third.org.apache.poi.hssf.record.PasswordRev4Record;
import com.fr.third.org.apache.poi.hssf.record.PrecisionRecord;
import com.fr.third.org.apache.poi.hssf.record.PrintGridlinesRecord;
import com.fr.third.org.apache.poi.hssf.record.PrintHeadersRecord;
import com.fr.third.org.apache.poi.hssf.record.PrintSetupRecord;
import com.fr.third.org.apache.poi.hssf.record.ProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.ProtectionRev4Record;
import com.fr.third.org.apache.poi.hssf.record.RKRecord;
import com.fr.third.org.apache.poi.hssf.record.RecalcIdRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.RefModeRecord;
import com.fr.third.org.apache.poi.hssf.record.RefreshAllRecord;
import com.fr.third.org.apache.poi.hssf.record.RightMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.RowRecord;
import com.fr.third.org.apache.poi.hssf.record.SSTRecord;
import com.fr.third.org.apache.poi.hssf.record.SaveRecalcRecord;
import com.fr.third.org.apache.poi.hssf.record.ScenarioProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.SelectionRecord;
import com.fr.third.org.apache.poi.hssf.record.SeriesRecord;
import com.fr.third.org.apache.poi.hssf.record.SeriesTextRecord;
import com.fr.third.org.apache.poi.hssf.record.SharedFormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.StringRecord;
import com.fr.third.org.apache.poi.hssf.record.StyleRecord;
import com.fr.third.org.apache.poi.hssf.record.SupBookRecord;
import com.fr.third.org.apache.poi.hssf.record.TabIdRecord;
import com.fr.third.org.apache.poi.hssf.record.TextObjectRecord;
import com.fr.third.org.apache.poi.hssf.record.TopMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.UncalcedRecord;
import com.fr.third.org.apache.poi.hssf.record.UnknownRecord;
import com.fr.third.org.apache.poi.hssf.record.UseSelFSRecord;
import com.fr.third.org.apache.poi.hssf.record.VCenterRecord;
import com.fr.third.org.apache.poi.hssf.record.VerticalPageBreakRecord;
import com.fr.third.org.apache.poi.hssf.record.WSBoolRecord;
import com.fr.third.org.apache.poi.hssf.record.WindowOneRecord;
import com.fr.third.org.apache.poi.hssf.record.WindowProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.WindowTwoRecord;
import com.fr.third.org.apache.poi.hssf.record.WriteAccessRecord;
import com.fr.third.org.apache.poi.hssf.record.WriteProtectRecord;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RecordFactory {
    private static int NUM_RECORDS = 10000;
    private static final Class[] records = new Class[]{BOFRecord.class, InterfaceHdrRecord.class, MMSRecord.class, InterfaceEndRecord.class, WriteAccessRecord.class, CodepageRecord.class, DSFRecord.class, TabIdRecord.class, FnGroupCountRecord.class, WindowProtectRecord.class, ProtectRecord.class, PasswordRecord.class, ProtectionRev4Record.class, PasswordRev4Record.class, WindowOneRecord.class, BackupRecord.class, HideObjRecord.class, DateWindow1904Record.class, PrecisionRecord.class, RefreshAllRecord.class, BookBoolRecord.class, FontRecord.class, FormatRecord.class, ExtendedFormatRecord.class, StyleRecord.class, UseSelFSRecord.class, BoundSheetRecord.class, CountryRecord.class, SSTRecord.class, ExtSSTRecord.class, EOFRecord.class, IndexRecord.class, CalcModeRecord.class, CalcCountRecord.class, RefModeRecord.class, IterationRecord.class, DeltaRecord.class, SaveRecalcRecord.class, PrintHeadersRecord.class, PrintGridlinesRecord.class, GridsetRecord.class, GutsRecord.class, DefaultRowHeightRecord.class, WSBoolRecord.class, HeaderRecord.class, FooterRecord.class, HCenterRecord.class, VCenterRecord.class, PrintSetupRecord.class, DefaultColWidthRecord.class, DimensionsRecord.class, RowRecord.class, LabelSSTRecord.class, RKRecord.class, NumberRecord.class, DBCellRecord.class, WindowTwoRecord.class, SelectionRecord.class, ContinueRecord.class, LabelRecord.class, BlankRecord.class, ColumnInfoRecord.class, MulRKRecord.class, MulBlankRecord.class, MergeCellsRecord.class, FormulaRecord.class, BoolErrRecord.class, ExternSheetRecord.class, NameRecord.class, LeftMarginRecord.class, RightMarginRecord.class, TopMarginRecord.class, BottomMarginRecord.class, DrawingRecord.class, DrawingGroupRecord.class, DrawingSelectionRecord.class, ObjRecord.class, TextObjectRecord.class, PaletteRecord.class, StringRecord.class, RecalcIdRecord.class, SharedFormulaRecord.class, HorizontalPageBreakRecord.class, VerticalPageBreakRecord.class, WriteProtectRecord.class, FilePassRecord.class, PaneRecord.class, NoteRecord.class, ObjectProtectRecord.class, ScenarioProtectRecord.class, FileSharingRecord.class, ChartTitleFormatRecord.class, DVRecord.class, DVALRecord.class, UncalcedRecord.class, ChartRecord.class, LegendRecord.class, ChartTitleFormatRecord.class, SeriesRecord.class, SeriesTextRecord.class, HyperlinkRecord.class, ExternalNameRecord.class, SupBookRecord.class, CRNCountRecord.class, CRNRecord.class, CFHeaderRecord.class, CFRuleRecord.class};
    private static Map recordsMap = RecordFactory.recordsToMap(records);
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$RecordInputStream;

    public static void setCapacity(int capacity) {
        NUM_RECORDS = capacity;
    }

    public static List createRecords(InputStream in) throws RecordFormatException {
        ArrayList<Record> records = new ArrayList<Record>(NUM_RECORDS);
        RecordInputStream recStream = new RecordInputStream(in);
        DrawingRecord lastDrawingRecord = new DrawingRecord();
        Record lastRecord = null;
        while (recStream.hasNextRecord()) {
            recStream.nextRecord();
            if (recStream.getSid() == 0) continue;
            Record[] recs = RecordFactory.createRecord(recStream);
            if (recs.length > 1) {
                for (int k = 0; k < recs.length; ++k) {
                    records.add(recs[k]);
                }
                continue;
            }
            Record record = recs[0];
            if (record == null) continue;
            if (record.getSid() == 235 && lastRecord instanceof DrawingGroupRecord) {
                DrawingGroupRecord lastDGRecord = (DrawingGroupRecord)lastRecord;
                lastDGRecord.join((AbstractEscherHolderRecord)record);
                continue;
            }
            if (record.getSid() == 60 && (lastRecord instanceof ObjRecord || lastRecord instanceof TextObjectRecord)) {
                lastDrawingRecord.processContinueRecord(((ContinueRecord)record).getData());
                records.add(record);
                continue;
            }
            if (record.getSid() == 60 && lastRecord instanceof DrawingGroupRecord) {
                ((DrawingGroupRecord)lastRecord).processContinueRecord(((ContinueRecord)record).getData());
                continue;
            }
            if (record.getSid() == 60 && lastRecord instanceof StringRecord) {
                ((StringRecord)lastRecord).processContinueRecord(((ContinueRecord)record).getData());
                continue;
            }
            if (record.getSid() == 60) {
                if (lastRecord instanceof UnknownRecord) {
                    records.add(record);
                    continue;
                }
                throw new RecordFormatException("Unhandled Continue Record");
            }
            lastRecord = record;
            if (record instanceof DrawingRecord) {
                lastDrawingRecord = (DrawingRecord)record;
            }
            records.add(record);
        }
        return records;
    }

    public static Record[] createRecord(RecordInputStream in) {
        Record retval;
        Record[] realretval = null;
        try {
            Constructor constructor = (Constructor)recordsMap.get(new Short(in.getSid()));
            retval = constructor != null ? (Record)constructor.newInstance(in) : new UnknownRecord(in);
        }
        catch (Exception introspectionException) {
            throw new RecordFormatException("Unable to construct record instance", introspectionException);
        }
        if (retval instanceof RKRecord) {
            RKRecord rk = (RKRecord)retval;
            NumberRecord num = new NumberRecord();
            num.setColumn(rk.getColumn());
            num.setRow(rk.getRow());
            num.setXFIndex(rk.getXFIndex());
            num.setValue(rk.getRKNumber());
            retval = num;
        } else if (retval instanceof DBCellRecord) {
            retval = null;
        } else if (retval instanceof MulRKRecord) {
            MulRKRecord mrk = (MulRKRecord)retval;
            realretval = new Record[mrk.getNumColumns()];
            for (int k = 0; k < mrk.getNumColumns(); ++k) {
                NumberRecord nr = new NumberRecord();
                nr.setColumn((short)(k + mrk.getFirstColumn()));
                nr.setRow(mrk.getRow());
                nr.setXFIndex(mrk.getXFAt(k));
                nr.setValue(mrk.getRKNumberAt(k));
                realretval[k] = nr;
            }
        } else if (retval instanceof MulBlankRecord) {
            MulBlankRecord mb = (MulBlankRecord)retval;
            realretval = new Record[mb.getNumColumns()];
            for (int k = 0; k < mb.getNumColumns(); ++k) {
                BlankRecord br = new BlankRecord();
                br.setColumn((short)(k + mb.getFirstColumn()));
                br.setRow(mb.getRow());
                br.setXFIndex(mb.getXFAt(k));
                realretval[k] = br;
            }
        }
        if (realretval == null) {
            realretval = new Record[]{retval};
        }
        return realretval;
    }

    public static short[] getAllKnownRecordSIDs() {
        short[] results = new short[recordsMap.size()];
        int i = 0;
        Iterator iterator = recordsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Short sid = (Short)iterator.next();
            results[i++] = sid;
        }
        return results;
    }

    private static Map recordsToMap(Class[] records) {
        HashMap result = new HashMap();
        for (int i = 0; i < records.length; ++i) {
            Constructor constructor;
            short sid;
            Class record = records[i];
            try {
                sid = record.getField("sid").getShort(null);
                constructor = record.getConstructor(class$com$fr$third$org$apache$poi$hssf$record$RecordInputStream == null ? RecordFactory.class$("com.fr.third.org.apache.poi.hssf.record.RecordInputStream") : class$com$fr$third$org$apache$poi$hssf$record$RecordInputStream);
            }
            catch (Exception illegalArgumentException) {
                throw new RecordFormatException("Unable to determine record types", illegalArgumentException);
            }
            result.put(new Short(sid), constructor);
        }
        return result;
    }
}

