/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class NoteRecord
extends Record {
    public static final short sid = 28;
    public static final short NOTE_HIDDEN = 0;
    public static final short NOTE_VISIBLE = 2;
    private short field_1_row;
    private short field_2_col;
    private short field_3_flags;
    private short field_4_shapeid;
    private String field_5_author;

    public NoteRecord() {
        this.field_5_author = "";
        this.field_3_flags = 0;
    }

    public NoteRecord(RecordInputStream in) {
        super(in);
    }

    public short getSid() {
        return 28;
    }

    protected void validateSid(short id) {
        if (id != 28) {
            throw new RecordFormatException("Not a NoteRecord record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_row = in.readShort();
        this.field_2_col = in.readShort();
        this.field_3_flags = in.readShort();
        this.field_4_shapeid = in.readShort();
        short length = in.readShort();
        byte[] bytes = in.readRemainder();
        this.field_5_author = new String(bytes, 1, (int)length);
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)28);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_row);
        LittleEndian.putShort(data, 6 + offset, this.field_2_col);
        LittleEndian.putShort(data, 8 + offset, this.field_3_flags);
        LittleEndian.putShort(data, 10 + offset, this.field_4_shapeid);
        LittleEndian.putShort(data, 12 + offset, (short)this.field_5_author.length());
        byte[] str = this.field_5_author.getBytes();
        System.arraycopy(str, 0, data, 15 + offset, str.length);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 15 + this.field_5_author.length() + 1;
        return retval;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[NOTE]\n");
        buffer.append("    .recordid = 0x" + Integer.toHexString(this.getSid()) + ", size = " + this.getRecordSize() + "\n");
        buffer.append("    .row =     " + this.field_1_row + "\n");
        buffer.append("    .col =     " + this.field_2_col + "\n");
        buffer.append("    .flags =   " + this.field_3_flags + "\n");
        buffer.append("    .shapeid = " + this.field_4_shapeid + "\n");
        buffer.append("    .author =  " + this.field_5_author + "\n");
        buffer.append("[/NOTE]\n");
        return buffer.toString();
    }

    public short getRow() {
        return this.field_1_row;
    }

    public void setRow(short row) {
        this.field_1_row = row;
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public void setColumn(short col) {
        this.field_2_col = col;
    }

    public short getFlags() {
        return this.field_3_flags;
    }

    public void setFlags(short flags) {
        this.field_3_flags = flags;
    }

    public short getShapeId() {
        return this.field_4_shapeid;
    }

    public void setShapeId(short id) {
        this.field_4_shapeid = id;
    }

    public String getAuthor() {
        return this.field_5_author;
    }

    public void setAuthor(String author) {
        this.field_5_author = author;
    }

    public Object clone() {
        NoteRecord rec = new NoteRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_col = this.field_2_col;
        rec.field_3_flags = this.field_3_flags;
        rec.field_4_shapeid = this.field_4_shapeid;
        rec.field_5_author = this.field_5_author;
        return rec;
    }
}

