/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class FrameRecord
extends Record {
    public static final short sid = 4146;
    private short field_1_borderType;
    public static final short BORDER_TYPE_REGULAR = 0;
    public static final short BORDER_TYPE_SHADOW = 1;
    private short field_2_options;
    private BitField autoSize = BitFieldFactory.getInstance(1);
    private BitField autoPosition = BitFieldFactory.getInstance(2);

    public FrameRecord() {
    }

    public FrameRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4146) {
            throw new RecordFormatException("Not a Frame record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_borderType = in.readShort();
        this.field_2_options = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FRAME]\n");
        buffer.append("    .borderType           = ").append("0x").append(HexDump.toHex(this.getBorderType())).append(" (").append(this.getBorderType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .autoSize                 = ").append(this.isAutoSize()).append('\n');
        buffer.append("         .autoPosition             = ").append(this.isAutoPosition()).append('\n');
        buffer.append("[/FRAME]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4146);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_borderType);
        LittleEndian.putShort(data, 6 + offset + pos, this.field_2_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 4146;
    }

    public Object clone() {
        FrameRecord rec = new FrameRecord();
        rec.field_1_borderType = this.field_1_borderType;
        rec.field_2_options = this.field_2_options;
        return rec;
    }

    public short getBorderType() {
        return this.field_1_borderType;
    }

    public void setBorderType(short field_1_borderType) {
        this.field_1_borderType = field_1_borderType;
    }

    public short getOptions() {
        return this.field_2_options;
    }

    public void setOptions(short field_2_options) {
        this.field_2_options = field_2_options;
    }

    public void setAutoSize(boolean value) {
        this.field_2_options = this.autoSize.setShortBoolean(this.field_2_options, value);
    }

    public boolean isAutoSize() {
        return this.autoSize.isSet(this.field_2_options);
    }

    public void setAutoPosition(boolean value) {
        this.field_2_options = this.autoPosition.setShortBoolean(this.field_2_options, value);
    }

    public boolean isAutoPosition() {
        return this.autoPosition.isSet(this.field_2_options);
    }
}

